/*
 * Decompiled with CFR 0.152.
 */
package jam.maconly;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import java.io.File;
import javax.swing.JMenuBar;

public class NewOSXAdapter
implements AboutHandler,
PreferencesHandler,
AppReOpenedListener,
OpenFilesHandler,
PrintFilesHandler,
QuitHandler {
    private static NewOSXAdapter theAdapter;
    private static com.apple.eawt.Application theApplication;
    private Application application;

    private NewOSXAdapter(Application application) {
        this.application = application;
    }

    public static void registerMacOSXApplication(Application application) {
        if (theApplication == null) {
            theApplication = com.apple.eawt.Application.getApplication();
        }
        if (theAdapter == null) {
            theAdapter = new NewOSXAdapter(application);
        }
        theApplication.setAboutHandler((AboutHandler)theAdapter);
        theApplication.setOpenFileHandler((OpenFilesHandler)theAdapter);
        theApplication.setPreferencesHandler((PreferencesHandler)theAdapter);
        theApplication.setPrintFileHandler((PrintFilesHandler)theAdapter);
        theApplication.setQuitHandler((QuitHandler)theAdapter);
        JMenuBar jMenuBar = new JMenuBar();
        if (Application.getMenuBarFactory() != null) {
            Application.getMenuBarFactory().populateMenuBar(jMenuBar, null);
            theApplication.setDefaultMenuBar(jMenuBar);
        }
    }

    public void handleAbout(AppEvent.AboutEvent aboutEvent) {
        if (this.application == null) {
            throw new IllegalStateException("handleAbout: Application instance detached from listener");
        }
        this.application.doAbout();
    }

    public void appReOpened(AppEvent.AppReOpenedEvent appReOpenedEvent) {
    }

    public void openFiles(AppEvent.OpenFilesEvent openFilesEvent) {
        for (File file : openFilesEvent.getFiles()) {
            this.application.doOpenFile(file);
        }
    }

    public void handlePreferences(AppEvent.PreferencesEvent preferencesEvent) {
        if (this.application == null) {
            throw new IllegalStateException("handlePreferences: Application instance detached from listener");
        }
        this.application.doPreferences();
    }

    public void printFiles(AppEvent.PrintFilesEvent printFilesEvent) {
        for (File file : printFilesEvent.getFiles()) {
            DocumentFrame documentFrame = this.application.doOpenFile(file);
            if (documentFrame == null) continue;
            documentFrame.doPrint();
        }
    }

    public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
        if (this.application == null) {
            throw new IllegalStateException("handleQuit: Application instance detached from listener");
        }
        this.application.doQuit();
    }
}

