/*
 * Decompiled with CFR 0.152.
 */
package jam.mac;

import jam.framework.AbstractFrame;
import jam.framework.Application;
import jam.framework.MenuBarFactory;
import jam.framework.MenuFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MacFileMenuFactory
implements MenuFactory {
    private final boolean isMultiDocument;

    public MacFileMenuFactory(boolean bl) {
        this.isMultiDocument = bl;
    }

    public String getMenuName() {
        return "File";
    }

    public void populateMenu(JMenu jMenu, AbstractFrame abstractFrame) {
        JMenuItem jMenuItem;
        Application application = Application.getApplication();
        if (this.isMultiDocument) {
            jMenuItem = new JMenuItem(application.getNewAction());
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, MenuBarFactory.MENU_MASK));
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(application.getOpenAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, MenuBarFactory.MENU_MASK));
        jMenu.add(jMenuItem);
        if (application.getRecentFileMenu() != null) {
            JMenu jMenu2 = application.getRecentFileMenu();
            jMenu.add(jMenu2);
        }
        jMenu.addSeparator();
        if (abstractFrame != null) {
            jMenuItem = new JMenuItem(abstractFrame.getCloseWindowAction());
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, MenuBarFactory.MENU_MASK));
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(abstractFrame.getSaveAction());
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, MenuBarFactory.MENU_MASK));
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(abstractFrame.getSaveAsAction());
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, MenuBarFactory.MENU_MASK + 1));
            jMenu.add(jMenuItem);
        } else {
            jMenuItem = new JMenuItem("Close");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, MenuBarFactory.MENU_MASK));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, MenuBarFactory.MENU_MASK));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save As...");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, MenuBarFactory.MENU_MASK + 1));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Revert to Saved");
        jMenuItem.setEnabled(false);
        jMenu.add(jMenuItem);
        if (abstractFrame != null && (abstractFrame.getImportAction() != null || abstractFrame.getExportAction() != null)) {
            jMenu.addSeparator();
            if (abstractFrame.getImportAction() != null) {
                jMenuItem = new JMenuItem(abstractFrame.getImportAction());
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, MenuBarFactory.MENU_MASK));
                jMenu.add(jMenuItem);
            }
            if (abstractFrame.getExportAction() != null) {
                jMenuItem = new JMenuItem(abstractFrame.getExportAction());
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, MenuBarFactory.MENU_MASK));
                jMenu.add(jMenuItem);
            }
        }
        jMenu.addSeparator();
        if (abstractFrame != null) {
            jMenuItem = new JMenuItem(abstractFrame.getPrintAction());
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, MenuBarFactory.MENU_MASK));
            jMenu.add(jMenuItem);
        } else {
            jMenuItem = new JMenuItem("Print...");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, MenuBarFactory.MENU_MASK));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(application.getPageSetupAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, MenuBarFactory.MENU_MASK + 1));
        jMenu.add(jMenuItem);
    }

    public int getPreferredAlignment() {
        return 0;
    }
}

