/*
 * Decompiled with CFR 0.152.
 */
package figtree.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;

public class ColorWellButton
extends JButton {
    private JColorChooser chooser;
    private String colorChooserTitle;

    public ColorWellButton(Color color, String string) {
        this.colorChooserTitle = string;
        this.putClientProperty("JButton.buttonType", "square");
        this.setBorderPainted(true);
        this.setIcon(new ColorWell(color));
        this.setMargin(new Insets(10, 10, 10, 10));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorWellButton.this.chooserButtonActionPerformed(actionEvent);
            }
        });
    }

    public Color getSelectedColor() {
        return ((ColorWell)this.getIcon()).color;
    }

    public void setSelectedColor(Color color) {
        ((ColorWell)this.getIcon()).color = color;
        this.repaint();
    }

    private void chooserButtonActionPerformed(ActionEvent actionEvent) {
        try {
            Color color;
            if (this.chooser == null) {
                this.chooser = new JColorChooser();
            }
            if ((color = JColorChooser.showDialog(this, this.colorChooserTitle, ((ColorWell)this.getIcon()).color)) != null) {
                this.setSelectedColor(color);
            }
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            JOptionPane.showMessageDialog(this, "JColorChooser Failed " + stringWriter.toString());
            throwable.printStackTrace();
        }
    }

    private class ColorWell
    implements Icon {
        Color color;

        ColorWell(Color color) {
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return 15;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.color == null) {
                return;
            }
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
            graphics.setColor(this.color.darker());
            graphics.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }
}

