/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.treelayouts;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.treelayouts.RectilinearTreeLayout;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RectilinearTreeLayoutController
extends AbstractController {
    private static final String RECTILINEAR_LAYOUT_KEY = "rectilinearLayout";
    private static final String ROOT_LENGTH_KEY = "rootLength";
    private static final String CURVATURE_KEY = "curvature";
    private static final String ALIGN_TIP_LABELS_KEY = "alignTipLabels";
    private final JLabel titleLabel;
    private final OptionsPanel optionsPanel;
    private final JSlider rootLengthSlider;
    private final JSlider curvatureSlider;
    private final JCheckBox alignTipLabelsCheck;
    private final RectilinearTreeLayout treeLayout;

    public RectilinearTreeLayoutController(final RectilinearTreeLayout rectilinearTreeLayout) {
        this.treeLayout = rectilinearTreeLayout;
        this.titleLabel = new JLabel("Rectangular Layout");
        this.optionsPanel = new ControllerOptionsPanel(0, 0);
        this.rootLengthSlider = new JSlider(0, 0, 10000, 0);
        this.rootLengthSlider.setOpaque(false);
        this.rootLengthSlider.setValue((int)(rectilinearTreeLayout.getRootLengthProportion() * 10000.0));
        this.rootLengthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = RectilinearTreeLayoutController.this.rootLengthSlider.getValue();
                rectilinearTreeLayout.setRootLengthProportion(d / 10000.0);
            }
        });
        this.optionsPanel.addComponentWithLabel("Root Length:", this.rootLengthSlider, true);
        this.curvatureSlider = new JSlider(0, 0, 10000, 0);
        this.curvatureSlider.setOpaque(false);
        this.curvatureSlider.setValue((int)(rectilinearTreeLayout.getCurvature() * 10000.0));
        this.curvatureSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = RectilinearTreeLayoutController.this.curvatureSlider.getValue();
                rectilinearTreeLayout.setCurvature(d / 10000.0);
            }
        });
        this.optionsPanel.addComponentWithLabel("Curvature:", this.curvatureSlider, true);
        this.alignTipLabelsCheck = new JCheckBox("Align Tip Labels");
        this.alignTipLabelsCheck.setOpaque(false);
        this.alignTipLabelsCheck.setSelected(rectilinearTreeLayout.isAlignTipLabels());
        this.alignTipLabelsCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                rectilinearTreeLayout.setAlignTipLabels(RectilinearTreeLayoutController.this.alignTipLabelsCheck.isSelected());
            }
        });
        this.optionsPanel.addSpanningComponent(this.alignTipLabelsCheck);
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.rootLengthSlider.setValue((Integer)map.get("rectilinearLayout.rootLength"));
        this.curvatureSlider.setValue((Integer)map.get("rectilinearLayout.curvature"));
        this.alignTipLabelsCheck.setSelected((Boolean)map.get("rectilinearLayout.alignTipLabels"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("rectilinearLayout.rootLength", this.rootLengthSlider.getValue());
        map.put("rectilinearLayout.curvature", this.curvatureSlider.getValue());
        map.put("rectilinearLayout.alignTipLabels", this.alignTipLabelsCheck.isSelected());
    }
}

