/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.treelayouts;

import figtree.treeviewer.treelayouts.TreeLayout;
import figtree.treeviewer.treelayouts.TreeLayoutListener;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractTreeLayout
implements TreeLayout {
    private double rootLength = 0.0;
    private Set<TreeLayoutListener> listeners = new HashSet<TreeLayoutListener>();
    protected String branchColouringAttribute = null;
    protected String cartoonAttributeName = null;
    protected boolean showingCartoonTipLabels = true;
    protected String collapsedAttributeName = null;
    protected String hilightAttributeName = null;

    @Override
    public double getRootLength() {
        return this.rootLength;
    }

    @Override
    public void setRootLength(double d) {
        this.rootLength = d;
        this.fireTreeLayoutChanged();
    }

    @Override
    public void addTreeLayoutListener(TreeLayoutListener treeLayoutListener) {
        this.listeners.add(treeLayoutListener);
    }

    @Override
    public void removeTreeLayoutListener(TreeLayoutListener treeLayoutListener) {
        this.listeners.remove(treeLayoutListener);
    }

    protected void fireTreeLayoutChanged() {
        for (TreeLayoutListener treeLayoutListener : this.listeners) {
            treeLayoutListener.treeLayoutChanged();
        }
    }

    @Override
    public String getBranchColouringAttributeName() {
        return this.branchColouringAttribute;
    }

    @Override
    public void setBranchColouringAttributeName(String string) {
        this.branchColouringAttribute = string;
        this.fireTreeLayoutChanged();
    }

    @Override
    public String getCartoonAttributeName() {
        return this.cartoonAttributeName;
    }

    @Override
    public void setCartoonAttributeName(String string) {
        this.cartoonAttributeName = string;
        this.fireTreeLayoutChanged();
    }

    public boolean isShowingCartoonTipLabels() {
        return this.showingCartoonTipLabels;
    }

    public void setShowingCartoonTipLabels(boolean bl) {
        this.showingCartoonTipLabels = bl;
        this.fireTreeLayoutChanged();
    }

    @Override
    public String getCollapsedAttributeName() {
        return this.collapsedAttributeName;
    }

    @Override
    public void setCollapsedAttributeName(String string) {
        this.collapsedAttributeName = string;
        this.fireTreeLayoutChanged();
    }

    @Override
    public String getHilightAttributeName() {
        return this.hilightAttributeName;
    }

    @Override
    public void setHilightAttributeName(String string) {
        this.hilightAttributeName = string;
        this.fireTreeLayoutChanged();
    }
}

