/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.TreePane;
import figtree.treeviewer.decorators.ContinuousScale;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.NodePainter;
import figtree.treeviewer.painters.Painter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jebl.evolution.graphs.Node;

public class NodeShapePainter
extends NodePainter {
    public static final String FIXED = "Fixed";
    public static final double MAX_SIZE = 4.0;
    public static final double MIN_SIZE = 0.0;
    private double maxSize = 4.0;
    private double minSize = 0.0;
    private ShapeType shapeType = ShapeType.CIRCLE;
    private ScaleType scaleType = ScaleType.WIDTH;
    private String sizeAttribute = null;
    private boolean external = true;
    private boolean internal = true;
    private Decorator colourDecorator = null;
    private ContinuousScale sizeScale = null;
    private float outlineStroke = 0.5f;
    private Paint outlinePaint = Color.black;
    private TreePane treePane;

    @Override
    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, Node node) {
        double d;
        double d2;
        Shape shape;
        Line2D line2D = this.treePane.getTreeLayoutCache().getNodeShapePath(node);
        if (line2D != null && (shape = this.createNodeShape(node, d2 = line2D.getX1(), d = line2D.getY1())) != null) {
            return shape.getBounds2D();
        }
        return null;
    }

    public void setShapeType(ShapeType shapeType) {
        this.shapeType = shapeType;
        this.firePainterChanged();
    }

    public void setScaleType(ScaleType scaleType) {
        this.scaleType = scaleType;
        this.firePainterChanged();
    }

    public void setNodeType(boolean bl, boolean bl2) {
        this.external = bl;
        this.internal = bl2;
        this.firePainterChanged();
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public double getPreferredWidth() {
        return 1.0;
    }

    @Override
    public double getPreferredHeight() {
        return 1.0;
    }

    @Override
    public double getHeightBound() {
        return 1.0;
    }

    public void paint(Graphics2D graphics2D, Node node, Point2D point2D, AffineTransform affineTransform) {
        Shape shape = this.createNodeShape(node, point2D.getX(), point2D.getY());
        shape = affineTransform.createTransformedShape(shape);
        Paint paint = this.getForeground();
        if (this.colourDecorator != null) {
            this.colourDecorator.setItem(node);
            paint = this.colourDecorator.getPaint(paint);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(shape);
        if (this.outlineStroke > 0.0f) {
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(new BasicStroke(this.outlineStroke));
            graphics2D.draw(shape);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D, Node node, Painter.Justification justification, Rectangle2D rectangle2D) {
        throw new UnsupportedOperationException("This version of paint is not used in NodeShapePainter");
    }

    public void setMaxSize(double d) {
        this.maxSize = d;
        this.firePainterChanged();
    }

    public void setMinSize(double d) {
        this.minSize = d;
        this.firePainterChanged();
    }

    public void setSizeAttribute(String string) {
        this.sizeAttribute = string;
        this.sizeScale = new ContinuousScale(string, this.treePane.getTree().getNodes());
        this.firePainterChanged();
    }

    public void setColourDecorator(Decorator decorator) {
        this.colourDecorator = decorator;
        this.firePainterChanged();
    }

    public void setOutline(float f, Paint paint) {
        this.outlineStroke = f;
        this.outlinePaint = paint;
        this.firePainterChanged();
    }

    private Shape createNodeShape(Node node, double d, double d2) {
        Object object;
        double d3 = this.maxSize;
        if (this.sizeAttribute != null && !this.sizeAttribute.equals(FIXED)) {
            object = node.getAttribute(this.sizeAttribute);
            double d4 = this.sizeScale.getValue(object);
            if (this.scaleType == ScaleType.AREA) {
                double d5 = this.getShapeArea(this.minSize);
                double d6 = this.getShapeArea(this.maxSize + this.minSize);
                d3 = this.getShapeWidth((d6 - d5) * d4 + d5);
            } else {
                d3 = this.minSize + this.maxSize * d4;
            }
        }
        if (d3 > 0.0) {
            switch (this.shapeType) {
                case CIRCLE: {
                    return new Ellipse2D.Double(d - d3 * 0.5, d2 - d3 * 0.5, d3, d3);
                }
                case RECTANGLE: {
                    return new Rectangle2D.Double(d - d3 * 0.5, d2 - d3 * 0.5, d3, d3);
                }
                case DIAMOND: {
                    object = new Rectangle2D.Double(d - d3 * 0.5, d2 - d3 * 0.5, d3, d3);
                    return AffineTransform.getRotateInstance(0.7853981633974483, d, d2).createTransformedShape((Shape)object);
                }
            }
            throw new IllegalArgumentException("Unknown node shapeType type");
        }
        return null;
    }

    private double getShapeArea(double d) {
        switch (this.shapeType) {
            case CIRCLE: {
                double d2 = d * 0.5;
                return Math.PI * d2 * d2;
            }
            case RECTANGLE: 
            case DIAMOND: {
                return d * d;
            }
        }
        throw new IllegalArgumentException("Unknown node shapeType type");
    }

    private double getShapeWidth(double d) {
        switch (this.shapeType) {
            case CIRCLE: {
                return 2.0 * Math.sqrt(d / Math.PI);
            }
            case RECTANGLE: 
            case DIAMOND: {
                return Math.sqrt(d);
            }
        }
        throw new IllegalArgumentException("Unknown node shapeType type");
    }

    public static enum ScaleType {
        WIDTH("Width"),
        AREA("Area");

        private final String name;

        private ScaleType(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ShapeType {
        CIRCLE("Circle"),
        RECTANGLE("Rectangle"),
        DIAMOND("Diamond");

        private final String name;

        private ShapeType(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

