/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.AttributeColourController;
import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.decorators.ColourDecorator;
import figtree.treeviewer.painters.AttributeComboHelper;
import figtree.treeviewer.painters.AttributeComboHelperListener;
import figtree.treeviewer.painters.LegendPainter;
import figtree.ui.PercentFormat;
import figtree.ui.RomanFormat;
import jam.controlpalettes.AbstractController;
import jam.controlpalettes.ControllerListener;
import jam.panels.OptionsPanel;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LegendPainterController
extends AbstractController {
    public static Preferences PREFS = Preferences.userNodeForPackage(TreeViewer.class);
    public static final String CONTROLLER_KEY = "legend";
    public static final String FONT_NAME_KEY = "fontName";
    public static final String FONT_SIZE_KEY = "fontSize";
    public static final String FONT_STYLE_KEY = "fontStyle";
    public static final String ATTRIBUTE_KEY = "attribute";
    public static final String NUMBER_FORMATTING_KEY = "numberFormatting";
    public static final String SIGNIFICANT_DIGITS_KEY = "significantDigits";
    public static String DEFAULT_FONT_NAME = "sansserif";
    public static int DEFAULT_FONT_SIZE = 10;
    public static int DEFAULT_FONT_STYLE = 0;
    public static String DEFAULT_ATTRIBUTE_KEY = "";
    public static String DECIMAL_NUMBER_FORMATTING = "#.####";
    public static String SCIENTIFIC_NUMBER_FORMATTING = "0.###E0";
    public static int DEFAULT_SIGNIFICANT_DIGITS = 2;
    public static String DEFAULT_NUMBER_FORMATTING = DECIMAL_NUMBER_FORMATTING;
    private final JCheckBox titleCheckBox;
    private final OptionsPanel optionsPanel;
    private final JComboBox attributeCombo;
    private final JSpinner fontSizeSpinner;
    private final JComboBox numericalFormatCombo;
    private final JSpinner digitsSpinner;

    public LegendPainterController(final LegendPainter legendPainter, final AttributeColourController attributeColourController, TreeViewer treeViewer) {
        String string = PREFS.get("legend.fontName", DEFAULT_FONT_NAME);
        int n = PREFS.getInt("legend.fontStyle", DEFAULT_FONT_STYLE);
        int n2 = PREFS.getInt("legend.fontSize", DEFAULT_FONT_SIZE);
        int n3 = PREFS.getInt("legend.significantDigits", DEFAULT_SIGNIFICANT_DIGITS);
        String string2 = PREFS.get("legend.numberFormatting", DEFAULT_NUMBER_FORMATTING);
        String string3 = PREFS.get("legend.attribute", DEFAULT_ATTRIBUTE_KEY);
        legendPainter.setFont(new Font(string, n, n2));
        legendPainter.setNumberFormat(new DecimalFormat(string2));
        this.optionsPanel = new ControllerOptionsPanel(2, 2);
        this.titleCheckBox = new JCheckBox(this.getTitle());
        this.titleCheckBox.setSelected(legendPainter.isVisible());
        this.attributeCombo = new JComboBox();
        new AttributeComboHelper(this.attributeCombo, treeViewer).addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                ColourDecorator colourDecorator = (ColourDecorator)attributeColourController.getColourDecorator(LegendPainterController.this.attributeCombo, null);
                legendPainter.setColourDecorator(colourDecorator);
            }
        });
        attributeColourController.setupControls(this.attributeCombo, null);
        attributeColourController.addControllerListener(new ControllerListener(){

            @Override
            public void controlsChanged() {
                ColourDecorator colourDecorator = (ColourDecorator)attributeColourController.getColourDecorator(LegendPainterController.this.attributeCombo, null);
                legendPainter.setColourDecorator(colourDecorator);
            }
        });
        Font font = legendPainter.getFont();
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel((double)font.getSize(), 0.01, 48.0, 1.0));
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)LegendPainterController.this.fontSizeSpinner.getValue()).floatValue();
                Font font = legendPainter.getFont().deriveFont(f);
                legendPainter.setFont(font);
            }
        });
        NumberFormat numberFormat = legendPainter.getNumberFormat();
        int n4 = numberFormat.getMaximumFractionDigits();
        this.numericalFormatCombo = new JComboBox<String>(new String[]{"Decimal", "Scientific", "Percent", "Roman"});
        this.numericalFormatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)LegendPainterController.this.numericalFormatCombo.getSelectedItem();
                int n = (Integer)LegendPainterController.this.digitsSpinner.getValue();
                NumberFormat numberFormat = null;
                if (string.equals("Decimal")) {
                    numberFormat = new DecimalFormat(DECIMAL_NUMBER_FORMATTING);
                } else if (string.equals("Scientific")) {
                    numberFormat = new DecimalFormat(SCIENTIFIC_NUMBER_FORMATTING);
                } else if (string.equals("Percent")) {
                    numberFormat = new PercentFormat();
                } else if (string.equals("Roman")) {
                    numberFormat = new RomanFormat();
                }
                ((NumberFormat)numberFormat).setMaximumFractionDigits(n);
                legendPainter.setNumberFormat(numberFormat);
            }
        });
        this.digitsSpinner = new JSpinner(new SpinnerNumberModel(n4, n3, 14, 1));
        this.digitsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)LegendPainterController.this.digitsSpinner.getValue();
                NumberFormat numberFormat = legendPainter.getNumberFormat();
                numberFormat.setMaximumFractionDigits(n);
                legendPainter.setNumberFormat(numberFormat);
            }
        });
        JLabel jLabel = this.optionsPanel.addComponentWithLabel("Attribute:", this.attributeCombo);
        JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Font Size:", this.fontSizeSpinner);
        JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Format:", this.numericalFormatCombo);
        JLabel jLabel4 = this.optionsPanel.addComponentWithLabel("Sig. Digits:", this.digitsSpinner);
        this.addComponent(jLabel);
        this.addComponent(this.attributeCombo);
        this.addComponent(jLabel2);
        this.addComponent(this.fontSizeSpinner);
        this.addComponent(jLabel3);
        this.addComponent(this.numericalFormatCombo);
        this.addComponent(jLabel4);
        this.addComponent(this.digitsSpinner);
        this.enableComponents(this.titleCheckBox.isSelected());
        this.titleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LegendPainterController.this.enableComponents(LegendPainterController.this.titleCheckBox.isSelected());
                legendPainter.setVisible(LegendPainterController.this.titleCheckBox.isSelected());
            }
        });
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleCheckBox;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.titleCheckBox.setSelected((Boolean)map.get("legend.isShown"));
        this.attributeCombo.setSelectedItem((String)map.get("legend.attribute"));
        this.fontSizeSpinner.setValue((Double)map.get("legend.fontSize"));
        this.digitsSpinner.setValue((Integer)map.get("legend.significantDigits"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("legend.isShown", this.titleCheckBox.isSelected());
        map.put("legend.attribute", this.attributeCombo.getSelectedItem());
        map.put("legend.fontSize", this.fontSizeSpinner.getValue());
        map.put("legend.significantDigits", this.digitsSpinner.getValue());
    }

    public String getTitle() {
        return "Legend";
    }
}

