/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.AttributeColourController;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.decorators.ColourDecorator;
import figtree.treeviewer.decorators.ContinuousColourDecorator;
import figtree.treeviewer.decorators.ContinuousScale;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.decorators.DiscreteColourDecorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.Painter;
import figtree.treeviewer.painters.ScalePainter;
import jam.controlpalettes.ControlPalette;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class LegendPainter
extends LabelPainter<TreePane>
implements ScalePainter {
    public static final int CONTINUOUS_LENGTH = 320;
    protected ColourDecorator colourDecorator;
    private double preferredHeight;
    private double preferredWidth;
    protected final AttributeColourController attributeColourController;
    protected TreePane treePane;
    private Decorator textDecorator = null;
    private Decorator borderDecorator = null;
    private Insets insets = new Insets(8, 8, 8, 8);

    public LegendPainter(AttributeColourController attributeColourController) {
        super(null);
        this.attributeColourController = attributeColourController;
    }

    @Override
    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    public Decorator getBorderDecorator() {
        return this.borderDecorator;
    }

    public void setBorderDecorator(Decorator decorator) {
        this.borderDecorator = decorator;
        this.firePainterSettingsChanged();
    }

    public Decorator getTextDecorator() {
        return this.textDecorator;
    }

    @Override
    public void setTextDecorator(Decorator decorator) {
        this.textDecorator = decorator;
        this.firePainterSettingsChanged();
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, TreePane treePane) {
        Font font = graphics2D.getFont();
        if (this.textDecorator != null) {
            graphics2D.setFont(this.textDecorator.getFont(this.getFont()));
        } else {
            graphics2D.setFont(this.getFont());
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.preferredHeight = fontMetrics.getHeight();
        this.preferredWidth = 0.0;
        if (this.colourDecorator instanceof DiscreteColourDecorator) {
            for (Object object : ((DiscreteColourDecorator)this.colourDecorator).getValues()) {
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(object.toString(), graphics2D);
                if (!(rectangle2D.getWidth() > this.preferredWidth)) continue;
                this.preferredWidth = rectangle2D.getWidth();
            }
        } else if (this.colourDecorator instanceof ContinuousColourDecorator) {
            ContinuousScale continuousScale = ((ContinuousColourDecorator)this.colourDecorator).getContinuousScale();
            double d = continuousScale.getMinValue();
            double d2 = continuousScale.getMaxValue();
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.getNumberFormat().format(d2), graphics2D);
            if (rectangle2D.getWidth() > this.preferredWidth) {
                this.preferredWidth = rectangle2D.getWidth();
            }
            if ((rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.getNumberFormat().format(d), graphics2D)).getWidth() > this.preferredWidth) {
                this.preferredWidth = rectangle2D.getWidth();
            }
        } else if (this.colourDecorator != null) {
            throw new IllegalArgumentException("Unrecognized ColourDecorator class");
        }
        graphics2D.setFont(font);
        this.preferredWidth += (double)(this.insets.left + this.insets.right + fontMetrics.getHeight() * 2);
        return new Rectangle2D.Double(0.0, 0.0, this.preferredWidth, this.preferredHeight);
    }

    @Override
    public void paint(Graphics2D graphics2D, TreePane treePane, Painter.Justification justification, Rectangle2D rectangle2D) {
        if (this.colourDecorator == null) {
            return;
        }
        String string = this.colourDecorator.getAttributeName();
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        if (this.getBackground() != null) {
            graphics2D.setPaint(this.getBackground());
            graphics2D.fill(rectangle2D);
        }
        if (this.getBorderPaint() != null && this.getBorderStroke() != null) {
            graphics2D.setPaint(this.getBorderPaint());
            graphics2D.setStroke(this.getBorderStroke());
            graphics2D.draw(rectangle2D);
        }
        graphics2D.setFont(this.getFont());
        Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds("ty", graphics2D);
        float f = this.insets.top;
        float f2 = graphics2D.getFontMetrics().getAscent();
        float f3 = this.insets.left;
        float f4 = (float)rectangle2D2.getHeight() * 1.5f;
        float f5 = (float)((double)this.insets.left + rectangle2D2.getHeight() * 2.0);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.drawString(string, f3, f + f2);
        f += f4;
        if (this.colourDecorator instanceof DiscreteColourDecorator) {
            for (Object object : ((DiscreteColourDecorator)this.colourDecorator).getValues()) {
                graphics2D.setPaint(((DiscreteColourDecorator)this.colourDecorator).getColor(object));
                Rectangle2D.Double double_ = new Rectangle2D.Double(f3, f, rectangle2D2.getHeight(), rectangle2D2.getHeight());
                graphics2D.fill(double_);
                graphics2D.drawString(object.toString(), f5, f + f2);
                f += f4;
            }
        } else if (this.colourDecorator instanceof ContinuousColourDecorator) {
            ContinuousScale continuousScale = ((ContinuousColourDecorator)this.colourDecorator).getContinuousScale();
            double d = continuousScale.getMinValue();
            double d2 = continuousScale.getMaxValue();
            double d3 = (d2 - d) / 320.0;
            rectangle2D2 = graphics2D.getFontMetrics().getStringBounds("0.0", graphics2D);
            float f6 = f;
            double d4 = d2;
            for (int i = 0; i < 320; ++i) {
                graphics2D.setPaint(((ContinuousColourDecorator)this.colourDecorator).getColourForValue(d4));
                Rectangle2D.Double double_ = new Rectangle2D.Double(f3, f, rectangle2D2.getHeight(), 1.0);
                graphics2D.fill(double_);
                f += 1.0f;
                d4 -= d3;
            }
            graphics2D.setPaint(Color.BLACK);
            graphics2D.drawString(this.getNumberFormat().format(d2), f5, f6 + f2 / 2.0f);
            graphics2D.drawString(this.getNumberFormat().format(d), f5, f + f2 / 2.0f);
            Line2D.Double double_ = new Line2D.Double(f3, f6, (double)f3 + rectangle2D2.getHeight() * 1.25, f6);
            graphics2D.draw(double_);
            double_ = new Line2D.Double(f3, f, (double)f3 + rectangle2D2.getHeight() * 1.25, f);
            graphics2D.draw(double_);
            double_ = new Line2D.Double(f3, f6, f3, f);
            graphics2D.draw(double_);
        } else {
            throw new IllegalArgumentException("Unrecognized ColourDecorator class");
        }
        graphics2D.setFont(font);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    @Override
    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public double getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public double getHeightBound() {
        return this.preferredHeight;
    }

    public void setColourDecorator(ColourDecorator colourDecorator) {
        this.colourDecorator = colourDecorator;
        this.firePainterChanged();
    }

    public void setControlPalette(ControlPalette controlPalette) {
    }

    @Override
    public String getDisplayAttribute() {
        throw new UnsupportedOperationException("getDisplayAttribute not implmented");
    }

    @Override
    public void setDisplayAttribute(String string) {
        throw new UnsupportedOperationException("setDisplayAttribute not implmented - use setColourDecorator directly");
    }
}

