/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import figtree.treeviewer.decorators.DiscreteColourDecorator;
import java.awt.Color;
import java.util.Set;
import jebl.util.Attributable;

public class HSBDiscreteColourDecorator
extends DiscreteColourDecorator {
    private Axis primaryAxis = Axis.HUE;
    private int secondaryCount = 1;
    private float hueUpper = 1.0f;
    private float hueLower = 0.0f;
    private float saturationUpper = 0.6f;
    private float saturationLower = 0.6f;
    private float brightnessUpper = 0.8f;
    private float brightnessLower = 0.4f;

    public HSBDiscreteColourDecorator(String string) {
        super(string);
    }

    public HSBDiscreteColourDecorator(String string, String string2) {
        super(string);
        this.setup(string2);
    }

    public HSBDiscreteColourDecorator(String string, Set<? extends Attributable> set) {
        super(string, set);
        this.setupColours();
    }

    @Override
    public void setup(String string) {
        if (!string.startsWith("{") || !string.endsWith("}")) {
            throw new IllegalArgumentException("HSBDiscreteColourDecorator settings string not in correct format");
        }
        String[] stringArray = string.substring(1, string.length() - 1).split("[, ]+");
        if (stringArray.length != 8) {
            throw new IllegalArgumentException("HSBDiscreteColourDecorator settings string not in correct format");
        }
        try {
            this.primaryAxis = Axis.valueOf(stringArray[0].toUpperCase());
            this.secondaryCount = Integer.parseInt(stringArray[1]);
            this.hueLower = Float.parseFloat(stringArray[2]);
            this.hueUpper = Float.parseFloat(stringArray[3]);
            this.saturationLower = Float.parseFloat(stringArray[4]);
            this.saturationUpper = Float.parseFloat(stringArray[5]);
            this.brightnessLower = Float.parseFloat(stringArray[6]);
            this.brightnessUpper = Float.parseFloat(stringArray[7]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("HSBDiscreteColourDecorator settings string not in correct format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("HSBDiscreteColourDecorator settings string not in correct format");
        }
    }

    public void setup(int n, float f, float f2, float f3, float f4, float f5, float f6, Axis axis) {
        this.secondaryCount = n;
        this.hueUpper = f2;
        this.hueLower = f;
        this.saturationUpper = f4;
        this.saturationLower = f3;
        this.brightnessUpper = f6;
        this.brightnessLower = f5;
        this.primaryAxis = axis;
        this.setupColours();
    }

    @Override
    protected void setupColours() {
        if (this.getValues() == null) {
            return;
        }
        if (this.secondaryCount == 0) {
            return;
        }
        int n = this.getValues().size();
        int n2 = n / this.secondaryCount;
        if (n % this.secondaryCount > 0) {
            n2 += this.secondaryCount - n % this.secondaryCount;
        }
        Color[] colorArray = new Color[n2 * this.secondaryCount];
        float f = (this.hueUpper - this.hueLower) / (float)(this.primaryAxis == Axis.HUE ? n2 : this.secondaryCount);
        float f2 = (this.brightnessUpper - this.brightnessLower) / (float)(this.primaryAxis == Axis.BRIGHTNESS ? n2 : this.secondaryCount);
        float f3 = (this.saturationUpper - this.saturationLower) / (float)(this.primaryAxis == Axis.SATURATION ? n2 : this.secondaryCount);
        float f4 = this.hueLower;
        float f5 = this.brightnessUpper;
        float f6 = this.saturationLower;
        int n3 = 0;
        block15: for (int i = 0; i < n2; ++i) {
            switch (this.primaryAxis) {
                case HUE: {
                    f6 = this.saturationLower;
                    f5 = this.brightnessUpper;
                    break;
                }
                case SATURATION: {
                    f4 = this.hueLower;
                    f5 = this.brightnessUpper;
                    break;
                }
                case BRIGHTNESS: {
                    f4 = this.hueLower;
                    f6 = this.saturationLower;
                }
            }
            for (int j = 0; j < this.secondaryCount; ++j) {
                colorArray[n3] = Color.getHSBColor(f4, f6, f5);
                switch (this.primaryAxis) {
                    case HUE: {
                        f6 += f3;
                        f5 -= f2;
                        break;
                    }
                    case SATURATION: {
                        f4 += f;
                        f5 -= f2;
                        break;
                    }
                    case BRIGHTNESS: {
                        f4 += f;
                        f6 += f3;
                    }
                }
                ++n3;
            }
            switch (this.primaryAxis) {
                case HUE: {
                    f4 += f;
                    continue block15;
                }
                case SATURATION: {
                    f6 += f3;
                    continue block15;
                }
                case BRIGHTNESS: {
                    f5 -= f2;
                }
            }
        }
        this.setColourMap(this.getValues(), colorArray);
    }

    public void setSecondaryCount(int n) {
        this.secondaryCount = n;
        this.setupColours();
    }

    public void setHueUpper(float f) {
        this.hueUpper = f;
        this.setupColours();
    }

    public void setHueLower(float f) {
        this.hueLower = f;
        this.setupColours();
    }

    public void setSaturationUpper(float f) {
        this.saturationUpper = f;
        this.setupColours();
    }

    public void setSaturationLower(float f) {
        this.saturationLower = f;
        this.setupColours();
    }

    public void setBrightnessUpper(float f) {
        this.brightnessUpper = f;
        this.setupColours();
    }

    public void setBrightnessLower(float f) {
        this.brightnessLower = f;
        this.setupColours();
    }

    public void setPrimaryAxis(Axis axis) {
        this.primaryAxis = axis;
        this.setupColours();
    }

    public int getSecondaryCount() {
        return this.secondaryCount;
    }

    public float getHueUpper() {
        return this.hueUpper;
    }

    public float getHueLower() {
        return this.hueLower;
    }

    public float getSaturationUpper() {
        return this.saturationUpper;
    }

    public float getSaturationLower() {
        return this.saturationLower;
    }

    public float getBrightnessUpper() {
        return this.brightnessUpper;
    }

    public float getBrightnessLower() {
        return this.brightnessLower;
    }

    public Axis getPrimaryAxis() {
        return this.primaryAxis;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append((Object)this.primaryAxis);
        stringBuilder.append(",");
        stringBuilder.append(this.secondaryCount);
        stringBuilder.append(",");
        stringBuilder.append(this.hueLower);
        stringBuilder.append(",");
        stringBuilder.append(this.hueUpper);
        stringBuilder.append(",");
        stringBuilder.append(this.saturationLower);
        stringBuilder.append(",");
        stringBuilder.append(this.saturationUpper);
        stringBuilder.append(",");
        stringBuilder.append(this.brightnessLower);
        stringBuilder.append(",");
        stringBuilder.append(this.brightnessUpper);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static enum Axis {
        HUE,
        SATURATION,
        BRIGHTNESS;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

