/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import figtree.treeviewer.decorators.ContinuousColourDecorator;
import figtree.treeviewer.decorators.ContinuousScale;
import java.awt.Color;

public class HSBContinuousColourDecorator
extends ContinuousColourDecorator {
    private float hueUpper = 1.0f;
    private float hueLower = 0.0f;
    private float saturationUpper = 0.6f;
    private float saturationLower = 0.6f;
    private float brightnessUpper = 0.8f;
    private float brightnessLower = 0.4f;
    private boolean reverseHue = false;

    public HSBContinuousColourDecorator(String string, String string2) {
        super(string);
        this.setup(string2);
    }

    public HSBContinuousColourDecorator(ContinuousScale continuousScale) throws NumberFormatException {
        super(continuousScale);
    }

    @Override
    public void setup(String string) {
        if (!string.startsWith("{") || !string.endsWith("}")) {
            throw new IllegalArgumentException("HSBContinuousColourDecorator settings string not in correct format");
        }
        String[] stringArray = string.substring(1, string.length() - 1).split("}[, ]+");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("HSBContinuousColourDecorator settings string not in correct format");
        }
        String[] stringArray2 = stringArray[1].split("[, ]+");
        if (stringArray2.length != 7) {
            throw new IllegalArgumentException("HSBContinuousColourDecorator settings string not in correct format");
        }
        try {
            this.setContinuousScale(new ContinuousScale(stringArray[0]));
            this.hueLower = Float.parseFloat(stringArray2[0]);
            this.hueUpper = Float.parseFloat(stringArray2[1]);
            this.saturationLower = Float.parseFloat(stringArray2[2]);
            this.saturationUpper = Float.parseFloat(stringArray2[3]);
            this.brightnessLower = Float.parseFloat(stringArray2[4]);
            this.brightnessUpper = Float.parseFloat(stringArray2[5]);
            this.reverseHue = Boolean.parseBoolean(stringArray2[6]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("HSBContinuousColourDecorator settings string not in correct format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("HSBContinuousColourDecorator settings string not in correct format");
        }
    }

    public void setup(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        this.hueUpper = f;
        this.hueLower = f2;
        this.saturationUpper = f3;
        this.saturationLower = f4;
        this.brightnessUpper = f5;
        this.brightnessLower = f6;
        this.reverseHue = bl;
    }

    @Override
    protected Color getColourForScaledValue(double d) {
        if (!Double.isNaN(d)) {
            return Color.getHSBColor(this.getHue((float)d), this.getSaturation((float)d), this.getBrightness((float)d));
        }
        return null;
    }

    private float getHue(float f) {
        if (this.reverseHue) {
            return this.hueUpper - (this.hueUpper - this.hueLower) * f;
        }
        return (this.hueUpper - this.hueLower) * f + this.hueLower;
    }

    private float getSaturation(float f) {
        return (this.saturationUpper - this.saturationLower) * f + this.saturationLower;
    }

    private float getBrightness(float f) {
        return (this.brightnessUpper - this.brightnessLower) * f + this.brightnessLower;
    }

    public float getHueUpper() {
        return this.hueUpper;
    }

    public void setHueUpper(float f) {
        this.hueUpper = f;
    }

    public float getHueLower() {
        return this.hueLower;
    }

    public void setHueLower(float f) {
        this.hueLower = f;
    }

    public float getSaturationUpper() {
        return this.saturationUpper;
    }

    public void setSaturationUpper(float f) {
        this.saturationUpper = f;
    }

    public float getSaturationLower() {
        return this.saturationLower;
    }

    public void setSaturationLower(float f) {
        this.saturationLower = f;
    }

    public float getBrightnessUpper() {
        return this.brightnessUpper;
    }

    public void setBrightnessUpper(float f) {
        this.brightnessUpper = f;
    }

    public float getBrightnessLower() {
        return this.brightnessLower;
    }

    public void setBrightnessLower(float f) {
        this.brightnessLower = f;
    }

    public boolean isReverseHue() {
        return this.reverseHue;
    }

    public void setReverseHue(boolean bl) {
        this.reverseHue = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(this.getContinuousScale().toString());
        stringBuilder.append(",");
        stringBuilder.append(this.hueLower);
        stringBuilder.append(",");
        stringBuilder.append(this.hueUpper);
        stringBuilder.append(",");
        stringBuilder.append(this.saturationLower);
        stringBuilder.append(",");
        stringBuilder.append(this.saturationUpper);
        stringBuilder.append(",");
        stringBuilder.append(this.brightnessLower);
        stringBuilder.append(",");
        stringBuilder.append(this.brightnessUpper);
        stringBuilder.append(",");
        stringBuilder.append(this.reverseHue);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

