/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import figtree.treeviewer.decorators.ColourDecorator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jebl.util.Attributable;

public class DiscreteColourDecorator
extends ColourDecorator {
    public static Color[] DEFAULT_PAINTS = new Color[]{new Color(64, 35, 225), new Color(229, 35, 60), new Color(255, 174, 34), new Color(86, 255, 34), new Color(35, 141, 148), new Color(146, 35, 142), new Color(255, 90, 34), new Color(239, 255, 34), Color.DARK_GRAY, new Color(160, 146, 241), new Color(243, 146, 158), new Color(255, 215, 145), new Color(171, 255, 145), new Color(146, 199, 202), new Color(201, 146, 199), new Color(255, 173, 145), new Color(248, 255, 145), Color.LIGHT_GRAY, new Color(32, 18, 113), new Color(115, 18, 30), new Color(128, 87, 17), new Color(43, 128, 17), new Color(18, 71, 74), new Color(73, 18, 71), new Color(128, 45, 17), new Color(120, 128, 17)};
    private List<Object> values;
    private Map<Object, Integer> orderMap;
    private Color[] colours;
    private boolean hasReorderedValues = false;

    public DiscreteColourDecorator() {
        super(null);
        this.colours = DEFAULT_PAINTS;
    }

    public DiscreteColourDecorator(String string) {
        super(string);
    }

    public DiscreteColourDecorator(String string, Set<? extends Attributable> set) {
        super(string, set);
    }

    @Override
    public void setup(String string) {
        throw new UnsupportedOperationException("setup from string not implemented");
    }

    @Override
    public void setAttributes(String string, Set<? extends Attributable> set) {
        super.setAttributes(string, set);
        TreeSet<Object> treeSet = new TreeSet<Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Attributable attributable : set) {
            Object object = attributable.getAttribute(string);
            if (object == null) continue;
            if (object instanceof Comparable) {
                treeSet.add(object);
                continue;
            }
            hashSet.add(object);
        }
        if (this.values == null) {
            this.values = new ArrayList<Object>(treeSet);
            this.values.addAll(hashSet);
        } else {
            for (Attributable attributable : treeSet) {
                if (this.values.contains(attributable)) continue;
                this.values.add(attributable);
            }
            for (Attributable attributable : hashSet) {
                if (this.values.contains(attributable)) continue;
                this.values.add(attributable);
            }
        }
        this.setupColours();
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(Collection<Object> collection) {
        this.values = new ArrayList<Object>(collection);
        this.setupColours();
    }

    protected void setupColours() {
        this.setColourMap(this.values, DEFAULT_PAINTS);
    }

    public Color getColor(Object object) {
        return this.colours[this.orderMap.get(object)];
    }

    protected void setColourMap(Collection<Object> collection, Color[] colorArray) {
        if (collection == null) {
            return;
        }
        this.orderMap = new TreeMap<Object, Integer>();
        this.colours = colorArray;
        this.values = new ArrayList<Object>(collection);
        int n = 0;
        for (Object object : this.values) {
            this.orderMap.put(object, n);
            n = (n + 1) % colorArray.length;
        }
    }

    @Override
    protected Color getColourForValue(Object object) {
        int n = -1;
        if (object != null) {
            if (this.orderMap != null && this.orderMap.size() > 0) {
                n = this.orderMap.get(object);
            } else if (object instanceof Number) {
                n = ((Number)object).intValue() % this.colours.length;
            }
        }
        if (n == -1) {
            return null;
        }
        return this.colours[n];
    }

    public void setValuesOrder(List<Object> list) {
        this.values = list;
        this.hasReorderedValues = true;
    }

    public boolean hasReorderedValues() {
        return this.hasReorderedValues;
    }

    public String getOrderString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Object object : this.values) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }
}

