/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import figtree.treeviewer.decorators.Decorator;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import jebl.util.Attributable;

public abstract class ColourDecorator
implements Decorator {
    private String attributeName = null;
    protected Paint paint = null;
    protected Paint fillPaint = null;
    protected Color colour1 = null;
    protected Color colour2 = null;
    protected Color fillColour1 = null;
    protected Color fillColour2 = null;

    public ColourDecorator(String string) {
        this.attributeName = string;
    }

    public ColourDecorator(String string, Set<? extends Attributable> set) {
        this.setAttributes(string, set);
    }

    public abstract void setup(String var1);

    @Override
    public boolean allowsGradient() {
        return true;
    }

    public void setAttributes(String string, Set<? extends Attributable> set) {
        this.attributeName = string;
    }

    @Override
    public Paint getPaint(Paint paint) {
        if (this.paint == null) {
            return paint;
        }
        return this.paint;
    }

    @Override
    public Paint getFillPaint(Paint paint) {
        if (this.fillPaint == null) {
            return paint;
        }
        return this.fillPaint;
    }

    @Override
    public Paint getPaint(Paint paint, Point2D point2D, Point2D point2D2) {
        if (this.colour1 != null && this.colour2 != null) {
            return new GradientPaint(point2D, this.colour1, point2D2, this.colour2, false);
        }
        return this.getPaint(paint);
    }

    @Override
    public Paint getFillPaint(Paint paint, Point2D point2D, Point2D point2D2) {
        if (this.fillColour1 != null && this.fillColour2 != null) {
            return new GradientPaint(point2D, this.fillColour1, point2D2, this.fillColour2, false);
        }
        return this.getFillPaint(paint);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public Stroke getStroke(Stroke stroke) {
        return stroke;
    }

    @Override
    public Font getFont(Font font) {
        return font;
    }

    @Override
    public void setItem(Attributable attributable, Attributable attributable2) {
        this.setAttributableItem(attributable, attributable2);
    }

    @Override
    public void setItem(Object object) {
        if (object instanceof Attributable) {
            this.setAttributableItem((Attributable)object, null);
        } else {
            this.paint = this.getColourForValue(object);
        }
    }

    @Override
    public void setItems(Object object, Object object2) {
        this.colour1 = null;
        this.colour2 = null;
        if (object2 == null) {
            this.setItem(object);
            return;
        }
        if (object == null) {
            this.setItem(object2);
            return;
        }
        Object object3 = object;
        if (object instanceof Attributable) {
            object3 = ((Attributable)object).getAttribute(this.getAttributeName());
        }
        if (object3 != null) {
            this.colour1 = this.getColourForValue(object3);
            this.paint = this.colour1;
        }
        Object object4 = object2;
        if (object2 instanceof Attributable) {
            object4 = ((Attributable)object2).getAttribute(this.getAttributeName());
        }
        if (object4 != null) {
            this.colour2 = this.getColourForValue(object4);
            this.paint = this.colour2;
        }
        this.fillColour1 = null;
        if (this.colour1 != null) {
            this.fillColour1 = this.getLighterColour(this.colour1);
        }
        this.fillColour2 = null;
        if (this.colour2 != null) {
            this.fillColour2 = this.getLighterColour(this.colour2);
        }
    }

    public static boolean isDiscrete(String string, Set<? extends Attributable> set) {
        boolean bl;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Attributable attributable : set) {
            Object object = attributable.getAttribute(string);
            if (object == null) continue;
            hashSet.add(object);
        }
        boolean bl2 = true;
        boolean bl22 = true;
        for (Object e : hashSet) {
            if (e instanceof Number) {
                if (((Number)e).doubleValue() == (double)((Number)e).intValue()) continue;
                bl = false;
                continue;
            }
            bl2 = false;
        }
        return !bl2 || bl;
    }

    public static boolean isNumerical(String string, Set<? extends Attributable> set) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Attributable object : set) {
            Object object2 = object.getAttribute(string);
            if (object2 == null) continue;
            hashSet.add(object2);
        }
        boolean bl = true;
        for (Object object2 : hashSet) {
            if (object2 instanceof Number) continue;
            bl = false;
        }
        return bl;
    }

    private void setAttributableItem(Attributable attributable, Attributable attributable2) {
        Object object = attributable.getAttribute(this.attributeName);
        if (object == null && attributable2 != null) {
            object = attributable2.getAttribute(this.attributeName);
        }
        this.paint = null;
        Color color = this.getColourForValue(object);
        if (color != null) {
            this.paint = color;
            this.fillPaint = this.getLighterColour(color);
        } else {
            this.paint = null;
            this.fillPaint = null;
        }
    }

    protected abstract Color getColourForValue(Object var1);

    protected Color getLighterColour(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() / 2);
    }
}

