/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.annotations;

import figtree.treeviewer.annotations.AnnotationDefinition;
import figtree.ui.components.RealNumberField;
import figtree.ui.components.WholeNumberField;
import jam.panels.OptionsPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jebl.util.Attributable;

public class AnnotationDialog {
    public static final String CREATE_NEW = "Create new...";
    private JFrame frame;
    private OptionsPanel options;
    private JComboBox annotationCombo;
    private Attributable item;
    private List<AnnotationDefinition> definitions;
    private JComponent component = null;
    private JComponent component2 = null;
    AnnotationDefinition definition = null;

    public AnnotationDialog(JFrame jFrame) {
        this.frame = jFrame;
    }

    public int showDialog(List<AnnotationDefinition> list, Attributable attributable) {
        this.definitions = list;
        this.item = attributable;
        this.options = new OptionsPanel(6, 6);
        this.annotationCombo = new JComboBox<Object>(list.toArray());
        this.annotationCombo.setSelectedIndex(0);
        this.setupOptionsPanel();
        JOptionPane jOptionPane = new JOptionPane(this.options, 3, 2, null, null, null);
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        final JDialog jDialog = jOptionPane.createDialog(this.frame, "Annotate Selection");
        jDialog.pack();
        this.annotationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationDialog.this.setupOptionsPanel();
                jDialog.pack();
            }
        });
        jDialog.setVisible(true);
        int n = 2;
        Integer n2 = (Integer)jOptionPane.getValue();
        if (n2 != null && n2 != -1) {
            n = n2;
        }
        return n;
    }

    private void setupOptionsPanel() {
        this.definition = this.getDefinition();
        this.options.removeAll();
        this.options.addComponentWithLabel("Annotation:", this.annotationCombo);
        if (this.definition == null) {
            final JTextField jTextField = new JTextField();
            jTextField.setColumns(24);
            this.options.addComponentWithLabel("Name:", jTextField);
            final JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{AnnotationDefinition.Type.INTEGER, AnnotationDefinition.Type.REAL, AnnotationDefinition.Type.STRING, AnnotationDefinition.Type.BOOLEAN, AnnotationDefinition.Type.RANGE});
            this.options.addComponentWithLabel("Type:", jComboBox);
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AnnotationDialog.this.definition = new AnnotationDefinition(jTextField.getText(), (AnnotationDefinition.Type)((Object)jComboBox.getSelectedItem()));
                    AnnotationDialog.this.setupValues();
                }
            });
            jComboBox.setSelectedIndex(0);
        } else {
            this.setupValues();
        }
    }

    private void setupValues() {
        Object object = null;
        if (this.item != null) {
            object = this.item.getAttribute(this.definition.getCode());
        }
        this.component2 = null;
        switch (this.definition.getType()) {
            case BOOLEAN: {
                this.component = new JComboBox<String>(new String[]{"True", "False"});
                if (object != null) {
                    ((JComboBox)this.component).setSelectedIndex(object.equals(Boolean.TRUE) ? 0 : 1);
                }
                this.options.addComponentWithLabel("Value:", this.component);
                break;
            }
            case INTEGER: {
                this.component = new WholeNumberField();
                this.options.addComponentWithLabel("Value:", this.component);
                ((WholeNumberField)this.component).setColumns(12);
                if (object == null) break;
                ((WholeNumberField)this.component).setValue((Integer)object);
                break;
            }
            case REAL: {
                this.component = new RealNumberField();
                this.options.addComponentWithLabel("Value:", this.component);
                ((RealNumberField)this.component).setColumns(12);
                if (object == null) break;
                ((RealNumberField)this.component).setValue((Double)object);
                break;
            }
            case STRING: {
                this.component = new JTextField();
                this.options.addComponentWithLabel("Value:", this.component);
                ((JTextField)this.component).setColumns(20);
                if (object == null) break;
                ((JTextField)this.component).setText((String)object);
                break;
            }
            case RANGE: {
                this.component = new RealNumberField();
                ((RealNumberField)this.component).setColumns(12);
                this.options.addComponentWithLabel("Lower:", this.component);
                this.component2 = new RealNumberField();
                ((RealNumberField)this.component2).setColumns(12);
                this.options.addComponentWithLabel("Upper:", this.component2);
                if (object == null) break;
                ((RealNumberField)this.component).setValue((Double)((Object[])object)[0]);
                ((RealNumberField)this.component2).setValue((Double)((Object[])object)[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised enum value");
            }
        }
    }

    public AnnotationDefinition getDefinition() {
        if (this.annotationCombo.getSelectedItem().equals(CREATE_NEW)) {
            return null;
        }
        return (AnnotationDefinition)this.annotationCombo.getSelectedItem();
    }

    public Object getValue() {
        AnnotationDefinition annotationDefinition = this.getDefinition();
        switch (annotationDefinition.getType()) {
            case BOOLEAN: {
                return new Boolean(((JComboBox)this.component).getSelectedItem().toString());
            }
            case INTEGER: {
                return ((WholeNumberField)this.component).getValue();
            }
            case REAL: {
                return ((RealNumberField)this.component).getValue();
            }
            case STRING: {
                String string = ((JTextField)this.component).getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return string;
            }
            case RANGE: {
                double d = ((RealNumberField)this.component).getValue();
                double d2 = ((RealNumberField)this.component2).getValue();
                return new Double[]{d, d2};
            }
        }
        throw new IllegalArgumentException("Unrecognised enum value");
    }
}

