/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.annotations;

import figtree.treeviewer.annotations.AnnotationDefinition;
import figtree.treeviewer.annotations.DefineAnnotationDialog;
import jam.panels.ActionPanel;
import jam.panels.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class AnnotationDefinitionsDialog {
    private JFrame frame;
    int labelCount = 1;
    private List<AnnotationDefinition> annotations = new ArrayList<AnnotationDefinition>();
    private AnnotationTableModel annotationTableModel;
    private AbstractAction addAnnotationAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationDefinitionsDialog.this.addAnnotation();
        }
    };
    private AbstractAction removeAnnotationAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationDefinitionsDialog.this.removeAnnotation();
        }
    };
    private AbstractAction editAnnotationAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationDefinitionsDialog.this.editAnnotation();
        }
    };
    private JTable table;
    private DefineAnnotationDialog defineAnnotationDialog = null;

    public AnnotationDefinitionsDialog(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void showDialog(Collection<AnnotationDefinition> collection) {
        this.annotations.clear();
        this.annotations.addAll(collection);
        OptionsPanel optionsPanel = new OptionsPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.annotationTableModel = new AnnotationTableModel();
        this.table = new JTable(this.annotationTableModel);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AnnotationDefinitionsDialog.this.selectionChanged();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table, 22, 31);
        jPanel.add((Component)jScrollPane, "Center");
        ActionPanel actionPanel = new ActionPanel(true);
        actionPanel.setAddAction(this.addAnnotationAction);
        actionPanel.setRemoveAction(this.removeAnnotationAction);
        actionPanel.setActionAction(this.editAnnotationAction);
        jPanel.add((Component)actionPanel, "South");
        optionsPanel.addSpanningComponent(jPanel);
        JOptionPane jOptionPane = new JOptionPane(optionsPanel, -1, -1, null, new String[]{"Done"}, null);
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        JDialog jDialog = jOptionPane.createDialog(this.frame, "Annotation Definitions");
        jDialog.pack();
        this.selectionChanged();
        jDialog.setVisible(true);
    }

    private void selectionChanged() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            this.removeAnnotationAction.setEnabled(false);
        } else {
            this.removeAnnotationAction.setEnabled(true);
        }
    }

    public List<AnnotationDefinition> getAnnotations() {
        return this.annotations;
    }

    private void addAnnotation() {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition("Label" + this.labelCount, AnnotationDefinition.Type.INTEGER);
        this.doDefineAnnotation(annotationDefinition);
    }

    private void removeAnnotation() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.annotations.remove(n);
        this.annotationTableModel.fireTableDataChanged();
    }

    private void editAnnotation() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        AnnotationDefinition annotationDefinition = this.annotations.get(n);
        this.doDefineAnnotation(annotationDefinition);
    }

    private void doDefineAnnotation(AnnotationDefinition annotationDefinition) {
        int n;
        if (this.defineAnnotationDialog == null) {
            this.defineAnnotationDialog = new DefineAnnotationDialog(this.frame);
        }
        if ((n = this.defineAnnotationDialog.showDialog(annotationDefinition)) == 0) {
            this.annotations.add(annotationDefinition);
            ++this.labelCount;
        }
        this.annotationTableModel.fireTableDataChanged();
    }

    class AnnotationTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Label", "Type"};

        AnnotationTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return AnnotationDefinitionsDialog.this.annotations.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((AnnotationDefinition)AnnotationDefinitionsDialog.this.annotations.get(n)).getName();
            }
            return ((AnnotationDefinition)AnnotationDefinitionsDialog.this.annotations.get(n)).getType();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

