/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jebl.evolution.trees.SortedRootedTree;
import jebl.evolution.trees.TransformedRootedTree;

public class TreesController
extends AbstractController {
    private static final String CONTROLLER_TITLE = "Trees";
    private static Preferences PREFS = Preferences.userNodeForPackage(TreeViewer.class);
    private static final String CONTROLLER_KEY = "trees";
    private static final String TRANSFORM_KEY = "transform";
    private static final String TRANSFORM_TYPE_KEY = "transformType";
    private static final String ORDER_KEY = "order";
    private static final String ORDER_TYPE_KEY = "orderType";
    private static final String ROOTING_KEY = "rooting";
    private static final String ROOTING_TYPE_KEY = "rootingType";
    private final JLabel titleLabel;
    private final OptionsPanel optionsPanel;
    private final JCheckBox transformCheck;
    private final JComboBox transformCombo;
    private final JCheckBox orderCheck;
    private final JComboBox orderCombo;
    private final JCheckBox rootingCheck;
    private final JComboBox rootingCombo;
    private final TreeViewer treeViewer;

    public TreesController(final TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.titleLabel = new JLabel(CONTROLLER_TITLE);
        this.optionsPanel = new ControllerOptionsPanel(2, 6);
        this.rootingCheck = new JCheckBox("Root tree");
        this.rootingCheck.setOpaque(false);
        this.optionsPanel.addSpanningComponent(this.rootingCheck);
        this.rootingCheck.setSelected(treeViewer.isRootingOn());
        this.rootingCombo = new JComboBox<TreePane.RootingType>(TreePane.RootingType.values());
        this.rootingCombo.setOpaque(false);
        this.rootingCombo.setSelectedItem((Object)treeViewer.getRootingType());
        this.rootingCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                treeViewer.setRootingType((TreePane.RootingType)((Object)TreesController.this.rootingCombo.getSelectedItem()));
            }
        });
        final JLabel jLabel = this.optionsPanel.addComponentWithLabel("Rooting:", this.rootingCombo);
        jLabel.setEnabled(this.rootingCheck.isSelected());
        this.rootingCombo.setEnabled(this.rootingCheck.isSelected());
        this.rootingCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jLabel.setEnabled(TreesController.this.rootingCheck.isSelected());
                TreesController.this.rootingCombo.setEnabled(TreesController.this.rootingCheck.isSelected());
                treeViewer.setRootingOn(TreesController.this.rootingCheck.isSelected());
            }
        });
        this.optionsPanel.addSeparator();
        this.orderCheck = new JCheckBox("Order nodes");
        this.orderCheck.setOpaque(false);
        this.optionsPanel.addSpanningComponent(this.orderCheck);
        this.orderCheck.setSelected(treeViewer.isOrderBranchesOn());
        this.orderCombo = new JComboBox<SortedRootedTree.BranchOrdering>(SortedRootedTree.BranchOrdering.values());
        this.orderCombo.setOpaque(false);
        this.orderCombo.setSelectedItem((Object)treeViewer.getBranchOrdering());
        this.orderCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                treeViewer.setBranchOrdering((SortedRootedTree.BranchOrdering)((Object)TreesController.this.orderCombo.getSelectedItem()));
            }
        });
        final JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Ordering:", this.orderCombo);
        jLabel2.setEnabled(this.orderCheck.isSelected());
        this.orderCombo.setEnabled(this.orderCheck.isSelected());
        this.orderCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jLabel2.setEnabled(TreesController.this.orderCheck.isSelected());
                TreesController.this.orderCombo.setEnabled(TreesController.this.orderCheck.isSelected());
                treeViewer.setOrderBranchesOn(TreesController.this.orderCheck.isSelected());
            }
        });
        this.optionsPanel.addSeparator();
        this.transformCheck = new JCheckBox("Transform branches");
        this.transformCheck.setOpaque(false);
        this.optionsPanel.addSpanningComponent(this.transformCheck);
        this.transformCheck.setSelected(treeViewer.isTransformBranchesOn());
        this.transformCombo = new JComboBox<TransformedRootedTree.Transform>(TransformedRootedTree.Transform.values());
        this.transformCombo.setOpaque(false);
        this.transformCombo.setSelectedItem((Object)treeViewer.getBranchTransform());
        this.transformCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                treeViewer.setBranchTransform((TransformedRootedTree.Transform)((Object)TreesController.this.transformCombo.getSelectedItem()));
            }
        });
        final JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Transform:", this.transformCombo);
        jLabel3.setEnabled(this.transformCheck.isSelected());
        this.transformCombo.setEnabled(this.transformCheck.isSelected());
        this.transformCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = TreesController.this.transformCheck.isSelected();
                jLabel3.setEnabled(bl);
                TreesController.this.transformCombo.setEnabled(bl);
                treeViewer.setTransformBranchesOn(bl);
            }
        });
        treeViewer.addTreeViewerListener(new TreeViewerListener(){

            @Override
            public void treeChanged() {
            }

            @Override
            public void treeSettingsChanged() {
                TreesController.this.rootingCheck.setSelected(treeViewer.isRootingOn());
                TreesController.this.rootingCombo.setSelectedItem((Object)treeViewer.getRootingType());
                TreesController.this.transformCheck.setSelected(treeViewer.isTransformBranchesOn());
                TreesController.this.transformCombo.setSelectedItem((Object)treeViewer.getBranchTransform());
                TreesController.this.orderCheck.setSelected(treeViewer.isOrderBranchesOn());
                TreesController.this.orderCombo.setSelectedItem((Object)treeViewer.getBranchOrdering());
            }
        });
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
        this.treeViewer.setRootingOn(this.rootingCheck.isSelected());
        this.treeViewer.setRootingType((TreePane.RootingType)((Object)this.rootingCombo.getSelectedItem()));
        this.treeViewer.setTransformBranchesOn(this.transformCheck.isSelected());
        this.treeViewer.setBranchTransform((TransformedRootedTree.Transform)((Object)this.transformCombo.getSelectedItem()));
        this.treeViewer.setOrderBranchesOn(this.orderCheck.isSelected());
        this.treeViewer.setBranchOrdering((SortedRootedTree.BranchOrdering)((Object)this.orderCombo.getSelectedItem()));
    }

    public void toggleMidpointRoot() {
        if (!this.rootingCheck.isSelected() || this.rootingCombo.getSelectedItem() != TreePane.RootingType.MID_POINT) {
            this.rootingCheck.setSelected(true);
            this.rootingCombo.setSelectedItem((Object)TreePane.RootingType.MID_POINT);
        } else {
            this.rootingCombo.setSelectedItem((Object)TreePane.RootingType.USER_ROOTING);
        }
        this.treeViewer.setRootingType((TreePane.RootingType)((Object)this.rootingCombo.getSelectedItem()));
        this.treeViewer.setRootingOn(this.rootingCheck.isSelected());
    }

    public void toggleIncreasingNodeOrder() {
        if (!this.orderCheck.isSelected() || this.orderCombo.getSelectedItem() != SortedRootedTree.BranchOrdering.INCREASING_NODE_DENSITY) {
            this.orderCheck.setSelected(true);
            this.orderCombo.setSelectedItem((Object)SortedRootedTree.BranchOrdering.INCREASING_NODE_DENSITY);
        } else {
            this.orderCheck.setSelected(false);
        }
        this.treeViewer.setBranchOrdering((SortedRootedTree.BranchOrdering)((Object)this.orderCombo.getSelectedItem()));
        this.treeViewer.setOrderBranchesOn(this.orderCheck.isSelected());
    }

    public void toggleDecreasingNodeOrder() {
        if (!this.orderCheck.isSelected() || this.orderCombo.getSelectedItem() != SortedRootedTree.BranchOrdering.DECREASING_NODE_DENSITY) {
            this.orderCheck.setSelected(true);
            this.orderCombo.setSelectedItem((Object)SortedRootedTree.BranchOrdering.DECREASING_NODE_DENSITY);
        } else {
            this.orderCheck.setSelected(false);
        }
        this.treeViewer.setBranchOrdering((SortedRootedTree.BranchOrdering)((Object)this.orderCombo.getSelectedItem()));
        this.treeViewer.setOrderBranchesOn(this.orderCheck.isSelected());
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.transformCheck.setSelected((Boolean)map.get("trees.transform"));
        String string = (String)map.get("trees.transformType");
        for (TransformedRootedTree.Transform transform : TransformedRootedTree.Transform.values()) {
            if (!transform.toString().equalsIgnoreCase(string)) continue;
            this.transformCombo.setSelectedItem((Object)transform);
        }
        this.orderCheck.setSelected((Boolean)map.get("trees.order"));
        String string2 = (String)map.get("trees.orderType");
        for (SortedRootedTree.BranchOrdering branchOrdering : SortedRootedTree.BranchOrdering.values()) {
            if (!branchOrdering.toString().equalsIgnoreCase(string2)) continue;
            this.orderCombo.setSelectedItem((Object)branchOrdering);
        }
        this.rootingCheck.setSelected((Boolean)map.get("trees.rooting"));
        String string3 = (String)map.get("trees.rootingType");
        for (TreePane.RootingType rootingType : TreePane.RootingType.values()) {
            if (!rootingType.toString().equalsIgnoreCase(string3)) continue;
            this.rootingCombo.setSelectedItem((Object)rootingType);
        }
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("trees.transform", this.transformCheck.isSelected());
        map.put("trees.transformType", this.transformCombo.getSelectedItem().toString());
        map.put("trees.order", this.orderCheck.isSelected());
        map.put("trees.orderType", this.orderCombo.getSelectedItem().toString());
        map.put("trees.rooting", this.rootingCheck.isSelected());
        map.put("trees.rootingType", this.rootingCombo.getSelectedItem().toString());
    }
}

