/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.TreePane;
import jam.panels.StatusProvider;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.RootedTreeUtils;
import jebl.util.NumberFormatter;

public class TreePaneRollOver
extends StatusProvider.Helper
implements MouseMotionListener {
    private TreePane treePane;
    private NumberFormatter formatter = new NumberFormatter(4);

    public TreePaneRollOver(TreePane treePane) {
        this.treePane = treePane;
        treePane.addMouseMotionListener(this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        RootedTree rootedTree = this.treePane.getTree();
        if (rootedTree != null) {
            Node node = this.treePane.getNodeAt((Graphics2D)this.treePane.getGraphics(), mouseEvent.getPoint());
            if (node != null) {
                this.fireStatusChanged(0, this.getNodeText(rootedTree, node));
            } else {
                this.fireStatusChanged(0, this.getNodeText(rootedTree, rootedTree.getRootNode()));
            }
        } else {
            this.fireStatusChanged(0, " ");
        }
    }

    private String getNodeText(RootedTree rootedTree, Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!rootedTree.isExternal(node)) {
            int n = RootedTreeUtils.getTipCount(rootedTree, node);
            stringBuilder.append(rootedTree.isRoot(node) ? "Tree: " : "Subtree: ").append(n).append(" tips");
        } else {
            stringBuilder.append("Tip: \"").append(rootedTree.getTaxon(node).toString()).append("\"");
        }
        stringBuilder.append(" [height = ").append(this.formatter.getFormattedValue(rootedTree.getHeight(node)));
        stringBuilder.append(", length = ").append(this.formatter.getFormattedValue(rootedTree.getLength(node)));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

