/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.annotations.AnnotationDefinition;
import figtree.ui.components.RealNumberField;
import figtree.ui.components.WholeNumberField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class FindPanel
extends JPanel {
    private JComboBox targetCombo = null;
    private JComboBox textSearchCombo = new JComboBox<TreeViewer.TextSearchType>(TreeViewer.TextSearchType.values());
    private JComboBox numberSearchCombo = new JComboBox<TreeViewer.NumberSearchType>(TreeViewer.NumberSearchType.values());
    private AnnotationDefinition.Type type = AnnotationDefinition.Type.STRING;
    private JTextField searchText = new JTextField();
    private RealNumberField doubleText = new RealNumberField();
    private WholeNumberField integerText = new WholeNumberField();
    private JCheckBox caseSensitiveCheck = new JCheckBox("Case sensitive");
    private int selectedTargetIndex = 0;
    final JButton findAllButton;

    public FindPanel(Action action, Action action2) {
        JComponent jComponent;
        this.setLayout(new BorderLayout(0, 0));
        Font font = UIManager.getFont("SmallSystemFont");
        if (font != null) {
            this.searchText.setFont(font);
        }
        this.searchText.setColumns(18);
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setOpaque(false);
        this.targetCombo = new JComboBox();
        this.targetCombo.addItem(Target.TAXON_LABEL);
        this.targetCombo.addItem(Target.BRANCH_LENGTH);
        this.targetCombo.addItem(Target.NODE_AGE);
        this.targetCombo.addItem(Target.ANY_ANNOTATION);
        this.adjustComponent(this.targetCombo);
        this.adjustComponent(this.textSearchCombo);
        this.adjustComponent(this.numberSearchCombo);
        this.adjustComponent(this.caseSensitiveCheck);
        jPanel.add(this.targetCombo);
        jPanel.add(this.textSearchCombo);
        jPanel.add(this.searchText);
        jPanel.add(this.caseSensitiveCheck);
        this.add((Component)jPanel, "Center");
        if (action2 != null) {
            jComponent = new JButton(action2);
            this.adjustComponent(jComponent);
            jPanel.add(jComponent);
        }
        this.findAllButton = new JButton(action);
        this.adjustComponent(this.findAllButton);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "doFind");
        this.getActionMap().put("doFind", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindPanel.this.findAllButton.doClick();
            }
        });
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 2));
        jComponent.setOpaque(false);
        jComponent.add(this.findAllButton);
        this.add((Component)jComponent, "East");
        this.targetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = FindPanel.this.targetCombo.getSelectedItem();
                if (object != null) {
                    if (object.equals((Object)Target.BRANCH_LENGTH) || object.equals((Object)Target.NODE_AGE)) {
                        FindPanel.this.type = AnnotationDefinition.Type.REAL;
                    } else if (object instanceof AnnotationDefinition) {
                        FindPanel.this.type = ((AnnotationDefinition)object).getType();
                    } else {
                        FindPanel.this.type = AnnotationDefinition.Type.STRING;
                    }
                    jPanel.removeAll();
                    jPanel.add(FindPanel.this.targetCombo);
                    switch (FindPanel.this.type) {
                        case INTEGER: {
                            jPanel.add(FindPanel.this.numberSearchCombo);
                            jPanel.add(FindPanel.this.integerText);
                            FindPanel.this.integerText.setColumns(10);
                            jPanel.add(FindPanel.this.caseSensitiveCheck);
                            FindPanel.this.caseSensitiveCheck.setEnabled(false);
                            break;
                        }
                        case REAL: {
                            jPanel.add(FindPanel.this.numberSearchCombo);
                            jPanel.add(FindPanel.this.doubleText);
                            FindPanel.this.doubleText.setColumns(10);
                            jPanel.add(FindPanel.this.caseSensitiveCheck);
                            FindPanel.this.caseSensitiveCheck.setEnabled(false);
                            break;
                        }
                        default: {
                            jPanel.add(FindPanel.this.textSearchCombo);
                            jPanel.add(FindPanel.this.searchText);
                            jPanel.add(FindPanel.this.caseSensitiveCheck);
                            FindPanel.this.caseSensitiveCheck.setEnabled(true);
                        }
                    }
                }
                FindPanel.this.revalidate();
                FindPanel.this.repaint();
            }
        });
        this.targetCombo.setSelectedIndex(this.selectedTargetIndex);
    }

    public void setup(List<AnnotationDefinition> list) {
        Object object = this.targetCombo.getSelectedItem();
        this.targetCombo.removeAllItems();
        this.targetCombo.addItem(Target.TAXON_LABEL);
        this.targetCombo.addItem(Target.BRANCH_LENGTH);
        this.targetCombo.addItem(Target.NODE_AGE);
        for (AnnotationDefinition annotationDefinition : list) {
            this.targetCombo.addItem(annotationDefinition);
        }
        this.targetCombo.addItem(Target.ANY_ANNOTATION);
        this.targetCombo.setSelectedItem(object);
    }

    public void doFind() {
        this.findAllButton.doClick();
    }

    protected void adjustComponent(JComponent jComponent) {
        Font font = UIManager.getFont("SmallSystemFont");
        if (font != null) {
            jComponent.setFont(font);
        }
        jComponent.putClientProperty("JComponent.sizeVariant", "small");
        if (jComponent instanceof JButton) {
            jComponent.putClientProperty("JButton.buttonType", "roundRect");
            jComponent.setFocusable(false);
        }
        if (jComponent instanceof JComboBox) {
            jComponent.putClientProperty("JComboBox.isSquare", Boolean.TRUE);
            jComponent.setFocusable(false);
        }
        if (jComponent instanceof JCheckBox) {
            jComponent.setFocusable(false);
        }
    }

    public Target getSearchTarget() {
        this.selectedTargetIndex = this.targetCombo.getSelectedIndex();
        Object object = this.targetCombo.getSelectedItem();
        if (object instanceof Target) {
            return (Target)((Object)object);
        }
        return Target.ANNOTATION;
    }

    public String getSearchTargetString() {
        return this.targetCombo.getSelectedItem().toString();
    }

    public boolean isNumericSearchType() {
        return this.type == AnnotationDefinition.Type.REAL || this.type == AnnotationDefinition.Type.INTEGER;
    }

    public TreeViewer.TextSearchType getTextSearchType() {
        return (TreeViewer.TextSearchType)((Object)this.textSearchCombo.getSelectedItem());
    }

    public TreeViewer.NumberSearchType getNumberSearchType() {
        return (TreeViewer.NumberSearchType)((Object)this.numberSearchCombo.getSelectedItem());
    }

    public String getSearchText() {
        return this.searchText.getText();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitiveCheck.isSelected();
    }

    public Number getSearchValue() {
        if (this.type == AnnotationDefinition.Type.REAL) {
            return this.doubleText.getValue();
        }
        if (this.type == AnnotationDefinition.Type.INTEGER) {
            return this.integerText.getValue();
        }
        return null;
    }

    public static enum Target {
        TAXON_LABEL("Taxon Label"),
        BRANCH_LENGTH("Branch Length"),
        NODE_AGE("Node Age"),
        ANY_ANNOTATION("Any Annotation"),
        ANNOTATION("Annotation");

        private String name;

        private Target(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

