/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.AnnotationsListener;
import figtree.treeviewer.DefaultTreeViewer;
import figtree.treeviewer.Parsimony;
import figtree.treeviewer.annotations.AnnotationDefinition;
import figtree.treeviewer.painters.CharactersPainter;
import jam.panels.StatusListener;
import jam.panels.StatusProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JFrame;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

public class ExtendedTreeViewer
extends DefaultTreeViewer
implements StatusProvider {
    private List<AnnotationsListener> listeners = new ArrayList<AnnotationsListener>();
    private static Map<String, AnnotationDefinition> annotations = null;
    private final StatusProvider.Helper statusHelper = new StatusProvider.Helper();

    public ExtendedTreeViewer() {
        this((JFrame)null);
    }

    public ExtendedTreeViewer(JFrame jFrame) {
        super(jFrame);
        this.setBackground(Color.white);
    }

    public void setPattern(Pattern pattern) {
        if (pattern == null) {
            this.setBranchDecorator(null, false);
        }
    }

    @Override
    public void addTree(Tree tree) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Node object : tree.getNodes()) {
            treeSet.addAll(object.getAttributeNames());
        }
        for (Taxon taxon : tree.getTaxa()) {
            treeSet.addAll(taxon.getAttributeNames());
        }
        for (String string : treeSet) {
            if (string.startsWith("!")) continue;
            AnnotationDefinition annotationDefinition = this.getAnnotationDefinitions().get(string);
            HashSet<Attributable> hashSet = new HashSet<Attributable>(tree.getNodes());
            hashSet.addAll(tree.getTaxa());
            AnnotationDefinition.Type type = AnnotationDefinition.guessType(string, hashSet);
            if (annotationDefinition == null) {
                annotationDefinition = new AnnotationDefinition(string, type);
                this.getAnnotationDefinitions().put(string, annotationDefinition);
                continue;
            }
            if (type == annotationDefinition.getType()) continue;
            AnnotationDefinition.Type type2 = AnnotationDefinition.Type.STRING;
            if (type == AnnotationDefinition.Type.INTEGER && annotationDefinition.getType() == AnnotationDefinition.Type.REAL) {
                type2 = AnnotationDefinition.Type.REAL;
            }
            if (type2 == type) continue;
            annotationDefinition = new AnnotationDefinition(string, type2);
            this.getAnnotationDefinitions().put(string, annotationDefinition);
        }
        super.addTree(tree);
        this.showStatus();
    }

    @Override
    public void showTree(int n) {
        super.showTree(n);
        this.showStatus();
    }

    public void setCharacters(Alignment alignment) {
        CharactersPainter charactersPainter = new CharactersPainter(alignment);
        this.setTipLabelPainter(charactersPainter);
    }

    public void setTaxonAnnotations(Map<AnnotationDefinition, Map<Taxon, Object>> map) {
        for (AnnotationDefinition annotationDefinition : map.keySet()) {
            this.getAnnotationDefinitions().put(annotationDefinition.getName(), annotationDefinition);
            Map<Taxon, Object> map2 = map.get(annotationDefinition);
            for (Taxon taxon : map2.keySet()) {
                taxon.setAttribute(annotationDefinition.getName(), map2.get(taxon));
            }
        }
        this.fireAnnotationsChanged();
    }

    public void showStatus() {
        this.fireStatusChanged(0, "Showing tree " + Integer.toString(this.getCurrentTreeIndex() + 1) + " / " + this.getTreeCount());
    }

    public void showInfomation() {
    }

    public void showStatistics() {
    }

    public void annotateSelected(String string, Object object) {
        this.annotateSelectedNodes(string, object);
        this.annotateSelectedTips(string, object);
        this.fireAnnotationsChanged();
    }

    public Map<String, AnnotationDefinition> getAnnotationDefinitions() {
        if (annotations == null) {
            annotations = new HashMap<String, AnnotationDefinition>();
        }
        return annotations;
    }

    public void setAnnotationDefinitions(List<AnnotationDefinition> list) {
        if (annotations == null) {
            annotations = new HashMap<String, AnnotationDefinition>();
        }
        annotations.clear();
        for (AnnotationDefinition annotationDefinition : list) {
            annotations.put(annotationDefinition.getName(), annotationDefinition);
        }
    }

    public void annotateNodesFromTips(String string) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<Taxon, Integer> hashMap = new HashMap<Taxon, Integer>();
        RootedTree rootedTree = this.treePane.getTree();
        for (Node object2 : rootedTree.getExternalNodes()) {
            Taxon taxon = rootedTree.getTaxon(object2);
            object = taxon.getAttribute(string);
            int n = arrayList.indexOf(object);
            if (n == -1) {
                n = arrayList.size();
                arrayList.add(object);
            }
            hashMap.put(taxon, n);
            object2.setAttribute(string, object);
        }
        Parsimony parsimony = new Parsimony(arrayList.size(), hashMap);
        for (Node node : rootedTree.getInternalNodes()) {
            object = parsimony.getState(rootedTree, node);
            Object var9_14 = null;
            if (object != null) {
                var9_14 = arrayList.get((Integer)object);
            }
            node.setAttribute(string, var9_14);
        }
        this.fireAnnotationsChanged();
    }

    public void annotateTipsFromNodes(String string) {
        RootedTree rootedTree = this.treePane.getTree();
        for (Node node : rootedTree.getExternalNodes()) {
            Object object = node.getAttribute(string);
            if (object == null) continue;
            Taxon taxon = rootedTree.getTaxon(node);
            taxon.setAttribute(string, object);
        }
        this.fireAnnotationsChanged();
    }

    public void addAnnotationsListener(AnnotationsListener annotationsListener) {
        this.listeners.add(annotationsListener);
    }

    public void fireAnnotationsChanged() {
        for (AnnotationsListener annotationsListener : this.listeners) {
            annotationsListener.annotationsChanged();
        }
        this.fireTreeChanged();
    }

    @Override
    public void addStatusListener(StatusListener statusListener) {
        this.statusHelper.addStatusListener(statusListener);
    }

    @Override
    public void removeStatusListener(StatusListener statusListener) {
        this.statusHelper.removeStatusListener(statusListener);
    }

    @Override
    public void fireStatusChanged(int n, String string) {
        this.statusHelper.fireStatusChanged(n, string);
    }

    @Override
    public void addOverrideProvider(StatusProvider statusProvider) {
        this.statusHelper.addOverrideProvider(statusProvider);
    }

    @Override
    public void removeOverrideProvider(StatusProvider statusProvider) {
        this.statusHelper.removeOverrideProvider(statusProvider);
    }

    @Override
    public void fireStatusButtonPressed() {
        this.statusHelper.fireStatusButtonPressed();
    }

    @Override
    public void statusButtonPressed() {
        this.statusHelper.statusButtonPressed();
    }

    @Override
    public int getStatus() {
        return this.statusHelper.getStatus();
    }

    @Override
    public String getStatusText() {
        return this.statusHelper.getStatusText();
    }

    public void setStatusText(String string) {
        this.statusHelper.fireStatusChanged(0, string);
    }
}

