/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import figtree.treeviewer.decorators.AttributableDecorator;
import figtree.treeviewer.decorators.ContinuousScale;
import figtree.treeviewer.decorators.DiscreteColourDecorator;
import figtree.treeviewer.decorators.HSBDiscreteColourDecorator;
import figtree.treeviewer.decorators.InterpolatingColourDecorator;
import figtree.treeviewer.painters.LabelPainter;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.SortedRootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

public class TreeAppearanceController
extends AbstractController {
    private static final String CONTROLLER_TITLE = "Appearance";
    private static final String CONTROLLER_KEY = "appearance";
    private static final String FOREGROUND_COLOUR_KEY = "foregroundColour";
    private static final String BACKGROUND_COLOUR_KEY = "backgroundColour";
    private static final String SELECTION_COLOUR_KEY = "selectionColour";
    private static final String BRANCH_COLOR_ATTRIBUTE_KEY = "branchColorAttribute";
    private static final String BRANCH_LINE_WIDTH_KEY = "branchLineWidth";
    private static Color DEFAULT_FOREGROUND_COLOUR = Color.BLACK;
    private static Color DEFAULT_BACKGROUND_COLOUR = Color.WHITE;
    private static Color DEFAULT_SELECTION_COLOUR = new Color(90, 108, 128);
    private static float DEFAULT_BRANCH_LINE_WIDTH = 1.0f;
    private static final String FONT_NAME_KEY = "fontName";
    private static final String FONT_SIZE_KEY = "fontSize";
    private static final String FONT_STYLE_KEY = "fontStyle";
    private static final String NUMBER_FORMATTING_KEY = "numberFormatting";
    private static final String DISPLAY_ATTRIBUTE_KEY = "displayAttribute";
    private static final String SIGNIFICANT_DIGITS_KEY = "significantDigits";
    private static String DEFAULT_FONT_NAME = "sansserif";
    private static int DEFAULT_FONT_SIZE = 6;
    private static int DEFAULT_FONT_STYLE = 0;
    private static String DEFAULT_NUMBER_FORMATTING = "#.####";
    private static String DECIMAL_NUMBER_FORMATTING = "#.####";
    private static String SCIENTIFIC_NUMBER_FORMATTING = "0.###E0";
    private final OptionsPanel optionsPanel;
    private final JComboBox branchColourAttributeCombo;
    private final JSpinner branchLineWidthSpinner;
    private final JSpinner fontSizeSpinner;
    private final JSpinner digitsSpinner;
    private final JComboBox orderCombo;
    private final TreeViewer treeViewer;
    private final String tipKey;
    private final String nodeKey;
    private final String branchKey;
    private final boolean hideColouring;

    public TreeAppearanceController(TreeViewer treeViewer, String string, LabelPainter labelPainter, String string2, LabelPainter labelPainter2, String string3, LabelPainter labelPainter3) {
        this(treeViewer, string, labelPainter, string2, labelPainter2, string3, labelPainter3, true, false);
    }

    public TreeAppearanceController(final TreeViewer treeViewer, String string, final LabelPainter labelPainter, String string2, final LabelPainter labelPainter2, String string3, final LabelPainter labelPainter3, boolean bl, boolean bl2) {
        this.treeViewer = treeViewer;
        this.hideColouring = bl;
        final AttributableDecorator attributableDecorator = new AttributableDecorator();
        attributableDecorator.setPaintAttributeName("!color");
        attributableDecorator.setStrokeAttributeName("!stroke");
        treeViewer.setBranchDecorator(attributableDecorator, false);
        int n = DEFAULT_FOREGROUND_COLOUR.getRGB();
        int n2 = DEFAULT_BACKGROUND_COLOUR.getRGB();
        int n3 = DEFAULT_SELECTION_COLOUR.getRGB();
        float f = DEFAULT_BRANCH_LINE_WIDTH;
        treeViewer.setForeground(new Color(n));
        treeViewer.setBackground(new Color(n2));
        treeViewer.setSelectionColor(new Color(n3));
        treeViewer.setBranchStroke(new BasicStroke(f, 1, 1));
        this.tipKey = string;
        this.nodeKey = string2;
        this.branchKey = string3;
        String string4 = DEFAULT_FONT_NAME;
        int n4 = DEFAULT_FONT_STYLE;
        int n5 = DEFAULT_FONT_SIZE;
        String string5 = DEFAULT_NUMBER_FORMATTING;
        labelPainter.setFont(new Font(string4, n4, n5));
        labelPainter.setNumberFormat(new DecimalFormat(string5));
        labelPainter2.setFont(new Font(string4, n4, n5));
        labelPainter2.setNumberFormat(new DecimalFormat(string5));
        labelPainter3.setFont(new Font(string4, n4, n5));
        labelPainter3.setNumberFormat(new DecimalFormat(string5));
        this.optionsPanel = new OptionsPanel();
        if (!bl) {
            this.branchColourAttributeCombo = new JComboBox<String>(new String[]{"No attributes"});
            this.setupAttributes(treeViewer.getTrees());
            this.branchColourAttributeCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (TreeAppearanceController.this.branchColourAttributeCombo.getSelectedIndex() == 0) {
                        treeViewer.setBranchColouringDecorator(null, null);
                        treeViewer.setBranchDecorator(attributableDecorator, false);
                    } else {
                        HashSet<Node> hashSet = new HashSet<Node>();
                        for (Tree object : treeViewer.getTrees()) {
                            for (Node node : object.getNodes()) {
                                hashSet.add(node);
                            }
                        }
                        String string = (String)TreeAppearanceController.this.branchColourAttributeCombo.getSelectedItem();
                        if (string != null && string.length() > 0) {
                            if (string.endsWith("*")) {
                                DiscreteColourDecorator discreteColourDecorator = new DiscreteColourDecorator();
                                treeViewer.setBranchColouringDecorator(string.substring(0, string.length() - 2), discreteColourDecorator);
                                treeViewer.setBranchDecorator(null, false);
                            } else if (DiscreteColourDecorator.isDiscrete(string, hashSet)) {
                                HSBDiscreteColourDecorator hSBDiscreteColourDecorator = new HSBDiscreteColourDecorator(string, hashSet);
                                treeViewer.setBranchColouringDecorator(null, null);
                                treeViewer.setBranchDecorator(hSBDiscreteColourDecorator, false);
                            } else {
                                InterpolatingColourDecorator interpolatingColourDecorator = new InterpolatingColourDecorator(new ContinuousScale(string, hashSet), new Color(192, 16, 0), new Color(0, 16, 192));
                                treeViewer.setBranchColouringDecorator(null, null);
                                treeViewer.setBranchDecorator(interpolatingColourDecorator, false);
                            }
                        }
                    }
                }
            });
            this.optionsPanel.addComponentWithLabel("Colour by:", this.branchColourAttributeCombo);
        } else {
            this.branchColourAttributeCombo = null;
        }
        this.branchLineWidthSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.01, 48.0, 1.0));
        this.branchLineWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)TreeAppearanceController.this.branchLineWidthSpinner.getValue()).floatValue();
                treeViewer.setBranchStroke(new BasicStroke(f, 0, 0));
            }
        });
        this.optionsPanel.addComponentWithLabel("Line Weight:", this.branchLineWidthSpinner);
        Font font = labelPainter.getFont();
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel((double)font.getSize(), 0.01, 48.0, 1.0));
        this.optionsPanel.addComponentWithLabel("Font Size:", this.fontSizeSpinner);
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)TreeAppearanceController.this.fontSizeSpinner.getValue()).floatValue();
                Font font = labelPainter.getFont().deriveFont(f);
                labelPainter.setFont(font);
                font = labelPainter2.getFont().deriveFont(f);
                labelPainter2.setFont(font);
                font = labelPainter3.getFont().deriveFont(f);
                labelPainter3.setFont(font);
            }
        });
        NumberFormat numberFormat = labelPainter.getNumberFormat();
        int n6 = numberFormat.getMaximumFractionDigits();
        this.digitsSpinner = new JSpinner(new SpinnerNumberModel(n6, 2, 14, 1));
        this.digitsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)TreeAppearanceController.this.digitsSpinner.getValue();
                NumberFormat numberFormat = labelPainter.getNumberFormat();
                numberFormat.setMaximumFractionDigits(n);
                labelPainter.setNumberFormat(numberFormat);
                numberFormat = labelPainter2.getNumberFormat();
                numberFormat.setMaximumFractionDigits(n);
                labelPainter2.setNumberFormat(numberFormat);
                numberFormat = labelPainter3.getNumberFormat();
                numberFormat.setMaximumFractionDigits(n);
                labelPainter3.setNumberFormat(numberFormat);
            }
        });
        if (!bl) {
            treeViewer.addTreeViewerListener(new TreeViewerListener(){

                @Override
                public void treeChanged() {
                    TreeAppearanceController.this.setupAttributes(treeViewer.getTrees());
                    TreeAppearanceController.this.optionsPanel.repaint();
                }

                @Override
                public void treeSettingsChanged() {
                }
            });
        }
        if (bl2) {
            this.orderCombo = new JComboBox<String>(new String[]{"Off", SortedRootedTree.BranchOrdering.INCREASING_NODE_DENSITY.toString(), SortedRootedTree.BranchOrdering.DECREASING_NODE_DENSITY.toString()});
            this.orderCombo.setOpaque(false);
            this.orderCombo.setSelectedItem(treeViewer.isOrderBranchesOn() ? treeViewer.getBranchOrdering().ordinal() + 1 : 0);
            this.orderCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (TreeAppearanceController.this.orderCombo.getSelectedIndex() == 0) {
                        treeViewer.setOrderBranchesOn(false);
                    } else {
                        treeViewer.setOrderBranchesOn(true);
                        treeViewer.setBranchOrdering(SortedRootedTree.BranchOrdering.values()[TreeAppearanceController.this.orderCombo.getSelectedIndex() - 1]);
                    }
                }
            });
            this.optionsPanel.addComponentWithLabel("Order:", this.orderCombo);
        } else {
            this.orderCombo = null;
        }
    }

    private void setupAttributes(Collection<? extends Tree> collection) {
        Object object = this.branchColourAttributeCombo.getSelectedItem();
        this.branchColourAttributeCombo.removeAllItems();
        this.branchColourAttributeCombo.addItem("User Selection");
        if (collection == null) {
            return;
        }
        for (Tree tree : collection) {
            for (String string : this.getAttributeNames(tree.getNodes())) {
                this.branchColourAttributeCombo.addItem(string);
            }
        }
        this.branchColourAttributeCombo.setSelectedItem(object);
    }

    private String[] getAttributeNames(Collection<? extends Attributable> collection) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Attributable attributable : collection) {
            for (String string : attributable.getAttributeNames()) {
                if (string.startsWith("!")) continue;
                Object object = attributable.getAttribute(string);
                if (!(object instanceof Object[])) {
                    treeSet.add(string);
                    continue;
                }
                boolean bl = true;
                Object[] objectArray = (Object[])object;
                boolean bl2 = true;
                for (Object object2 : objectArray) {
                    if (bl2 && !(object2 instanceof Integer) || !bl2 && !(object2 instanceof Double)) {
                        bl = false;
                        break;
                    }
                    bl2 = !bl2;
                }
                if (bl2) {
                    bl = false;
                }
                if (!bl) continue;
                treeSet.add(string + " *");
            }
        }
        String[] stringArray = new String[treeSet.size()];
        treeSet.toArray(stringArray);
        return stringArray;
    }

    @Override
    public JComponent getTitleComponent() {
        return null;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.treeViewer.setForeground((Color)map.get("appearance.foregroundColour"));
        this.treeViewer.setBackground((Color)map.get("appearance.backgroundColour"));
        this.treeViewer.setSelectionColor((Color)map.get("appearance.selectionColour"));
        if (this.branchColourAttributeCombo != null) {
            this.branchColourAttributeCombo.setSelectedItem(map.get("appearance.branchColorAttribute"));
        }
        this.branchLineWidthSpinner.setValue((Double)map.get("appearance.branchLineWidth"));
        this.fontSizeSpinner.setValue(((Number)map.get(this.tipKey + "." + FONT_SIZE_KEY)).doubleValue());
        this.digitsSpinner.setValue((Integer)map.get(this.tipKey + "." + SIGNIFICANT_DIGITS_KEY));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("appearance.foregroundColour", this.treeViewer.getForeground());
        map.put("appearance.backgroundColour", this.treeViewer.getBackground());
        map.put("appearance.selectionColour", this.treeViewer.getSelectionPaint());
        if (this.branchColourAttributeCombo != null) {
            map.put("appearance.branchColorAttribute", this.branchColourAttributeCombo.getSelectedItem().toString());
        }
        map.put("appearance.branchLineWidth", this.branchLineWidthSpinner.getValue());
        map.put(this.tipKey + "." + FONT_SIZE_KEY, this.fontSizeSpinner.getValue());
        map.put(this.tipKey + "." + SIGNIFICANT_DIGITS_KEY, this.digitsSpinner.getValue());
    }
}

