/*
 * Decompiled with CFR 0.152.
 */
package figtree.application.preferences;

import figtree.application.FigTreeApplication;
import figtree.treeviewer.painters.LabelPainterController;
import figtree.treeviewer.painters.ScaleBarPainterController;
import figtree.ui.FontChooserPanel;
import jam.panels.OptionsPanel;
import jam.preferences.PreferencesSection;
import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class FontsPreferencesSection
implements PreferencesSection {
    Icon projectToolIcon = IconUtils.getIcon(FigTreeApplication.class, "images/prefsFonts.png");
    FontChooserPanel tipLabelFontChooser = null;
    FontChooserPanel nodeLabelFontChooser = null;
    FontChooserPanel branchLabelFontChooser = null;
    FontChooserPanel scaleLabelFontChooser = null;

    @Override
    public String getTitle() {
        return "Fonts";
    }

    @Override
    public Icon getIcon() {
        return this.projectToolIcon;
    }

    @Override
    public JPanel getPanel() {
        Font font;
        Serializable serializable;
        OptionsPanel optionsPanel = new OptionsPanel(12, 18);
        if (this.tipLabelFontChooser == null) {
            serializable = new Font(LabelPainterController.DEFAULT_FONT_NAME, LabelPainterController.DEFAULT_FONT_STYLE, LabelPainterController.DEFAULT_FONT_SIZE);
            this.tipLabelFontChooser = new FontChooserPanel((Font)serializable);
        }
        serializable = new JPanel(new BorderLayout());
        ((Container)serializable).add(this.tipLabelFontChooser, "Center");
        ((JComponent)serializable).setBorder(new TitledBorder("Tip Labels"));
        optionsPanel.addSpanningComponent((JComponent)serializable);
        if (this.nodeLabelFontChooser == null) {
            font = new Font(LabelPainterController.DEFAULT_FONT_NAME, LabelPainterController.DEFAULT_FONT_STYLE, LabelPainterController.DEFAULT_FONT_SIZE);
            this.nodeLabelFontChooser = new FontChooserPanel(font);
        }
        serializable = new JPanel(new BorderLayout());
        ((Container)serializable).add(this.nodeLabelFontChooser, "Center");
        ((JComponent)serializable).setBorder(new TitledBorder("Node Labels"));
        optionsPanel.addSpanningComponent((JComponent)serializable);
        if (this.branchLabelFontChooser == null) {
            font = new Font(LabelPainterController.DEFAULT_FONT_NAME, LabelPainterController.DEFAULT_FONT_STYLE, LabelPainterController.DEFAULT_FONT_SIZE);
            this.branchLabelFontChooser = new FontChooserPanel(font);
        }
        serializable = new JPanel(new BorderLayout());
        ((Container)serializable).add(this.branchLabelFontChooser, "Center");
        ((JComponent)serializable).setBorder(new TitledBorder("Branch Labels"));
        optionsPanel.addSpanningComponent((JComponent)serializable);
        if (this.scaleLabelFontChooser == null) {
            font = new Font(LabelPainterController.DEFAULT_FONT_NAME, LabelPainterController.DEFAULT_FONT_STYLE, LabelPainterController.DEFAULT_FONT_SIZE);
            this.scaleLabelFontChooser = new FontChooserPanel(font);
        }
        serializable = new JPanel(new BorderLayout());
        ((Container)serializable).add(this.scaleLabelFontChooser, "Center");
        ((JComponent)serializable).setBorder(new TitledBorder("Scale Bar/Axis Labels"));
        optionsPanel.addSpanningComponent((JComponent)serializable);
        optionsPanel.addFlexibleSpace();
        return optionsPanel;
    }

    @Override
    public void retrievePreferences() {
        String string = LabelPainterController.PREFS.get("tipLabels.fontName", LabelPainterController.DEFAULT_FONT_NAME);
        int n = LabelPainterController.PREFS.getInt("tipLabels.fontSize", LabelPainterController.DEFAULT_FONT_SIZE);
        int n2 = LabelPainterController.PREFS.getInt("tipLabels.fontStyle", LabelPainterController.DEFAULT_FONT_STYLE);
        Font font = new Font(string, n2, n);
        this.tipLabelFontChooser.setSelectedFont(font);
        string = LabelPainterController.PREFS.get("nodeLabels.fontName", LabelPainterController.DEFAULT_FONT_NAME);
        n = LabelPainterController.PREFS.getInt("nodeLabels.fontSize", LabelPainterController.DEFAULT_FONT_SIZE);
        n2 = LabelPainterController.PREFS.getInt("nodeLabels.fontStyle", LabelPainterController.DEFAULT_FONT_STYLE);
        font = new Font(string, n2, n);
        this.nodeLabelFontChooser.setSelectedFont(font);
        string = LabelPainterController.PREFS.get("branchLabels.fontName", LabelPainterController.DEFAULT_FONT_NAME);
        n = LabelPainterController.PREFS.getInt("branchLabels.fontSize", LabelPainterController.DEFAULT_FONT_SIZE);
        n2 = LabelPainterController.PREFS.getInt("branchLabels.fontStyle", LabelPainterController.DEFAULT_FONT_STYLE);
        font = new Font(string, n2, n);
        this.branchLabelFontChooser.setSelectedFont(font);
        string = ScaleBarPainterController.PREFS.get("scaleBar.fontName", ScaleBarPainterController.DEFAULT_FONT_NAME);
        n = ScaleBarPainterController.PREFS.getInt("scaleBar.fontSize", ScaleBarPainterController.DEFAULT_FONT_SIZE);
        n2 = ScaleBarPainterController.PREFS.getInt("scaleBar.fontStyle", ScaleBarPainterController.DEFAULT_FONT_STYLE);
        font = new Font(string, n2, n);
        this.scaleLabelFontChooser.setSelectedFont(font);
    }

    @Override
    public void storePreferences() {
        Font font = this.tipLabelFontChooser.getSelectedFont();
        LabelPainterController.PREFS.put("tipLabels.fontName", font.getName());
        LabelPainterController.PREFS.putInt("tipLabels.fontSize", font.getSize());
        LabelPainterController.PREFS.putInt("tipLabels.fontStyle", font.getStyle());
        font = this.nodeLabelFontChooser.getSelectedFont();
        LabelPainterController.PREFS.put("nodeLabels.fontName", font.getName());
        LabelPainterController.PREFS.putInt("nodeLabels.fontSize", font.getSize());
        LabelPainterController.PREFS.putInt("nodeLabels.fontStyle", font.getStyle());
        font = this.branchLabelFontChooser.getSelectedFont();
        LabelPainterController.PREFS.put("branchLabels.fontName", font.getName());
        LabelPainterController.PREFS.putInt("branchLabels.fontSize", font.getSize());
        LabelPainterController.PREFS.putInt("branchLabels.fontStyle", font.getStyle());
        font = this.scaleLabelFontChooser.getSelectedFont();
        ScaleBarPainterController.PREFS.put("scaleBar.fontName", font.getName());
        ScaleBarPainterController.PREFS.putInt("scaleBar.fontSize", font.getSize());
        ScaleBarPainterController.PREFS.putInt("scaleBar.fontStyle", font.getStyle());
    }
}

