/*
 * Decompiled with CFR 0.152.
 */
package figtree.application;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.DefaultFontMapper;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import figtree.application.ExportTreeDialog;
import figtree.application.FigTreeNexusExporter;
import figtree.application.FigTreeNexusImporter;
import figtree.application.FigTreePanel;
import figtree.application.GraphicFormat;
import figtree.application.JSONTreeExporter;
import figtree.application.menus.FigTreeFileMenuHandler;
import figtree.application.menus.TreeMenuHandler;
import figtree.treeviewer.AnnotationsListener;
import figtree.treeviewer.ExtendedTreeViewer;
import figtree.treeviewer.FindPanel;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.TreePaneSelector;
import figtree.treeviewer.TreeSelectionListener;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import figtree.treeviewer.annotations.AnnotationDefinition;
import figtree.treeviewer.annotations.AnnotationDefinitionsDialog;
import figtree.treeviewer.annotations.AnnotationDialog;
import figtree.treeviewer.annotations.SelectAnnotationDialog;
import jam.controlpalettes.BasicControlPalette;
import jam.controlpalettes.ControlPalette;
import jam.framework.DocumentFrame;
import jam.panels.SearchPanel;
import jam.panels.SearchPanelListener;
import jam.panels.StatusBar;
import jam.toolbar.GenericToolbarItem;
import jam.toolbar.Toolbar;
import jam.toolbar.ToolbarAction;
import jam.toolbar.ToolbarButton;
import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.ProgressMonitorInputStream;
import jebl.evolution.alignments.BasicAlignment;
import jebl.evolution.graphs.Node;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.NewickExporter;
import jebl.evolution.io.NewickImporter;
import jebl.evolution.io.NexusImporter;
import jebl.evolution.io.TreeImporter;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;

public class FigTreeFrame
extends DocumentFrame
implements FigTreeFileMenuHandler,
TreeMenuHandler {
    private final ExtendedTreeViewer treeViewer;
    private final ControlPalette controlPalette;
    private final FigTreePanel figTreePanel;
    private StatusBar statusBar;
    private SearchPanel filterPanel;
    private JPopupMenu filterPopup;
    private static Color lastColor = Color.GRAY;
    private AbstractAction importAction = new AbstractAction("Import Annotations..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doImport();
        }
    };
    private AbstractAction importCharactersAction = new AbstractAction("Import Characters..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doImportCharacters();
        }
    };
    private AbstractAction importColourSchemeAction = new AbstractAction("Import Colour Scheme..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doImportColourScheme();
        }
    };
    private AbstractAction exportColourSchemeAction = new AbstractAction("Export Colour Scheme..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    private AbstractAction exportTreesAction = new AbstractAction("Export Trees..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doExport();
        }
    };
    private AbstractAction exportPNGGraphicAction = new AbstractAction("Export PNG..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doExportGraphic(GraphicFormat.PNG);
        }
    };
    private AbstractAction exportJPEGGraphicAction = new AbstractAction("Export JPEG..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doExportGraphic(GraphicFormat.JPEG);
        }
    };
    private AbstractAction exportSVGAction = new AbstractAction("Export SVG..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doExportGraphic(GraphicFormat.SVG);
        }
    };
    private AbstractAction exportPDFAction = new AbstractAction("Export PDF..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doExportGraphic(GraphicFormat.PDF);
        }
    };
    private AbstractAction nextTreeAction = new AbstractAction("Next Tree"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.treeViewer.showNextTree();
        }
    };
    private AbstractAction previousTreeAction = new AbstractAction("Previous Tree"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.treeViewer.showPreviousTree();
        }
    };
    private AbstractAction cartoonAction = new AbstractAction("Draw Subtree as Cartoon"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.cartoonSelected();
        }
    };
    private AbstractAction collapseAction = new AbstractAction("Draw Subtree as Collapsed"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.collapseSelected();
        }
    };
    private AbstractAction clearCollapsedAction = new AbstractAction("Clear Collapsed/Cartoon"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.treeViewer.clearCollapsedNodes();
        }
    };
    private AbstractAction rerootAction = new AbstractAction("Root on Branch..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.rerootTree();
        }
    };
    private AbstractAction midpointRootAction = new AbstractAction("Midpoint Root"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.figTreePanel.toggleMidpointRoot();
        }
    };
    private AbstractAction clearRootingAction = new AbstractAction("Clear Rooting..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.treeViewer.clearRooting();
        }
    };
    private AbstractAction rotateAction = new AbstractAction("Rotate Node..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.rotateTree();
        }
    };
    private AbstractAction clearRotationsAction = new AbstractAction("Clear Rotations..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.treeViewer.clearRotations();
        }
    };
    private AbstractAction increasingNodeOrderAction = new AbstractAction("Increasing Node Order"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.figTreePanel.toggleIncreasingNodeOrder();
        }
    };
    private AbstractAction decreasingNodeOrderAction = new AbstractAction("Decreasing Node Order"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.figTreePanel.toggleDecreasingNodeOrder();
        }
    };
    private AbstractAction annotateAction = new AbstractAction("Annotate..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.annotateSelected();
        }
    };
    private AbstractAction copyAnnotationsAction = new AbstractAction("Copy values..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.copySelectedAnnotations();
        }
    };
    private AbstractAction annotateNodesFromTipsAction = new AbstractAction("Annotate Nodes from Tips..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.annotateNodesFromTips();
        }
    };
    private AbstractAction annotateTipsFromNodesAction = new AbstractAction("Annotate Tips from Nodes..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.annotateTipsFromNodes();
        }
    };
    private AbstractAction clearAnnotationsAction = new AbstractAction("Clear Annotations"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    private AbstractAction defineAnnotationsAction = new AbstractAction("Define Annotations..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.defineAnnotations();
        }
    };
    private AbstractAction colourAction = new AbstractAction("Colour..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.colourSelected();
        }
    };
    private AbstractAction clearColouringAction = new AbstractAction("Clear Colouring..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.treeViewer.clearColouring();
        }
    };
    private AbstractAction hilightAction = new AbstractAction("Hilight..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.hilightSelected();
        }
    };
    private AbstractAction clearHilightingAction = new AbstractAction("Clear Hilighting..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.treeViewer.clearHilighting();
        }
    };
    private AbstractAction findAction = new AbstractAction("Find..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doFind();
        }
    };
    private AbstractAction findAllAction = new AbstractAction("Find"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doFindAll();
        }
    };
    private AbstractAction getInfoAction = new AbstractAction("Get Info..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FigTreeFrame.this.doGetInfo();
        }
    };
    private ExportTreeDialog exportTreeDialog = null;
    private FindPanel findPanel = null;
    private AnnotationDefinitionsDialog annotationDefinitionsDialog = null;
    private AnnotationDialog annotationDialog = null;
    private AnnotationDialog copyAnnotationDialog = null;
    private SelectAnnotationDialog selectAnnotationDialog = null;

    public FigTreeFrame(String string) {
        this.setTitle(string);
        this.setImportAction(this.importAction);
        this.setExportAction(this.exportTreesAction);
        this.treeViewer = new ExtendedTreeViewer(this);
        this.controlPalette = new BasicControlPalette(200, BasicControlPalette.DisplayMode.ONLY_ONE_OPEN);
        this.figTreePanel = new FigTreePanel(this, this.treeViewer, this.controlPalette);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                FigTreeFrame.this.treeViewer.requestFocusInWindow();
            }
        });
    }

    @Override
    public void initializeComponents() {
        this.setSize(new Dimension(1024, 768));
        Toolbar toolbar = new Toolbar();
        toolbar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray));
        toolbar.setRollover(true);
        toolbar.setFloatable(false);
        Icon icon = IconUtils.getIcon(this.getClass(), "images/rerootTool.png");
        Icon icon2 = IconUtils.getIcon(this.getClass(), "images/rotateTool.png");
        Icon icon3 = IconUtils.getIcon(this.getClass(), "images/cartoonNodeTool.png");
        Icon icon4 = IconUtils.getIcon(this.getClass(), "images/collapseNodeTool.png");
        Icon icon5 = IconUtils.getIcon(this.getClass(), "images/hilightTool.png");
        Icon icon6 = IconUtils.getIcon(this.getClass(), "images/annotationTool.png");
        Icon icon7 = IconUtils.getIcon(this.getClass(), "images/findTool.png");
        Icon icon8 = IconUtils.getIcon(this.getClass(), "images/infoTool.png");
        Icon icon9 = IconUtils.getIcon(this.getClass(), "images/statisticsTool.png");
        Icon icon10 = IconUtils.getIcon(this.getClass(), "images/projectTool.png");
        Icon icon11 = IconUtils.getIcon(this.getClass(), "images/coloursTool.png");
        Icon icon12 = IconUtils.getIcon(this.getClass(), "images/next.png");
        Icon icon13 = IconUtils.getIcon(this.getClass(), "images/prev.png");
        final ToolbarAction toolbarAction = new ToolbarAction("Cartoon", "Draw Subtree as Cartoon", icon3){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FigTreeFrame.this.cartoonAction.actionPerformed(actionEvent);
            }
        };
        ToolbarButton toolbarButton = new ToolbarButton(toolbarAction, true);
        toolbarButton.setFocusable(false);
        toolbar.addComponent(toolbarButton);
        final ToolbarAction toolbarAction2 = new ToolbarAction("Collapse", "Draw Subtree as Collapsed", icon4){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FigTreeFrame.this.collapseAction.actionPerformed(actionEvent);
            }
        };
        ToolbarButton toolbarButton2 = new ToolbarButton(toolbarAction2, true);
        toolbarButton2.setFocusable(false);
        toolbar.addComponent(toolbarButton2);
        final ToolbarAction toolbarAction3 = new ToolbarAction("Reroot", "Root on Branch...", icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FigTreeFrame.this.rerootAction.actionPerformed(actionEvent);
            }
        };
        ToolbarButton toolbarButton3 = new ToolbarButton(toolbarAction3, true);
        toolbarButton3.setFocusable(false);
        toolbar.addComponent(toolbarButton3);
        final ToolbarAction toolbarAction4 = new ToolbarAction("Rotate", "Rotate Node...", icon2){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FigTreeFrame.this.rotateAction.actionPerformed(actionEvent);
            }
        };
        ToolbarButton toolbarButton4 = new ToolbarButton(toolbarAction4, true);
        toolbarButton4.setFocusable(false);
        toolbar.addComponent(toolbarButton4);
        final ToolbarAction toolbarAction5 = new ToolbarAction("Annotate", "Annotate...", icon6){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FigTreeFrame.this.annotateAction.actionPerformed(actionEvent);
            }
        };
        ToolbarButton toolbarButton5 = new ToolbarButton(toolbarAction5, true);
        toolbarButton5.setFocusable(false);
        toolbar.addComponent(toolbarButton5);
        final ToolbarAction toolbarAction6 = new ToolbarAction("Colour", "Colour...", icon11){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FigTreeFrame.this.colourAction.actionPerformed(actionEvent);
            }
        };
        ToolbarButton toolbarButton6 = new ToolbarButton(toolbarAction6, true);
        toolbarButton6.setFocusable(false);
        toolbar.addComponent(toolbarButton6);
        final ToolbarAction toolbarAction7 = new ToolbarAction("Hilight", "Hilight...", icon5){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FigTreeFrame.this.hilightAction.actionPerformed(actionEvent);
            }
        };
        ToolbarButton toolbarButton7 = new ToolbarButton(toolbarAction7, true);
        toolbarButton7.setFocusable(false);
        toolbar.addComponent(toolbarButton7);
        toolbar.addSeparator();
        ToolbarAction toolbarAction8 = new ToolbarAction("Find", "Find Taxa...", icon7){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FigTreeFrame.this.findAction.actionPerformed(actionEvent);
            }
        };
        ToolbarButton toolbarButton8 = new ToolbarButton(toolbarAction8);
        toolbarButton8.setFocusable(false);
        toolbar.addComponent(toolbarButton8);
        toolbarButton8.setEnabled(true);
        toolbar.addSeparator();
        Box box = Box.createHorizontalBox();
        JToggleButton jToggleButton = new JToggleButton("Node");
        jToggleButton.setFocusable(false);
        jToggleButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        jToggleButton.putClientProperty("JButton.segmentPosition", "first");
        jToggleButton.putClientProperty("Quaqua.Button.style", "toggleWest");
        JToggleButton jToggleButton2 = new JToggleButton("Clade");
        jToggleButton2.setFocusable(false);
        jToggleButton2.putClientProperty("JButton.buttonType", "segmentedTextured");
        jToggleButton2.putClientProperty("JButton.segmentPosition", "middle");
        jToggleButton2.putClientProperty("Quaqua.Button.style", "toggleCenter");
        JToggleButton jToggleButton3 = new JToggleButton("Taxa");
        jToggleButton3.setFocusable(false);
        jToggleButton3.putClientProperty("JButton.buttonType", "segmentedTextured");
        jToggleButton3.putClientProperty("JButton.segmentPosition", "last");
        jToggleButton3.putClientProperty("Quaqua.Button.style", "toggleEast");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
        buttonGroup.add(jToggleButton3);
        jToggleButton.setSelected(true);
        jToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FigTreeFrame.this.treeViewer.setSelectionMode(TreePaneSelector.SelectionMode.NODE);
                }
            }
        });
        jToggleButton2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FigTreeFrame.this.treeViewer.setSelectionMode(TreePaneSelector.SelectionMode.CLADE);
                }
            }
        });
        jToggleButton3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FigTreeFrame.this.treeViewer.setSelectionMode(TreePaneSelector.SelectionMode.TAXA);
                }
            }
        });
        box.add(Box.createVerticalStrut(icon6.getIconHeight()));
        box.add(jToggleButton);
        box.add(jToggleButton2);
        box.add(jToggleButton3);
        toolbar.addComponent(new GenericToolbarItem("Selection Mode", "What aspect of the tree is selected when it is clicked", box));
        toolbar.addFlexibleSpace();
        final ToolbarAction toolbarAction9 = new ToolbarAction(null, "Previous Tree...", icon13){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FigTreeFrame.this.treeViewer.isRootingOn() && FigTreeFrame.this.treeViewer.getRootingType() == TreePane.RootingType.USER_ROOTING) {
                    JOptionPane.showMessageDialog(FigTreeFrame.this, "Cannot switch trees when user rooting option is on.\nTurn this option off to switch trees", "Unable to switch trees", 0);
                } else {
                    FigTreeFrame.this.treeViewer.showPreviousTree();
                }
            }
        };
        ToolbarButton toolbarButton9 = new ToolbarButton(toolbarAction9, true);
        toolbarButton9.setFocusable(false);
        toolbarButton9.putClientProperty("JButton.buttonType", "segmentedTextured");
        toolbarButton9.putClientProperty("JButton.segmentPosition", "first");
        toolbarButton9.putClientProperty("Quaqua.Button.style", "toggleWest");
        final ToolbarAction toolbarAction10 = new ToolbarAction(null, "Next Tree...", icon12){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FigTreeFrame.this.treeViewer.isRootingOn() && FigTreeFrame.this.treeViewer.getRootingType() == TreePane.RootingType.USER_ROOTING) {
                    JOptionPane.showMessageDialog(FigTreeFrame.this, "Cannot switch trees when user rooting option is on.\nTurn this option off to switch trees", "Unable to switch trees", 0);
                } else {
                    FigTreeFrame.this.treeViewer.showNextTree();
                }
            }
        };
        ToolbarButton toolbarButton10 = new ToolbarButton(toolbarAction10, true);
        toolbarButton10.setFocusable(false);
        toolbarButton10.putClientProperty("JButton.buttonType", "segmentedTextured");
        toolbarButton10.putClientProperty("JButton.segmentPosition", "last");
        toolbarButton10.putClientProperty("Quaqua.Button.style", "toggleEast");
        toolbarAction10.setEnabled(this.treeViewer.getCurrentTreeIndex() < this.treeViewer.getTreeCount() - 1);
        toolbarAction9.setEnabled(this.treeViewer.getCurrentTreeIndex() > 0);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createVerticalStrut(icon6.getIconHeight()));
        box2.add(toolbarButton9);
        box2.add(toolbarButton10);
        toolbar.addComponent(new GenericToolbarItem("Prev/Next", "Navigate through the trees", box2));
        TreeViewerListener treeViewerListener = new TreeViewerListener(){

            @Override
            public void treeChanged() {
                boolean bl = FigTreeFrame.this.treeViewer.getCurrentTreeIndex() < FigTreeFrame.this.treeViewer.getTreeCount() - 1;
                FigTreeFrame.this.nextTreeAction.setEnabled(bl);
                toolbarAction10.setEnabled(bl);
                boolean bl2 = FigTreeFrame.this.treeViewer.getCurrentTreeIndex() > 0;
                FigTreeFrame.this.previousTreeAction.setEnabled(bl2);
                toolbarAction9.setEnabled(bl2);
            }

            @Override
            public void treeSettingsChanged() {
            }
        };
        this.treeViewer.addTreeViewerListener(treeViewerListener);
        treeViewerListener.treeChanged();
        toolbar.addFlexibleSpace();
        this.filterPopup = new JPopupMenu();
        final ButtonGroup buttonGroup2 = new ButtonGroup();
        boolean bl = true;
        for (TreeViewer.TextSearchType textSearchType : TreeViewer.TextSearchType.values()) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(textSearchType.toString());
            if (bl) {
                jCheckBoxMenuItem.setSelected(true);
                bl = false;
            }
            this.filterPopup.add(jCheckBoxMenuItem);
            buttonGroup2.add(jCheckBoxMenuItem);
        }
        this.filterPanel = new SearchPanel("Filter", this.filterPopup, true);
        this.filterPanel.addSearchPanelListener(new SearchPanelListener(){

            @Override
            public void searchStarted(String string) {
                Enumeration<AbstractButton> enumeration = buttonGroup2.getElements();
                String string2 = null;
                while (enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    if (!abstractButton.isSelected()) continue;
                    string2 = abstractButton.getText();
                }
                for (TreeViewer.TextSearchType textSearchType : TreeViewer.TextSearchType.values()) {
                    if (!textSearchType.toString().equals(string2)) continue;
                    FigTreeFrame.this.treeViewer.selectTaxa(textSearchType, string, false);
                }
            }

            @Override
            public void searchStopped() {
                FigTreeFrame.this.treeViewer.clearSelectedTaxa();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.filterPanel);
        toolbar.addComponent(jPanel);
        this.statusBar = new StatusBar("FigTree");
        this.statusBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.darkGray), BorderFactory.createMatteBorder(1, 0, 0, 0, Color.lightGray)), BorderFactory.createEmptyBorder(2, 12, 2, 12)));
        this.statusBar.setOpaque(false);
        this.statusBar.setStatusProvider(this.treeViewer.getStatusProvider());
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)toolbar, "North");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)jPanel2, "North");
        this.getContentPane().add((Component)this.figTreePanel, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void selectionChanged() {
                boolean bl = FigTreeFrame.this.treeViewer.hasSelection();
                toolbarAction.setEnabled(bl);
                FigTreeFrame.this.cartoonAction.setEnabled(bl);
                toolbarAction2.setEnabled(bl);
                FigTreeFrame.this.collapseAction.setEnabled(bl);
                toolbarAction7.setEnabled(bl);
                FigTreeFrame.this.hilightAction.setEnabled(bl);
                FigTreeFrame.this.clearHilightingAction.setEnabled(bl);
                toolbarAction3.setEnabled(bl);
                FigTreeFrame.this.rerootAction.setEnabled(bl);
                FigTreeFrame.this.clearRootingAction.setEnabled(bl);
                toolbarAction4.setEnabled(bl);
                FigTreeFrame.this.rotateAction.setEnabled(bl);
                toolbarAction5.setEnabled(bl);
                FigTreeFrame.this.annotateAction.setEnabled(bl);
                toolbarAction6.setEnabled(bl);
                FigTreeFrame.this.colourAction.setEnabled(bl);
                FigTreeFrame.this.clearColouringAction.setEnabled(bl);
            }
        };
        this.treeViewer.addTreeSelectionListener(treeSelectionListener);
        treeSelectionListener.selectionChanged();
        this.getCutAction().setEnabled(false);
        this.getCopyAction().setEnabled(true);
        this.getDeleteAction().setEnabled(false);
        this.getSelectAllAction().setEnabled(true);
        this.getFindAction().setEnabled(true);
        this.getZoomWindowAction().setEnabled(false);
    }

    private void defineAnnotations() {
        Collection<AnnotationDefinition> collection = this.treeViewer.getAnnotationDefinitions().values();
        if (this.annotationDefinitionsDialog == null) {
            this.annotationDefinitionsDialog = new AnnotationDefinitionsDialog(this);
        }
        this.annotationDefinitionsDialog.showDialog(collection);
        this.treeViewer.setAnnotationDefinitions(this.annotationDefinitionsDialog.getAnnotations());
        this.treeViewer.fireAnnotationsChanged();
    }

    private void annotateNodesFromTips() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Colour");
        arrayList.addAll(this.treeViewer.getAnnotationDefinitions().keySet());
        arrayList.add("Name");
        if (this.selectAnnotationDialog == null) {
            this.selectAnnotationDialog = new SelectAnnotationDialog(this);
        }
        if ((n = this.selectAnnotationDialog.showDialog(arrayList)) == 2 || n == -1) {
            return;
        }
        String string = this.selectAnnotationDialog.getAnnotationName();
        if (string.equals("Colour")) {
            string = "!color";
        }
        this.treeViewer.annotateNodesFromTips(string);
        this.setDirty();
    }

    private void annotateTipsFromNodes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Colour");
        arrayList.addAll(this.treeViewer.getAnnotationDefinitions().keySet());
        if (this.selectAnnotationDialog == null) {
            this.selectAnnotationDialog = new SelectAnnotationDialog(this);
        }
        if (this.selectAnnotationDialog.showDialog(arrayList) != 2) {
            String string = this.selectAnnotationDialog.getAnnotationName();
            if (string.equals("Colour")) {
                string = "!color";
            }
            this.treeViewer.annotateTipsFromNodes(string);
            this.setDirty();
        }
    }

    private void cartoonSelected() {
        this.treeViewer.cartoonSelectedNodes();
    }

    private void collapseSelected() {
        this.treeViewer.collapseSelectedNodes();
    }

    private void hilightSelected() {
        Color color = JColorChooser.showDialog(this, "Select Colour", lastColor);
        if (color != null) {
            this.treeViewer.hilightSelectedNodes(color);
            this.setDirty();
            lastColor = color;
        }
    }

    private void rerootTree() {
        Set<Node> set = this.treeViewer.getSelectedNodes();
        if (set.size() != 1) {
            JOptionPane.showMessageDialog(this, "Exactly one branch must be selected to re-root the tree.", "Annotating Tree", 2);
            return;
        }
        this.treeViewer.rerootOnSelectedBranch();
    }

    private void rotateTree() {
        this.treeViewer.rotateSelectedNode();
    }

    private void annotateSelected() {
        this.treeViewer.setToolMode(TreePaneSelector.ToolMode.SELECT);
        ArrayList<AnnotationDefinition> arrayList = new ArrayList<AnnotationDefinition>();
        arrayList.add(new AnnotationDefinition("Name", "!name", AnnotationDefinition.Type.STRING));
        arrayList.addAll(this.treeViewer.getAnnotationDefinitions().values());
        if (this.annotationDialog == null) {
            this.annotationDialog = new AnnotationDialog(this);
        }
        Set<Node> set = this.treeViewer.getSelectedNodes();
        Set<Node> set2 = this.treeViewer.getSelectedTips();
        Attributable attributable = null;
        if (set.size() + set2.size() == 1) {
            if (set.size() == 1) {
                attributable = set.iterator().next();
            } else if (set2.size() == 1) {
                attributable = set2.iterator().next();
            }
        } else {
            int n = JOptionPane.showConfirmDialog(this, "More than one node selected for annotation. This operation\nmay overwrite existing annotations. Do you wish to continue?", "Annotating Tree", 2);
            if (n == 2 || n == -1) {
                return;
            }
        }
        if (this.annotationDialog.showDialog(arrayList, attributable) != 2) {
            AnnotationDefinition annotationDefinition = this.annotationDialog.getDefinition();
            ArrayList<AnnotationDefinition> arrayList2 = new ArrayList<AnnotationDefinition>(this.treeViewer.getAnnotationDefinitions().values());
            if (!arrayList2.contains(annotationDefinition)) {
                arrayList2.add(annotationDefinition);
                this.treeViewer.setAnnotationDefinitions(arrayList2);
            }
            String string = annotationDefinition.getCode();
            Object object = this.annotationDialog.getValue();
            this.treeViewer.annotateSelected(string, object);
            this.setDirty();
        }
    }

    private void copySelectedAnnotations() {
    }

    private void colourSelected() {
        this.treeViewer.setToolMode(TreePaneSelector.ToolMode.SELECT);
        Color color = JColorChooser.showDialog(this, "Select Colour", lastColor);
        if (color != null) {
            this.treeViewer.annotateSelected("!color", color);
            this.setDirty();
            lastColor = color;
        }
    }

    @Override
    public boolean readFromFile(File file) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new FileReader(file);
            boolean bl = this.isNexus(inputStreamReader);
            ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(this, "Reading " + file.getName(), new FileInputStream(file));
            progressMonitorInputStream.getProgressMonitor().setMillisToDecideToPopup(1000);
            progressMonitorInputStream.getProgressMonitor().setMillisToPopup(1000);
            inputStreamReader = new InputStreamReader(progressMonitorInputStream);
            boolean bl2 = this.readData(inputStreamReader, bl);
            ((Reader)inputStreamReader).close();
            return bl2;
        }
        catch (IOException iOException) {
            if (inputStreamReader != null) {
                ((Reader)inputStreamReader).close();
            }
            throw iOException;
        }
    }

    public boolean readFromURL(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        boolean bl = this.isNexus(inputStreamReader);
        ((Reader)inputStreamReader).close();
        inputStreamReader = new InputStreamReader(uRL.openStream());
        return this.readData(inputStreamReader, bl);
    }

    private boolean isNexus(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        while (string != null && string.length() == 0) {
            string = bufferedReader.readLine();
        }
        return string != null && string.toUpperCase().contains("#NEXUS");
    }

    public boolean readFromString(String string) throws IOException {
        boolean bl = string.substring(0, 80).toUpperCase().contains("#NEXUS");
        return this.readData(new StringReader(string), bl);
    }

    protected boolean readData(Reader reader, boolean bl) throws IOException {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        boolean bl2 = false;
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.controlPalette.getSettings(hashMap);
            if (bl) {
                FigTreeNexusImporter figTreeNexusImporter = new FigTreeNexusImporter(reader);
                while (figTreeNexusImporter.hasTree()) {
                    Tree tree = figTreeNexusImporter.importNextTree();
                    arrayList.add(tree);
                }
                try {
                    while (true) {
                        figTreeNexusImporter.findNextBlock();
                        if (!figTreeNexusImporter.getNextBlockName().equalsIgnoreCase("FIGTREE")) continue;
                        figTreeNexusImporter.parseFigTreeBlock(hashMap);
                        bl2 = true;
                    }
                }
                catch (EOFException eOFException) {}
            } else {
                NewickImporter newickImporter = new NewickImporter(reader, true);
                while (newickImporter.hasTree()) {
                    Tree tree = newickImporter.importNextTree();
                    arrayList.add(tree);
                }
            }
            if (arrayList.size() == 0) {
                throw new ImportException("This file contained no trees.");
            }
            this.checkLabelAttribute(arrayList);
            this.treeViewer.setTrees(arrayList);
            this.controlPalette.setSettings(hashMap);
        }
        catch (ImportException importException) {
            JOptionPane.showMessageDialog(this, "Error reading tree file: \n" + importException.getMessage(), "Import Error", 0);
            return false;
        }
        if (!bl2) {
            this.setDirty();
            this.clearFile();
        }
        return true;
    }

    private void checkLabelAttribute(List<Tree> list) {
        boolean bl = false;
        for (Tree object : list) {
            for (Node node : object.getNodes()) {
                if (node.getAttribute("label") == null) continue;
                bl = true;
            }
        }
        if (bl) {
            Object object = null;
            do {
                if ((object = JOptionPane.showInputDialog("The node/branches of the tree are labelled\n(i.e., with bootstrap values or posterior probabilities).\n\nPlease select a name for these values.", (Object)"label")) == null) {
                    object = "label";
                }
                if (((String)(object = ((String)object).trim())).length() != 0) continue;
                Toolkit.getDefaultToolkit().beep();
            } while (object == null || ((String)object).length() == 0);
            if (!((String)object).equals("label")) {
                for (Tree tree : list) {
                    for (Node node : tree.getNodes()) {
                        Object object2 = node.getAttribute("label");
                        if (object2 == null) continue;
                        node.removeAttribute("label");
                        node.setAttribute((String)object, object2);
                    }
                }
            }
        }
    }

    @Override
    protected boolean writeToFile(File file) throws IOException {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        this.controlPalette.getSettings(treeMap);
        FileWriter fileWriter = new FileWriter(file);
        FigTreeNexusExporter figTreeNexusExporter = new FigTreeNexusExporter(fileWriter, true);
        figTreeNexusExporter.exportTrees(this.treeViewer.getTrees(), true);
        figTreeNexusExporter.writeFigTreeBlock(treeMap);
        fileWriter.close();
        return true;
    }

    @Override
    public final void doImport() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Import Annotations File...", 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
            try {
                Map<AnnotationDefinition, Map<Taxon, Object>> map = this.importAnnotationsFromFile(file);
                this.treeViewer.setTaxonAnnotations(map);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, "Unable to open file: File not found", "Unable to open file", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Unable to read file: " + iOException.getMessage(), "Unable to read file", 0);
            }
        }
    }

    protected Map<AnnotationDefinition, Map<Taxon, Object>> importAnnotationsFromFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        String[] stringArray = string.split("\t");
        HashMap hashMap = new HashMap();
        for (int i = 1; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], new ArrayList());
        }
        string = bufferedReader.readLine();
        while (string != null) {
            String[] stringArray2 = string.split("\t");
            if (stringArray2.length > 0) {
                arrayList.add(stringArray2[0]);
                for (int i = 1; i < stringArray2.length; ++i) {
                    if (i >= stringArray.length) continue;
                    List list = (List)hashMap.get(stringArray[i]);
                    list.add(stringArray2[i]);
                }
            }
            string = bufferedReader.readLine();
        }
        TreeMap<AnnotationDefinition, Map<Taxon, Object>> treeMap = new TreeMap<AnnotationDefinition, Map<Taxon, Object>>();
        NumberFormat numberFormat = NumberFormat.getInstance();
        for (int i = 1; i < stringArray.length; ++i) {
            Object object2;
            List list = (List)hashMap.get(stringArray[i]);
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            for (Object object2 : list) {
                if (((String)object2).equalsIgnoreCase("TRUE") || ((String)object2).equalsIgnoreCase("FALSE")) continue;
                bl3 = false;
                try {
                    double d = Double.parseDouble((String)object2);
                    if ((double)Math.round(d) == d) continue;
                    bl = false;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    bl2 = false;
                }
            }
            HashMap hashMap2 = new HashMap();
            int n = 0;
            for (String[] stringArray3 : list) {
                Taxon taxon = Taxon.getTaxon((String)arrayList.get(n));
                if (bl3) {
                    hashMap2.put(taxon, new Boolean((String)stringArray3));
                } else if (bl) {
                    hashMap2.put(taxon, new Integer((String)stringArray3));
                } else if (bl2) {
                    hashMap2.put(taxon, new Double((String)stringArray3));
                } else {
                    hashMap2.put(taxon, stringArray3);
                }
                ++n;
            }
            HashSet hashSet = new HashSet(hashMap2.values());
            if (bl3) {
                object2 = new AnnotationDefinition(stringArray[i], AnnotationDefinition.Type.BOOLEAN);
            } else if (bl) {
                object2 = new AnnotationDefinition(stringArray[i], AnnotationDefinition.Type.INTEGER);
            } else if (bl2) {
                object2 = new AnnotationDefinition(stringArray[i], AnnotationDefinition.Type.REAL);
            } else {
                String[] stringArray3;
                stringArray3 = new String[hashSet.size()];
                hashSet.toArray(stringArray3);
                object2 = new AnnotationDefinition(stringArray[i], AnnotationDefinition.Type.STRING);
            }
            treeMap.put((AnnotationDefinition)object2, hashMap2);
        }
        return treeMap;
    }

    private void doImportCharacters() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Import Characters File...", 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
            try {
                this.importCharactersFromFile(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, "Unable to open file: File not found", "Unable to open file", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Unable to read file: " + iOException.getMessage(), "Unable to read file", 0);
            }
        }
    }

    protected boolean importCharactersFromFile(File file) throws FileNotFoundException, IOException {
        String string = file.getName();
        NexusImporter nexusImporter = new NexusImporter(new FileReader(file));
        try {
            BasicAlignment basicAlignment = new BasicAlignment(nexusImporter.importSequences());
            this.treeViewer.setCharacters(basicAlignment);
        }
        catch (ImportException importException) {
            JOptionPane.showMessageDialog(this, "Error reading characters file: " + importException.getMessage(), "Import Error", 0);
            return false;
        }
        return true;
    }

    private void doImportColourScheme() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Import Colour Scheme...", 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
            try {
                this.importColourSchemeFromFile(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, "Unable to open file: File not found", "Unable to open file", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Unable to read file: " + iOException.getMessage(), "Unable to read file", 0);
            }
        }
    }

    protected boolean importColourSchemeFromFile(File file) throws FileNotFoundException, IOException {
        String string = file.getName();
        NexusImporter nexusImporter = new NexusImporter(new FileReader(file));
        try {
            BasicAlignment basicAlignment = new BasicAlignment(nexusImporter.importSequences());
            this.treeViewer.setCharacters(basicAlignment);
        }
        catch (ImportException importException) {
            JOptionPane.showMessageDialog(this, "Error reading characters file: " + importException.getMessage(), "Import Error", 0);
            return false;
        }
        return true;
    }

    @Override
    public final void doExport() {
        if (this.exportTreeDialog == null) {
            this.exportTreeDialog = new ExportTreeDialog(this);
        }
        if (this.exportTreeDialog.showDialog() == 0) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Export Tree File...", 1);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(file);
                    this.writeTreeFile(fileWriter, this.exportTreeDialog.getFormat(), this.exportTreeDialog.allTrees(), this.exportTreeDialog.asDisplayed(), this.exportTreeDialog.includeFigTreeBlock(), this.exportTreeDialog.includeAnnotations(), false);
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Error writing tree file: " + iOException.getMessage(), "Export Error", 0);
                }
            }
        }
    }

    public final void doExportGraphic(GraphicFormat graphicFormat) {
        FileDialog fileDialog = new FileDialog((Frame)this, "Export " + graphicFormat.getName() + " File...", 1);
        String string = this.getFile().getName() + "." + graphicFormat.getName().toLowerCase();
        fileDialog.setFile(string);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FigTreeFrame.exportGraphics(graphicFormat, this.treeViewer.getContentPane(), fileOutputStream);
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
            catch (DocumentException documentException) {
                JOptionPane.showMessageDialog(this, "Error writing PDF file: " + documentException, "Export PDF Error", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Error writing tree file: " + iOException.getMessage(), "Export Error", 0);
            }
        }
    }

    public static final void exportGraphics(GraphicFormat graphicFormat, JComponent jComponent, OutputStream outputStream) throws IOException, DocumentException {
        switch (graphicFormat) {
            case PNG: 
            case GIF: 
            case BMP: 
            case JPEG: {
                FigTreeFrame.exportGraphicsFile(graphicFormat, jComponent, outputStream);
                break;
            }
            case EPS: {
                throw new UnsupportedOperationException("EPS not handled");
            }
            case SVG: {
                FigTreeFrame.exportSVGFile(jComponent, outputStream);
                break;
            }
            case PDF: {
                FigTreeFrame.exportPDFFile(jComponent, outputStream);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Format not handled: " + (Object)((Object)graphicFormat));
            }
        }
    }

    private static final void exportGraphicsFile(GraphicFormat graphicFormat, JComponent jComponent, OutputStream outputStream) throws IOException {
        int n = 1;
        if (graphicFormat == GraphicFormat.PNG) {
            n = 2;
        }
        BufferedImage bufferedImage = new BufferedImage(jComponent.getSize().width, jComponent.getSize().height, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (graphicFormat != GraphicFormat.PNG) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        jComponent.paint(graphics2D);
        graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage, graphicFormat.getName(), outputStream);
    }

    private static final void exportSVGFile(JComponent jComponent, OutputStream outputStream) throws IOException {
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        org.w3c.dom.Document document = dOMImplementation.createDocument(null, "svg", null);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        jComponent.paint(sVGGraphics2D);
        Element element = sVGGraphics2D.getRoot();
        java.awt.Rectangle rectangle = jComponent.getBounds();
        String string = "0 0 " + ((RectangularShape)rectangle).getWidth() + " " + ((RectangularShape)rectangle).getHeight();
        element.setAttributeNS(null, "viewBox", string);
        element.setAttributeNS(null, "width", Double.toString(((RectangularShape)rectangle).getWidth()));
        element.setAttributeNS(null, "height", Double.toString(((RectangularShape)rectangle).getHeight()));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        sVGGraphics2D.stream(element, outputStreamWriter, true, false);
    }

    public static final void exportPDFFile(JComponent jComponent, OutputStream outputStream) throws DocumentException {
        java.awt.Rectangle rectangle = jComponent.getBounds();
        Document document = new Document(new Rectangle((float)((RectangularShape)rectangle).getWidth(), (float)((RectangularShape)rectangle).getHeight()));
        PdfWriter pdfWriter = PdfWriter.getInstance(document, outputStream);
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)((RectangularShape)rectangle).getWidth(), (float)((RectangularShape)rectangle).getHeight());
        Graphics2D graphics2D = pdfTemplate.createGraphics((float)((RectangularShape)rectangle).getWidth(), (float)((RectangularShape)rectangle).getHeight(), new DefaultFontMapper());
        jComponent.print(graphics2D);
        graphics2D.dispose();
        pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
        document.close();
    }

    @Override
    public void doCopy() {
        StringWriter stringWriter = new StringWriter();
        try {
            if (this.treeViewer.getSelectionMode() == TreePaneSelector.SelectionMode.TAXA) {
                this.writeTaxa(stringWriter);
            } else {
                this.writeTreeFile(stringWriter, ExportTreeDialog.Format.NEXUS, true, false, false, true, true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringWriter.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    @Override
    public void doPaste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                boolean bl = string.substring(0, Math.min(80, string.length())).toUpperCase().contains("#NEXUS");
                StringReader stringReader = new StringReader(string);
                ArrayList<Tree> arrayList = new ArrayList<Tree>();
                TreeImporter treeImporter = bl ? new FigTreeNexusImporter(stringReader) : new NewickImporter(stringReader, true);
                while (treeImporter.hasTree()) {
                    Tree tree = treeImporter.importNextTree();
                    arrayList.add(tree);
                }
                if (arrayList.size() == 0) {
                    throw new ImportException("This clipboard contained no trees.");
                }
                this.treeViewer.addTrees(arrayList);
                this.treeViewer.showNextTree();
                this.setDirty();
            }
            catch (ImportException importException) {
                JOptionPane.showMessageDialog(this, "Error reading trees on clipboard: " + importException.getMessage(), "Import Error", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Error reading trees on clipboard: " + iOException.getMessage(), "Import Error", 0);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                JOptionPane.showMessageDialog(this, "Clipboard data is not compatible", "Import Error", 0);
            }
        }
    }

    @Override
    public void doSelectAll() {
        this.treeViewer.selectAll();
    }

    protected void writeTaxa(Writer writer) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer);
        for (Taxon taxon : this.treeViewer.getSelectedTaxa()) {
            printWriter.println(taxon.getName());
        }
        writer.close();
    }

    protected void writeTreeFile(Writer writer, ExportTreeDialog.Format format, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IOException {
        Object object;
        TreeMap<String, Object> treeMap = null;
        if (bl3) {
            treeMap = new TreeMap<String, Object>();
            this.controlPalette.getSettings(treeMap);
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        if (bl5) {
            object = this.treeViewer.getSelectedSubtree();
            if (object != null) {
                arrayList.add((Tree)object);
            }
        } else {
            arrayList.addAll(this.treeViewer.getTreesAsViewed());
        }
        if (arrayList.size() > 0) {
            switch (format) {
                case NEWICK: {
                    object = new NewickExporter(writer);
                    ((NewickExporter)object).exportTrees(arrayList);
                    break;
                }
                case NEXUS: {
                    FigTreeNexusExporter figTreeNexusExporter = new FigTreeNexusExporter(writer, bl4);
                    figTreeNexusExporter.exportTrees(arrayList);
                    if (treeMap == null) break;
                    figTreeNexusExporter.writeFigTreeBlock(treeMap);
                    break;
                }
                case JSON: {
                    JSONTreeExporter jSONTreeExporter = new JSONTreeExporter(writer, bl4);
                    jSONTreeExporter.exportTrees(arrayList);
                }
            }
        }
        writer.close();
    }

    @Override
    public final void doFind() {
        if (this.findPanel == null) {
            this.findPanel = new FindPanel(this.findAllAction, null);
            this.findPanel.setOpaque(false);
            this.treeViewer.addAnnotationsListener(new AnnotationsListener(){

                @Override
                public void annotationsChanged() {
                    ArrayList<AnnotationDefinition> arrayList = new ArrayList<AnnotationDefinition>(FigTreeFrame.this.treeViewer.getAnnotationDefinitions().values());
                    FigTreeFrame.this.findPanel.setup(arrayList);
                }
            });
            ArrayList<AnnotationDefinition> arrayList = new ArrayList<AnnotationDefinition>(this.treeViewer.getAnnotationDefinitions().values());
            this.findPanel.setup(arrayList);
        }
        if (this.figTreePanel.getUtilityPanel() != this.findPanel) {
            this.figTreePanel.showUtilityPanel(this.findPanel);
        } else {
            this.figTreePanel.hideUtilityPanel();
        }
    }

    public final void doFindAll() {
        FindPanel.Target target = this.findPanel.getSearchTarget();
        String string = this.findPanel.getSearchTargetString();
        if (this.findPanel.isNumericSearchType()) {
            TreeViewer.NumberSearchType numberSearchType = this.findPanel.getNumberSearchType();
            Number number = this.findPanel.getSearchValue();
            if (target == FindPanel.Target.TAXON_LABEL) {
                throw new IllegalArgumentException("Can't do numeric search on taxon labels");
            }
            if (target == FindPanel.Target.BRANCH_LENGTH) {
                this.treeViewer.selectNodes("!length", numberSearchType, number);
            } else if (target == FindPanel.Target.NODE_AGE) {
                this.treeViewer.selectNodes("!height", numberSearchType, number);
            } else {
                if (target == FindPanel.Target.ANY_ANNOTATION) {
                    throw new IllegalArgumentException("Can't do numeric search on all annotations");
                }
                this.treeViewer.selectNodes(string, numberSearchType, number);
            }
        } else {
            TreeViewer.TextSearchType textSearchType = this.findPanel.getTextSearchType();
            String string2 = this.findPanel.getSearchText();
            boolean bl = this.findPanel.isCaseSensitive();
            if (target == FindPanel.Target.TAXON_LABEL) {
                this.treeViewer.selectTaxa("!name", textSearchType, string2, bl);
            } else {
                if (target == FindPanel.Target.BRANCH_LENGTH) {
                    throw new IllegalArgumentException("Can't do text search on branch lengths");
                }
                if (target == FindPanel.Target.NODE_AGE) {
                    throw new IllegalArgumentException("Can't do text search on node ages");
                }
                if (target == FindPanel.Target.ANY_ANNOTATION) {
                    this.treeViewer.selectNodes(null, textSearchType, string2, bl);
                } else {
                    this.treeViewer.selectNodes(string, textSearchType, string2, bl);
                }
            }
        }
    }

    public final void doFindNext() {
    }

    public final void doGetInfo() {
    }

    @Override
    public JComponent getExportableComponent() {
        return this.treeViewer.getContentPane();
    }

    @Override
    public Action getImportColourSchemeAction() {
        return this.importColourSchemeAction;
    }

    @Override
    public Action getExportColourSchemeAction() {
        return this.exportColourSchemeAction;
    }

    @Override
    public Action getExportTreesAction() {
        return this.exportTreesAction;
    }

    @Override
    public Action getExportPDFAction() {
        return this.exportPDFAction;
    }

    @Override
    public Action getExportPNGGraphicAction() {
        return this.exportPNGGraphicAction;
    }

    @Override
    public Action getExportJPEGGraphicAction() {
        return this.exportJPEGGraphicAction;
    }

    @Override
    public Action getExportSVGGraphicAction() {
        return this.exportSVGAction;
    }

    @Override
    public Action getNextTreeAction() {
        return this.nextTreeAction;
    }

    @Override
    public Action getPreviousTreeAction() {
        return this.previousTreeAction;
    }

    @Override
    public Action getCartoonAction() {
        return this.cartoonAction;
    }

    @Override
    public Action getCollapseAction() {
        return this.collapseAction;
    }

    @Override
    public Action getClearCollapsedAction() {
        return this.clearCollapsedAction;
    }

    @Override
    public Action getMidpointRootAction() {
        return this.midpointRootAction;
    }

    @Override
    public Action getRerootAction() {
        return this.rerootAction;
    }

    @Override
    public Action getClearRootingAction() {
        return this.clearRootingAction;
    }

    @Override
    public Action getIncreasingNodeOrderAction() {
        return this.increasingNodeOrderAction;
    }

    @Override
    public Action getDecreasingNodeOrderAction() {
        return this.decreasingNodeOrderAction;
    }

    @Override
    public Action getRotateAction() {
        return this.rotateAction;
    }

    @Override
    public Action getClearRotationsAction() {
        return this.clearRotationsAction;
    }

    @Override
    public Action getAnnotateAction() {
        return this.annotateAction;
    }

    @Override
    public Action getCopyAnnotationsAction() {
        return this.copyAnnotationsAction;
    }

    @Override
    public Action getAnnotateNodesFromTipsAction() {
        return this.annotateNodesFromTipsAction;
    }

    @Override
    public Action getAnnotateTipsFromNodesAction() {
        return this.annotateTipsFromNodesAction;
    }

    @Override
    public AbstractAction getClearAnnotationsAction() {
        return this.clearAnnotationsAction;
    }

    @Override
    public AbstractAction getDefineAnnotationsAction() {
        return this.defineAnnotationsAction;
    }

    @Override
    public Action getColourAction() {
        return this.colourAction;
    }

    @Override
    public Action getClearColouringAction() {
        return this.clearColouringAction;
    }

    @Override
    public Action getHilightAction() {
        return this.hilightAction;
    }

    @Override
    public Action getClearHilightingAction() {
        return this.clearHilightingAction;
    }

    @Override
    public Action getFindAction() {
        return this.findAction;
    }
}

