/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.CMapAwareDocumentFont;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.Vector;

public class TextRenderInfo {
    private final String text;
    private final Matrix textToUserSpaceTransformMatrix;
    private final GraphicsState gs;

    TextRenderInfo(String string, GraphicsState graphicsState, Matrix matrix) {
        this.text = string;
        this.textToUserSpaceTransformMatrix = matrix.multiply(graphicsState.ctm);
        this.gs = graphicsState;
    }

    public String getText() {
        return this.text;
    }

    public float getUnscaledWidth() {
        return this.getStringWidth(this.text);
    }

    public Vector getStartPoint() {
        return new Vector(0.0f, 0.0f, 1.0f).cross(this.textToUserSpaceTransformMatrix);
    }

    public Vector getEndPoint() {
        return new Vector(this.getUnscaledWidth(), 0.0f, 1.0f).cross(this.textToUserSpaceTransformMatrix);
    }

    public float getSingleSpaceWidth() {
        return new Vector(this.getUnscaledFontSpaceWidth(), 0.0f, 1.0f).cross(this.textToUserSpaceTransformMatrix).subtract(this.getStartPoint()).length();
    }

    private float getUnscaledFontSpaceWidth() {
        char c = ' ';
        if (this.gs.font.getWidth(c) == 0) {
            c = '\u00a0';
        }
        return this.getStringWidth(String.valueOf(c));
    }

    private float getStringWidth(String string) {
        CMapAwareDocumentFont cMapAwareDocumentFont = this.gs.font;
        char[] cArray = string.toCharArray();
        float f = 0.0f;
        for (int i = 0; i < cArray.length; ++i) {
            float f2 = (float)((DocumentFont)cMapAwareDocumentFont).getWidth(cArray[i]) / 1000.0f;
            float f3 = cArray[i] == ' ' ? this.gs.wordSpacing : 0.0f;
            f += (f2 * this.gs.fontSize + this.gs.characterSpacing + f3) * this.gs.horizontalScaling;
        }
        return f;
    }
}

