/*
 * Decompiled with CFR 0.152.
 */
package jam.toolbar;

import jam.toolbar.ToolbarAction;
import jam.toolbar.ToolbarItem;
import jam.toolbar.ToolbarOptions;
import javax.swing.Action;
import javax.swing.JButton;

public class ToolbarToggleButton
extends JButton
implements ToolbarItem {
    private ToolbarAction action;
    private boolean doubleClickToToggle;

    public ToolbarToggleButton(ToolbarAction toolbarAction, boolean bl) {
        super(toolbarAction);
        this.doubleClickToToggle = bl;
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.putClientProperty("Quaqua.Button.style", "toolBarTab");
        this.putClientProperty("JButton.buttonType", "toolbar");
        this.setBorderPainted(true);
        this.setToolTipText(toolbarAction.getToolTipText());
        this.setDisabledIcon(toolbarAction.getDisabledIcon());
        this.setPressedIcon(toolbarAction.getPressedIcon());
        this.setSelectedIcon(toolbarAction.getPressedIcon());
    }

    public void setToolbarOptions(ToolbarOptions toolbarOptions) {
        switch (toolbarOptions.getDisplay()) {
            case 0: {
                this.setText(this.action.getLabel());
                this.setIcon(this.action.getIcon());
                this.setDisabledIcon(this.action.getDisabledIcon());
                this.setPressedIcon(this.action.getPressedIcon());
                break;
            }
            case 1: {
                this.setText(null);
                this.setIcon(this.action.getIcon());
                this.setDisabledIcon(this.action.getDisabledIcon());
                this.setPressedIcon(this.action.getPressedIcon());
                break;
            }
            case 2: {
                this.setText(this.action.getLabel());
                this.setIcon(null);
                this.setDisabledIcon(null);
                this.setPressedIcon(null);
            }
        }
    }

    public void doClick() {
        super.doClick();
    }

    public void doClick(int n) {
        super.doClick(n);
    }

    public void setAction(Action action) {
        super.setAction(action);
        if (action instanceof ToolbarAction) {
            this.action = (ToolbarAction)action;
        }
    }
}

