/*
 * Decompiled with CFR 0.152.
 */
package jam.mac;

import jam.framework.Application;
import java.lang.reflect.Method;

public class Utils {
    protected static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    protected static String MAC_OS_X_VERSION = MAC_OS_X ? System.getProperty("os.version") : null;

    public static boolean isMacOSX() {
        return MAC_OS_X;
    }

    public static String getMacOSXVersion() {
        return MAC_OS_X_VERSION;
    }

    public static int getMacOSXMajorVersionNumber() {
        String[] stringArray = Utils.getMacOSXVersion().split("\\.");
        if (stringArray.length >= 2 && stringArray[0].equals("10")) {
            return Integer.parseInt(stringArray[1]);
        }
        return -1;
    }

    public static void macOSXRegistration(Application application) {
        if (MAC_OS_X) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("jam.maconly.NewOSXAdapter");
            }
            catch (Exception exception) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.");
            }
            try {
                Class[] classArray;
                Method method;
                if (clazz != null && (method = clazz.getDeclaredMethod("registerMacOSXApplication", classArray = new Class[]{Application.class})) != null) {
                    Object[] objectArray = new Object[]{application};
                    method.invoke(clazz, objectArray);
                }
            }
            catch (Exception exception) {
                System.err.println("Exception while loading the OSXAdapter:");
                exception.printStackTrace();
            }
        }
    }
}

