/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.AboutBox;
import jam.framework.DocumentFrame;
import jam.framework.MenuBarFactory;
import jam.framework.MenuFactory;
import jam.html.HTMLViewer;
import jam.preferences.PreferencesDialog;
import jam.preferences.PreferencesSection;
import jam.util.BrowserLauncher;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;

public abstract class Application {
    private static MenuBarFactory menuBarFactory;
    private static Icon icon;
    private static String nameString;
    private static String titleString;
    private static String aboutString;
    private static String websiteURLString;
    private static String helpURLString;
    private static Application application;
    private JMenu recentFileMenu = null;
    private PreferencesDialog preferencesDialog = null;
    private static final int MAX_RECENT_FILES = 20;
    protected AbstractAction newAction = new AbstractAction("New"){

        public void actionPerformed(ActionEvent actionEvent) {
            Application.this.doNew();
        }
    };
    protected AbstractAction openAction = new AbstractAction("Open..."){

        public void actionPerformed(ActionEvent actionEvent) {
            Application.this.doOpen();
        }
    };
    protected AbstractAction pageSetupAction = new AbstractAction("Page Setup..."){

        public void actionPerformed(ActionEvent actionEvent) {
            Application.this.doPageSetup();
        }
    };
    protected AbstractAction exitAction = new AbstractAction("Exit"){

        public void actionPerformed(ActionEvent actionEvent) {
            Application.this.doQuit();
        }
    };
    protected AbstractAction aboutAction = null;
    protected AbstractAction preferencesAction = new AbstractAction("Preferences..."){

        public void actionPerformed(ActionEvent actionEvent) {
            Application.this.doPreferences();
        }
    };
    protected AbstractAction helpAction = new AbstractAction("Help..."){

        public void actionPerformed(ActionEvent actionEvent) {
            Application.this.doHelp();
        }
    };
    protected final AbstractAction websiteAction;

    public static Application getApplication() {
        return application;
    }

    public static MenuBarFactory getMenuBarFactory() {
        return menuBarFactory;
    }

    public static Icon getIcon() {
        return icon;
    }

    public static String getNameString() {
        return nameString;
    }

    public static String getTitleString() {
        return titleString;
    }

    public static String getAboutString() {
        return aboutString;
    }

    public static String getWebsiteURLString() {
        return websiteURLString;
    }

    public static String getHelpURLString() {
        return helpURLString;
    }

    public Application(MenuBarFactory menuBarFactory, String string, String string2, Icon icon) {
        this(menuBarFactory, string, string, string2, icon, null, null);
    }

    public Application(MenuBarFactory menuBarFactory, String string, String string2, String string3, Icon icon) {
        this(menuBarFactory, string, string2, string3, icon, null, null);
    }

    public Application(MenuBarFactory menuBarFactory, String string, String string2, Icon icon, String string3, String string4) {
        this(menuBarFactory, string, string, string2, icon, string3, string4);
    }

    public Application(MenuBarFactory menuBarFactory, String string, String string2, String string3, Icon icon, String string4, String string5) {
        Application.menuBarFactory = menuBarFactory;
        nameString = string;
        titleString = string2;
        aboutString = string3;
        websiteURLString = string4;
        helpURLString = string5;
        Application.icon = icon;
        this.aboutAction = new AbstractAction("About " + string + "..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.doAbout();
            }
        };
        this.websiteAction = string4 != null ? new AbstractAction(nameString + " website..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.doWebsite();
            }
        } : null;
        if (application != null) {
            throw new RuntimeException("Only on instance of Application is allowed");
        }
        application = this;
        this.preferencesDialog = new PreferencesDialog(this.getDefaultFrame());
    }

    public abstract void initialize();

    public void addMenuFactory(MenuFactory menuFactory) {
        Application.getMenuBarFactory().registerMenuFactory(menuFactory);
    }

    public JMenu getRecentFileMenu() {
        if (this.recentFileMenu == null) {
            this.recentFileMenu = new JMenu("Recent Files");
        }
        this.recentFileMenu.setEnabled(this.getOpenAction().isEnabled());
        return this.recentFileMenu;
    }

    public void addRecentFile(File file) {
        if (this.recentFileMenu != null) {
            if (this.recentFileMenu.getItemCount() == 20) {
                this.recentFileMenu.remove(19);
            }
            this.recentFileMenu.insert(new RecentFileAction(file), 0);
        }
    }

    protected abstract JFrame getDefaultFrame();

    public void doAbout() {
        AboutBox aboutBox = new AboutBox(Application.getTitleString(), Application.getAboutString(), Application.getIcon());
        aboutBox.setVisible(true);
    }

    public void doHelp() {
        if (helpURLString != null) {
            this.displayURL(helpURLString);
        } else {
            try {
                int n;
                InputStream inputStream = this.getClass().getResourceAsStream("/help/application.help");
                if (inputStream == null) {
                    return;
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                StringWriter stringWriter = new StringWriter();
                while ((n = ((Reader)inputStreamReader).read()) != -1) {
                    stringWriter.write(n);
                }
                ((Reader)inputStreamReader).close();
                stringWriter.close();
                HTMLViewer hTMLViewer = new HTMLViewer(Application.getNameString() + " Help", stringWriter.toString());
                hTMLViewer.setVisible(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doWebsite() {
        if (websiteURLString != null) {
            this.displayURL(websiteURLString);
        }
    }

    public void displayURL(String string) {
        try {
            BrowserLauncher.openURL(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doPageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.pageDialog(new PageFormat());
    }

    public DocumentFrame doOpen() {
        JFrame jFrame = this.getDefaultFrame();
        if (jFrame == null) {
            jFrame = new JFrame();
        }
        FileDialog fileDialog = new FileDialog((Frame)jFrame, "Open Document", 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
            DocumentFrame documentFrame = this.doOpenFile(file);
            this.addRecentFile(file);
            return documentFrame;
        }
        return null;
    }

    public DocumentFrame doOpen(String string) {
        if (string != null && string.length() > 0) {
            File file = new File(string);
            DocumentFrame documentFrame = this.doOpenFile(file);
            this.addRecentFile(file);
            return documentFrame;
        }
        return null;
    }

    public abstract DocumentFrame doNew();

    public abstract DocumentFrame doOpenFile(File var1);

    public abstract void doQuit();

    public void doPreferences() {
        this.preferencesDialog.showDialog();
    }

    public void addPreferencesSection(PreferencesSection preferencesSection) {
        this.preferencesDialog.addSection(preferencesSection);
    }

    public Action getNewAction() {
        return this.newAction;
    }

    public Action getOpenAction() {
        return this.openAction;
    }

    public Action getPageSetupAction() {
        return this.pageSetupAction;
    }

    public Action getExitAction() {
        return this.exitAction;
    }

    public Action getAboutAction() {
        return this.aboutAction;
    }

    public Action getPreferencesAction() {
        return this.preferencesAction;
    }

    public Action getHelpAction() {
        return this.helpAction;
    }

    public Action getWebsiteAction() {
        return this.websiteAction;
    }

    static {
        application = null;
    }

    private class RecentFileAction
    extends AbstractAction {
        private final File recentFile;

        public RecentFileAction(File file) {
            super(file.getName());
            this.recentFile = file;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Application.this.doOpenFile(this.recentFile);
        }
    }
}

