/*
 * Decompiled with CFR 0.152.
 */
package jam.controlpalettes;

import jam.controlpalettes.ControlPalette;
import jam.controlpalettes.ControlPaletteListener;
import jam.controlpalettes.Controller;
import jam.controlpalettes.ControllerListener;
import jam.controlpalettes.PinnedButton;
import jam.disclosure.DisclosureListener;
import jam.disclosure.DisclosurePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicControlPalette
extends JPanel
implements ControlPalette {
    public static final int DEFAULT_OPENING_SPEED = 100;
    private ControllerListener controllerListener = new ControllerListener(){

        public void controlsChanged() {
            BasicControlPalette.this.layoutControls();
        }
    };
    private final List<ControlPaletteListener> listeners = new ArrayList<ControlPaletteListener>();
    private int preferredWidth;
    private int preferredTitleHeight = 22;
    private DisplayMode displayMode;
    private final int openingSpeed;
    private int currentlyOpen = 0;
    private List<Controller> controllers = new ArrayList<Controller>();
    private List<DisclosurePanel> disclosurePanels = new ArrayList<DisclosurePanel>();
    private List<ControlsState> controlsStates = new ArrayList<ControlsState>();

    public BasicControlPalette(int n) {
        this(n, DisplayMode.ONLY_ONE_OPEN, 100);
    }

    public BasicControlPalette(int n, DisplayMode displayMode) {
        this(n, displayMode, 100);
    }

    public BasicControlPalette(int n, DisplayMode displayMode, int n2) {
        this.preferredWidth = n;
        this.displayMode = displayMode;
        this.openingSpeed = n2;
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, super.getPreferredSize().height);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.preferredWidth, super.getMaximumSize().height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.preferredWidth, super.getMaximumSize().height);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addController(Controller controller) {
        this.controllers.add(controller);
        controller.addControllerListener(this.controllerListener);
        this.setupControls();
    }

    public void addController(int n, Controller controller) {
        this.controllers.add(n, controller);
        controller.addControllerListener(this.controllerListener);
        this.setupControls();
    }

    public void removeController(Controller controller) {
        controller.removeControllerListener(this.controllerListener);
        this.controllers.remove(controller);
        this.setupControls();
    }

    public int getControllerCount() {
        return this.controllers.size();
    }

    @Override
    public void fireControlsChanged() {
        for (ControlPaletteListener controlPaletteListener : this.listeners) {
            controlPaletteListener.controlsChanged();
        }
    }

    @Override
    public void addControlPaletteListener(ControlPaletteListener controlPaletteListener) {
        this.listeners.add(controlPaletteListener);
    }

    @Override
    public void removeControlPaletteListener(ControlPaletteListener controlPaletteListener) {
        this.listeners.remove(controlPaletteListener);
    }

    private void setupControls() {
        this.removeAll();
        this.disclosurePanels.clear();
        this.controlsStates.clear();
        int n = 0;
        for (Controller controller : this.controllers) {
            this.setupController(n, controller);
            ++n;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.add((Component)new JSeparator(), gridBagConstraints);
    }

    public void layoutControls() {
        for (DisclosurePanel disclosurePanel : this.disclosurePanels) {
            disclosurePanel.invalidate();
        }
        this.validate();
        this.revalidate();
    }

    @Override
    public void initialize() {
        for (Controller controller : this.controllers) {
            controller.initialize();
        }
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        for (Controller controller : this.controllers) {
            controller.getSettings(map);
        }
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        for (Controller controller : this.controllers) {
            controller.setSettings(map);
        }
    }

    @Override
    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
        this.invalidate();
    }

    private void setupController(int n, Controller controller) {
        if (controller.getTitleComponent() != null) {
            JPanel jPanel = new JPanel(new BorderLayout(6, 0));
            jPanel.setOpaque(false);
            JComponent jComponent = controller.getTitleComponent();
            jComponent.setFocusable(false);
            jPanel.add((Component)jComponent, "Center");
            JPanel jPanel2 = controller.getPanel();
            jPanel2.setOpaque(false);
            controller.getTitleComponent().setFont(UIManager.getFont("SmallSystemFont"));
            controller.getTitleComponent().setOpaque(false);
            PinnedButton pinnedButton = new PinnedButton();
            pinnedButton.setSelected(controller.isInitiallyVisible());
            jPanel.add((Component)pinnedButton, "East");
            DisclosurePanel disclosurePanel = new DisclosurePanel(jPanel, this.preferredTitleHeight, jPanel2, controller.isInitiallyVisible(), this.openingSpeed);
            if (this.displayMode == DisplayMode.ONLY_ONE_OPEN) {
                disclosurePanel.addDisclosureListener(new DisclosureListener(){

                    public void opening(Component component) {
                    }

                    public void opened(Component component) {
                        int n = BasicControlPalette.this.disclosurePanels.indexOf(component);
                        ControlsState controlsState = (ControlsState)BasicControlPalette.this.controlsStates.get(n);
                        if (BasicControlPalette.this.currentlyOpen >= 0) {
                            DisclosurePanel disclosurePanel = (DisclosurePanel)BasicControlPalette.this.disclosurePanels.get(BasicControlPalette.this.currentlyOpen);
                            ControlsState controlsState2 = (ControlsState)BasicControlPalette.this.controlsStates.get(BasicControlPalette.this.currentlyOpen);
                            if (!controlsState2.isPinned()) {
                                disclosurePanel.setOpen(false);
                                controlsState2.setVisible(false);
                            }
                        }
                        BasicControlPalette.this.currentlyOpen = n;
                        controlsState.setVisible(true);
                        BasicControlPalette.this.invalidate();
                        BasicControlPalette.this.revalidate();
                        BasicControlPalette.this.invalidate();
                    }

                    public void closing(Component component) {
                    }

                    public void closed(Component component) {
                        int n = BasicControlPalette.this.disclosurePanels.indexOf(component);
                        ControlsState controlsState = (ControlsState)BasicControlPalette.this.controlsStates.get(n);
                        controlsState.setVisible(false);
                        if (n == BasicControlPalette.this.currentlyOpen) {
                            BasicControlPalette.this.currentlyOpen = -1;
                        }
                        BasicControlPalette.this.invalidate();
                        BasicControlPalette.this.revalidate();
                        BasicControlPalette.this.invalidate();
                    }
                });
            }
            final ControlsState controlsState = new ControlsState(controller.isInitiallyVisible(), pinnedButton.isSelected());
            pinnedButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    controlsState.setPinned(itemEvent.getStateChange() == 1);
                }
            });
            this.disclosurePanels.add(disclosurePanel);
            this.controlsStates.add(controlsState);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 23;
            this.add((Component)disclosurePanel, gridBagConstraints);
        }
    }

    private class ControlsState {
        private boolean isVisible;
        private boolean isPinned;

        ControlsState(boolean bl, boolean bl2) {
            this.isVisible = bl;
            this.isPinned = bl2;
        }

        boolean isVisible() {
            return this.isVisible;
        }

        void setVisible(boolean bl) {
            this.isVisible = bl;
        }

        boolean isPinned() {
            return this.isPinned;
        }

        void setPinned(boolean bl) {
            this.isPinned = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        DEFAULT_OPEN,
        INITIALLY_OPEN,
        INITIALLY_CLOSED,
        ONLY_ONE_OPEN;

    }
}

