/*
 * Decompiled with CFR 0.152.
 */
package jam.console;

import jam.console.ConsoleApplication;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ConsoleFrame
extends DocumentFrame {
    PipedInputStream piOut;
    PipedInputStream piErr;
    PipedOutputStream poOut;
    PipedOutputStream poErr;
    JTextArea textArea = new JTextArea();

    public ConsoleFrame() throws IOException {
        this.piOut = new PipedInputStream();
        this.poOut = new PipedOutputStream(this.piOut);
        System.setOut(new PrintStream(this.poOut, true));
        this.piErr = new PipedInputStream();
        this.poErr = new PipedOutputStream(this.piErr);
        System.setErr(new PrintStream(this.poErr, true));
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 67 && keyEvent.isControlDown() || keyEvent.getKeyCode() == 46 && keyEvent.isMetaDown()) {
                    ConsoleFrame.this.escapePressed();
                }
            }
        });
    }

    protected void initializeComponents() {
        this.textArea.setEditable(false);
        this.textArea.setRows(25);
        this.textArea.setColumns(80);
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.pack();
        this.setVisible(true);
        new ReaderThread(this.piOut).start();
        new ReaderThread(this.piErr).start();
        this.getCutAction().setEnabled(false);
        this.getPasteAction().setEnabled(false);
        this.getDeleteAction().setEnabled(false);
        this.getFindAction().setEnabled(false);
    }

    protected boolean readFromFile(File file) throws FileNotFoundException, IOException {
        throw new RuntimeException("Cannot read file");
    }

    protected boolean writeToFile(File file) throws IOException {
        this.textArea.write(new FileWriter(file));
        return true;
    }

    public JComponent getExportableComponent() {
        return this.textArea;
    }

    protected void escapePressed() {
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you wish to stop?", "Stop", 2, 2);
        if (n == 0) {
            ((ConsoleApplication)Application.getApplication()).doStop();
        }
    }

    public void doCopy() {
        this.textArea.copy();
    }

    public void doSelectAll() {
        this.textArea.selectAll();
    }

    class ReaderThread
    extends Thread {
        PipedInputStream pi;

        ReaderThread(PipedInputStream pipedInputStream) {
            this.pi = pipedInputStream;
        }

        public void run() {
            try {
                while (true) {
                    int n;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    String string = "";
                    while ((n = this.pi.available()) != 0) {
                        byte[] byArray = new byte[n];
                        this.pi.read(byArray);
                        if (!(string = string + new String(byArray)).endsWith("\n") && !string.endsWith("\r\n")) continue;
                    }
                    if (string.length() <= 0) continue;
                    SwingUtilities.invokeLater(new WriteText(string));
                }
            }
            catch (IOException iOException) {
                return;
            }
        }

        class WriteText
        implements Runnable {
            String text;

            WriteText(String string) {
                this.text = string;
            }

            public void run() {
                ConsoleFrame.this.textArea.append(this.text);
                ConsoleFrame.this.textArea.setCaretPosition(ConsoleFrame.this.textArea.getDocument().getLength());
                int n = 128000;
                int n2 = 16000;
                int n3 = ConsoleFrame.this.textArea.getDocument().getLength() - n;
                if (n3 >= n2) {
                    ConsoleFrame.this.textArea.replaceRange("", 0, n3);
                }
                ConsoleFrame.this.setDirty();
            }
        }
    }
}

