/*
 * Decompiled with CFR 0.152.
 */
package figtree.webui;

import eu.webtoolkit.jwt.KeyboardModifier;
import eu.webtoolkit.jwt.Signal1;
import eu.webtoolkit.jwt.WLength;
import eu.webtoolkit.jwt.WMouseEvent;
import eu.webtoolkit.jwt.WObject;
import eu.webtoolkit.jwt.WPaintDevice;
import eu.webtoolkit.jwt.WPaintedWidget;
import eu.webtoolkit.jwt.WPainter;
import eu.webtoolkit.jwt.utils.WebGraphics2D;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.TreePaneSelector;
import figtree.treeviewer.treelayouts.RectilinearTreeLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class TreeWidget
extends WPaintedWidget {
    private TreePane treePane;
    private WebGraphics2D graphics = new WebGraphics2D(new WPainter());

    public TreeWidget() {
        this.treePane = new TreePane(){
            private static final long serialVersionUID = 1L;

            @Override
            public void repaint() {
                TreeWidget.this.update();
            }

            @Override
            public Graphics getGraphics() {
                return TreeWidget.this.graphics;
            }
        };
        this.treePane.setTreeLayout(new RectilinearTreeLayout());
        this.treePane.setSelectionColor(new Color(90, 108, 128));
        final TreePaneSelector treePaneSelector = new TreePaneSelector(this.treePane);
        this.clicked().addListener((WObject)this, (Signal1.Listener)new Signal1.Listener<WMouseEvent>(){

            public void trigger(WMouseEvent wMouseEvent) {
                int n = wMouseEvent.getDragDelta().x;
                int n2 = wMouseEvent.getDragDelta().y;
                if (n * n + n2 * n2 < 4) {
                    treePaneSelector.mouseClicked(TreeWidget.this.convertMouseEvent(wMouseEvent, 500));
                }
            }
        });
        this.mouseWentDown().addListener((WObject)this, (Signal1.Listener)new Signal1.Listener<WMouseEvent>(){

            public void trigger(WMouseEvent wMouseEvent) {
                treePaneSelector.mousePressed(TreeWidget.this.convertMouseEvent(wMouseEvent, 501));
            }
        });
        this.mouseWentUp().addListener((WObject)this, (Signal1.Listener)new Signal1.Listener<WMouseEvent>(){

            public void trigger(WMouseEvent wMouseEvent) {
                treePaneSelector.mouseReleased(TreeWidget.this.convertMouseEvent(wMouseEvent, 502));
            }
        });
        this.mouseDragged().addListener((WObject)this, (Signal1.Listener)new Signal1.Listener<WMouseEvent>(){

            public void trigger(WMouseEvent wMouseEvent) {
                treePaneSelector.mouseDragged(TreeWidget.this.convertMouseEvent(wMouseEvent, 506));
            }
        });
    }

    MouseEvent convertMouseEvent(WMouseEvent wMouseEvent, int n) {
        int n2 = 0;
        if (wMouseEvent.getModifiers().contains(KeyboardModifier.AltModifier)) {
            n2 |= 0x200;
        }
        if (wMouseEvent.getModifiers().contains(KeyboardModifier.ShiftModifier)) {
            n2 |= 0x40;
        }
        if (wMouseEvent.getModifiers().contains(KeyboardModifier.ControlModifier)) {
            n2 |= 0x80;
        }
        if (wMouseEvent.getModifiers().contains(KeyboardModifier.MetaModifier)) {
            n2 |= 0x100;
        }
        int n3 = 0;
        if (wMouseEvent.getButton() == WMouseEvent.Button.LeftButton) {
            n2 |= 0x400;
            n3 = 1;
        } else if (wMouseEvent.getButton() == WMouseEvent.Button.MiddleButton) {
            n2 |= 0x800;
            n3 = 2;
        } else if (wMouseEvent.getButton() == WMouseEvent.Button.RightButton) {
            n2 |= 0x1000;
            n3 = 3;
        }
        return new MouseEvent(this.treePane, n, System.currentTimeMillis(), n2, wMouseEvent.getWidget().x, wMouseEvent.getWidget().y, 1, wMouseEvent.getButton() == WMouseEvent.Button.RightButton, n3);
    }

    public void resize(WLength wLength, WLength wLength2) {
        super.resize(wLength, wLength2);
        this.treePane.setSize((int)wLength.toPixels(), (int)wLength2.toPixels());
    }

    protected void layoutSizeChanged(int n, int n2) {
        super.layoutSizeChanged(n, n2);
        this.treePane.setSize(n, n2);
    }

    protected void paintEvent(WPaintDevice wPaintDevice) {
        WPainter wPainter = new WPainter(wPaintDevice);
        WebGraphics2D webGraphics2D = new WebGraphics2D(wPainter);
        this.treePane.paint((Graphics)webGraphics2D);
    }

    public TreePane getTreePane() {
        return this.treePane;
    }
}

