/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.ScaleAxis;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.Painter;
import figtree.treeviewer.painters.ScalePainter;
import figtree.treeviewer.treelayouts.RadialTreeLayout;
import jam.controlpalettes.ControlPalette;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Set;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

public class ScaleGridPainter
extends LabelPainter<TreePane>
implements ScalePainter {
    private BasicStroke majorStroke = new BasicStroke(0.5f, 0, 2);
    private BasicStroke minorStroke = new BasicStroke(0.25f, 0, 2);
    private double preferredHeight;
    private double preferredWidth;
    protected TreePane treePane;

    public ScaleGridPainter() {
        super(null);
    }

    @Override
    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, TreePane treePane) {
        this.preferredWidth = treePane.getTreeBounds().getWidth();
        this.preferredHeight = treePane.getTreeBounds().getHeight();
        return new Rectangle2D.Double(0.0, 0.0, this.preferredWidth, this.preferredHeight);
    }

    @Override
    public void paint(Graphics2D graphics2D, TreePane treePane, Painter.Justification justification, Rectangle2D rectangle2D) {
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        if (treePane.getTreeLayout() instanceof RadialTreeLayout) {
            return;
        }
        if (this.getBackground() != null) {
            graphics2D.setPaint(this.getBackground());
            graphics2D.fill(rectangle2D);
        }
        if (this.getBorderPaint() != null && this.getBorderStroke() != null) {
            graphics2D.setPaint(this.getBorderPaint());
            graphics2D.setStroke(this.getBorderStroke());
            graphics2D.draw(rectangle2D);
        }
        this.paintAxis(graphics2D, rectangle2D);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    protected void paintAxis(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        int n;
        ScaleAxis scaleAxis = this.treePane.getScaleAxis();
        graphics2D.setPaint(this.getForeground());
        int n2 = scaleAxis.getMajorTickCount();
        int n3 = scaleAxis.getMinorTickCount(-1);
        if (scaleAxis.getLabelFirst()) {
            this.paintMajorLine(graphics2D, rectangle2D, scaleAxis, scaleAxis.getMinorTickValue(0, -1));
            for (n = 1; n < n3; ++n) {
                this.paintMinorLine(graphics2D, rectangle2D, scaleAxis.getMinorTickValue(n, -1));
            }
        } else {
            for (n = 0; n < n3; ++n) {
                this.paintMinorLine(graphics2D, rectangle2D, scaleAxis.getMinorTickValue(n, -1));
            }
        }
        for (int i = 0; i < n2; ++i) {
            this.paintMajorLine(graphics2D, rectangle2D, scaleAxis, scaleAxis.getMajorTickValue(i));
            n3 = scaleAxis.getMinorTickCount(i);
            if (i == n2 - 1 && scaleAxis.getLabelLast()) {
                this.paintMajorLine(graphics2D, rectangle2D, scaleAxis, scaleAxis.getMinorTickValue(0, i));
                for (n = 1; n < n3; ++n) {
                    this.paintMinorLine(graphics2D, rectangle2D, scaleAxis.getMinorTickValue(n, i));
                }
                continue;
            }
            for (n = 0; n < n3; ++n) {
                this.paintMinorLine(graphics2D, rectangle2D, scaleAxis.getMinorTickValue(n, i));
            }
        }
    }

    protected void paintMajorLine(Graphics2D graphics2D, Rectangle2D rectangle2D, ScaleAxis scaleAxis, double d) {
        graphics2D.setStroke(this.getMajorStroke());
        Shape shape = this.treePane.getAxisLine(d);
        graphics2D.draw(shape);
    }

    protected void paintMinorLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d) {
        graphics2D.setStroke(this.getMinorStroke());
        Shape shape = this.treePane.getAxisLine(d);
        graphics2D.draw(shape);
    }

    @Override
    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public double getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public double getHeightBound() {
        return this.preferredHeight;
    }

    public BasicStroke getMajorStroke() {
        return this.majorStroke;
    }

    public void setMajorStroke(BasicStroke basicStroke) {
        this.majorStroke = basicStroke;
        this.firePainterChanged();
    }

    public BasicStroke getMinorStroke() {
        return this.minorStroke;
    }

    public void setMinorStroke(BasicStroke basicStroke) {
        this.minorStroke = basicStroke;
        this.firePainterChanged();
    }

    public void setControlPalette(ControlPalette controlPalette) {
    }

    public String[] getAttributes() {
        return new String[0];
    }

    public void setupAttributes(Collection<? extends Tree> collection) {
    }

    @Override
    public String getDisplayAttribute() {
        throw new UnsupportedOperationException("getDisplayAttribute not implmented");
    }

    @Override
    public void setDisplayAttribute(String string) {
        throw new UnsupportedOperationException("setDisplayAttribute not implemented in ScaleGridPainter");
    }

    @Override
    public void setTextDecorator(Decorator decorator) {
    }

    public Set<Attributable> getAttributableItems() {
        return null;
    }
}

