/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.ScaleAxis;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.Painter;
import figtree.treeviewer.painters.ScalePainter;
import figtree.treeviewer.treelayouts.RadialTreeLayout;
import figtree.treeviewer.treelayouts.RectilinearTreeLayout;
import jam.controlpalettes.ControlPalette;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Set;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

public class ScaleAxisPainter
extends LabelPainter<TreePane>
implements ScalePainter {
    private double majorTickSpacing = 1.0;
    private double minorTickSpacing = 0.5;
    private BasicStroke scaleBarStroke = new BasicStroke(1.0f, 0, 2);
    private double topMargin = 4.0;
    private double bottomMargin = 4.0;
    private double majorTickSize = 5.0;
    private double minorTickSize = 2.0;
    private double tickLabelOffset = 4.0;
    private double preferredHeight;
    private double preferredWidth;
    protected TreePane treePane;

    public ScaleAxisPainter() {
        super(null);
    }

    @Override
    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    public void setAutomatic(boolean bl) {
        if (bl) {
            this.treePane.setAutomaticScale();
            this.majorTickSpacing = this.treePane.getMajorTickSpacing();
            this.minorTickSpacing = this.treePane.getMinorTickSpacing();
        } else {
            this.treePane.setTickSpacing(this.majorTickSpacing, this.minorTickSpacing);
        }
    }

    public void setAxisReversed(boolean bl) {
        this.treePane.setAxisReversed(bl);
    }

    public void setAxisSpacing(double d, double d2) {
        this.treePane.setTickSpacing(d, d2);
    }

    public double getAxisOrigin() {
        return 0.0;
    }

    public void setAxisOrigin(double d) {
    }

    public double getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public double getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, TreePane treePane) {
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.getFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = fontMetrics.getHeight();
        this.preferredWidth = treePane.getTreeBounds().getWidth();
        this.preferredHeight = d + this.topMargin + this.bottomMargin + (double)this.scaleBarStroke.getLineWidth() + this.majorTickSize;
        if (!(treePane.getTreeLayout() instanceof RectilinearTreeLayout)) {
            this.preferredHeight = 0.0;
        }
        this.tickLabelOffset = (float)((double)fontMetrics.getAscent() + this.topMargin + this.bottomMargin + this.majorTickSize) + this.scaleBarStroke.getLineWidth();
        graphics2D.setFont(font);
        return new Rectangle2D.Double(0.0, 0.0, this.preferredWidth, this.preferredHeight);
    }

    @Override
    public void paint(Graphics2D graphics2D, TreePane treePane, Painter.Justification justification, Rectangle2D rectangle2D) {
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        if (treePane.getTreeLayout() instanceof RadialTreeLayout) {
            return;
        }
        if (this.getBackground() != null) {
            graphics2D.setPaint(this.getBackground());
            graphics2D.fill(rectangle2D);
        }
        if (this.getBorderPaint() != null && this.getBorderStroke() != null) {
            graphics2D.setPaint(this.getBorderPaint());
            graphics2D.setStroke(this.getBorderStroke());
            graphics2D.draw(rectangle2D);
        }
        graphics2D.setFont(this.getFont());
        graphics2D.setPaint(this.getForeground());
        graphics2D.setStroke(this.getScaleBarStroke());
        this.paintAxis(graphics2D, rectangle2D);
        graphics2D.setFont(font);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    protected double getMaxTickLabelWidth(Graphics2D graphics2D) {
        double d;
        String string;
        double d2 = 0.0;
        ScaleAxis scaleAxis = this.treePane.getScaleAxis();
        if (scaleAxis.getLabelFirst()) {
            string = scaleAxis.getFormatter().format(scaleAxis.getMinorTickValue(0, -1));
            d = graphics2D.getFontMetrics().stringWidth(string);
            if (d2 < d) {
                d2 = d;
            }
        }
        int n = scaleAxis.getMajorTickCount();
        for (int i = 0; i < n; ++i) {
            string = scaleAxis.getFormatter().format(scaleAxis.getMajorTickValue(i));
            d = graphics2D.getFontMetrics().stringWidth(string);
            if (!(d2 < d)) continue;
            d2 = d;
        }
        if (scaleAxis.getLabelLast()) {
            string = scaleAxis.getFormatter().format(scaleAxis.getMinorTickValue(0, n - 1));
            d = graphics2D.getFontMetrics().stringWidth(string);
            if (d2 < d) {
                d2 = d;
            }
        }
        return d2;
    }

    protected void paintAxis(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        int n;
        ScaleAxis scaleAxis = this.treePane.getScaleAxis();
        graphics2D.setPaint(this.getForeground());
        graphics2D.setStroke(this.getScaleBarStroke());
        double d = this.treePane.scaleOnAxis(scaleAxis.getMinAxis());
        double d2 = this.treePane.scaleOnAxis(scaleAxis.getMaxAxis());
        Line2D.Double double_ = new Line2D.Double(d, rectangle2D.getY() + this.topMargin, d2, rectangle2D.getY() + this.topMargin);
        graphics2D.draw(double_);
        int n2 = scaleAxis.getMajorTickCount();
        int n3 = scaleAxis.getMinorTickCount(-1);
        if (scaleAxis.getLabelFirst()) {
            this.paintMajorTick(graphics2D, rectangle2D, scaleAxis, scaleAxis.getMinorTickValue(0, -1));
            for (n = 1; n < n3; ++n) {
                this.paintMinorTick(graphics2D, rectangle2D, scaleAxis.getMinorTickValue(n, -1));
            }
        } else {
            for (n = 0; n < n3; ++n) {
                this.paintMinorTick(graphics2D, rectangle2D, scaleAxis.getMinorTickValue(n, -1));
            }
        }
        for (int i = 0; i < n2; ++i) {
            this.paintMajorTick(graphics2D, rectangle2D, scaleAxis, scaleAxis.getMajorTickValue(i));
            n3 = scaleAxis.getMinorTickCount(i);
            if (i == n2 - 1 && scaleAxis.getLabelLast()) {
                this.paintMajorTick(graphics2D, rectangle2D, scaleAxis, scaleAxis.getMinorTickValue(0, i));
                for (n = 1; n < n3; ++n) {
                    this.paintMinorTick(graphics2D, rectangle2D, scaleAxis.getMinorTickValue(n, i));
                }
                continue;
            }
            for (n = 0; n < n3; ++n) {
                this.paintMinorTick(graphics2D, rectangle2D, scaleAxis.getMinorTickValue(n, i));
            }
        }
    }

    protected void paintMajorTick(Graphics2D graphics2D, Rectangle2D rectangle2D, ScaleAxis scaleAxis, double d) {
        graphics2D.setPaint(this.getForeground());
        graphics2D.setStroke(this.getScaleBarStroke());
        String string = this.getNumberFormat().format(d);
        double d2 = this.treePane.scaleOnAxis(d);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY() + this.topMargin, d2, rectangle2D.getMinY() + this.majorTickSize + this.topMargin);
        graphics2D.draw(double_);
        graphics2D.setPaint(this.getForeground());
        double d3 = graphics2D.getFontMetrics().stringWidth(string);
        graphics2D.drawString(string, (float)(d2 - d3 / 2.0), (float)(rectangle2D.getMinY() + this.tickLabelOffset + this.topMargin));
    }

    protected void paintMinorTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d) {
        graphics2D.setPaint(this.getForeground());
        graphics2D.setStroke(this.getScaleBarStroke());
        double d2 = this.treePane.scaleOnAxis(d);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY() + this.topMargin, d2, rectangle2D.getMinY() + this.minorTickSize + this.topMargin);
        graphics2D.draw(double_);
    }

    @Override
    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public double getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public double getHeightBound() {
        return this.preferredHeight + this.tickLabelOffset;
    }

    public BasicStroke getScaleBarStroke() {
        return this.scaleBarStroke;
    }

    public void setScaleBarStroke(BasicStroke basicStroke) {
        this.scaleBarStroke = basicStroke;
        this.firePainterChanged();
    }

    public void setControlPalette(ControlPalette controlPalette) {
    }

    public String[] getAttributes() {
        return new String[0];
    }

    public void setupAttributes(Collection<? extends Tree> collection) {
    }

    @Override
    public String getDisplayAttribute() {
        throw new UnsupportedOperationException("getDisplayAttribute not implmented");
    }

    @Override
    public void setDisplayAttribute(String string) {
        throw new UnsupportedOperationException("setDisplayAttribute not implemented in ScaleAxisPainter");
    }

    @Override
    public void setTextDecorator(Decorator decorator) {
    }

    public Set<Attributable> getAttributableItems() {
        return null;
    }
}

