/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.TreePane;
import figtree.treeviewer.painters.NodePainter;
import figtree.treeviewer.painters.Painter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.RootedTree;

public class NodeBarPainter
extends NodePainter {
    private String displayAttribute = null;
    private TreePane treePane;
    private Line2D nodeBar = null;
    private double maxHeight;

    @Override
    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    public Line2D getNodeBar() {
        return this.nodeBar;
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, Node node) {
        RootedTree rootedTree = this.treePane.getTree();
        this.nodeBar = null;
        this.maxHeight = 0.0;
        Line2D line2D = this.treePane.getTreeLayoutCache().getNodeShapePath(node);
        if (line2D != null) {
            double d;
            double d2 = d = rootedTree.getHeight(node);
            double d3 = d;
            boolean bl = false;
            Object[] objectArray = (Object[])node.getAttribute(this.displayAttribute);
            if (objectArray != null) {
                Object object = objectArray[0];
                if (object != null) {
                    d3 = object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble(object.toString());
                    bl = true;
                }
                if ((object = objectArray[1]) != null) {
                    d2 = object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble(object.toString());
                    bl = true;
                }
            }
            if (bl) {
                if (d2 > this.maxHeight) {
                    this.maxHeight = d2;
                }
                double d4 = line2D.getX1();
                double d5 = line2D.getY1();
                double d6 = line2D.getX2();
                double d7 = line2D.getY2();
                double d8 = d6 - d4;
                double d9 = d7 - d5;
                double d10 = d3 - d;
                double d11 = d2 - d;
                this.nodeBar = new Line2D.Double(d4 + d8 * d10, d5 + d9 * d10, d4 + d8 * d11, d5 + d9 * d11);
            }
        }
        if (this.nodeBar == null) {
            return null;
        }
        return this.nodeBar.getBounds2D();
    }

    @Override
    public double getPreferredWidth() {
        return 1.0;
    }

    @Override
    public double getPreferredHeight() {
        return 1.0;
    }

    @Override
    public double getHeightBound() {
        return 1.0;
    }

    public void paint(Graphics2D graphics2D, Node node, Painter.Justification justification, Shape shape) {
        if (shape != null) {
            Stroke stroke = this.getStroke();
            Shape shape2 = stroke.createStrokedShape(shape);
            graphics2D.setPaint(this.getForeground());
            graphics2D.fill(shape2);
            graphics2D.setPaint(Color.black);
            graphics2D.setStroke(new BasicStroke(0.5f));
            graphics2D.draw(shape2);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D, Node node, Painter.Justification justification, Rectangle2D rectangle2D) {
        throw new UnsupportedOperationException("This version of paint is not used in NodeBarPainter");
    }

    public String getDisplayAttributeName() {
        return this.displayAttribute;
    }

    public void setDisplayAttribute(String string) {
        this.displayAttribute = string;
        this.firePainterChanged();
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }
}

