/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.painters.AttributeComboHelper;
import figtree.treeviewer.painters.AttributeComboHelperListener;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.NodeBarPainter;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.BasicStroke;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NodeBarController
extends AbstractController {
    private static Preferences PREFS = Preferences.userNodeForPackage(TreeViewer.class);
    private static final String NODE_BARS_KEY = "nodeBars";
    public static final String DISPLAY_ATTRIBUTE_KEY = "displayAttribute";
    private static final String BAR_WIDTH_KEY = "barWidth";
    private static float DEFAULT_BAR_WIDTH = 4.0f;
    private final JCheckBox titleCheckBox;
    private final OptionsPanel optionsPanel;
    private JComboBox displayAttributeCombo;
    private final String title;
    private final NodeBarPainter nodeBarPainter;
    private final JSpinner barWidthSpinner;

    public NodeBarController(String string, final NodeBarPainter nodeBarPainter, TreeViewer treeViewer) {
        this.title = string;
        this.nodeBarPainter = nodeBarPainter;
        float f = PREFS.getFloat(BAR_WIDTH_KEY, DEFAULT_BAR_WIDTH);
        this.optionsPanel = new ControllerOptionsPanel(2, 2);
        this.titleCheckBox = new JCheckBox(this.getTitle());
        this.titleCheckBox.setSelected(this.nodeBarPainter.isVisible());
        this.displayAttributeCombo = new JComboBox();
        new AttributeComboHelper(this.displayAttributeCombo, treeViewer, LabelPainter.PainterIntent.RANGE).addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                String string = (String)NodeBarController.this.displayAttributeCombo.getSelectedItem();
                nodeBarPainter.setDisplayAttribute(string);
            }
        });
        this.barWidthSpinner = new JSpinner(new SpinnerNumberModel(f, 0.01, 48.0, 1.0));
        this.barWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)NodeBarController.this.barWidthSpinner.getValue()).floatValue();
                nodeBarPainter.setStroke(new BasicStroke(f, 0, 2));
            }
        });
        nodeBarPainter.setStroke(new BasicStroke(f, 0, 2));
        JLabel jLabel = this.optionsPanel.addComponentWithLabel("Display:", this.displayAttributeCombo);
        JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Bar Width:", this.barWidthSpinner);
        this.addComponent(jLabel);
        this.addComponent(this.displayAttributeCombo);
        this.addComponent(jLabel2);
        this.addComponent(this.barWidthSpinner);
        this.enableComponents(this.titleCheckBox.isSelected());
        this.titleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NodeBarController.this.enableComponents(NodeBarController.this.titleCheckBox.isSelected());
                nodeBarPainter.setVisible(NodeBarController.this.titleCheckBox.isSelected());
            }
        });
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleCheckBox;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.titleCheckBox.setSelected((Boolean)map.get("nodeBars.isShown"));
        this.displayAttributeCombo.setSelectedItem((String)map.get("nodeBars.displayAttribute"));
        this.barWidthSpinner.setValue((Double)map.get("nodeBars.barWidth"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("nodeBars.isShown", this.titleCheckBox.isSelected());
        map.put("nodeBars.displayAttribute", this.displayAttributeCombo.getSelectedItem());
        map.put("nodeBars.barWidth", this.barWidthSpinner.getValue());
    }

    public String getTitle() {
        return this.title;
    }
}

