/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import figtree.treeviewer.decorators.ColourDecorator;
import java.awt.Color;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.RootedTree;
import jebl.util.Attributable;

public class DiversityContinuousColourDecorator
extends ColourDecorator {
    private RootedTree tree;
    private double hue;
    private float hueUpper = 1.0f;
    private float hueLower = 0.0f;
    private float saturationUpper = 0.6f;
    private float saturationLower = 0.6f;
    private float brightnessUpper = 0.8f;
    private float brightnessLower = 0.4f;
    private boolean reverseHue = false;

    public DiversityContinuousColourDecorator() throws NumberFormatException {
        super(null);
    }

    public DiversityContinuousColourDecorator(String string, String string2) {
        super(string);
        this.setup(string2);
    }

    @Override
    public void setup(String string) {
        if (!string.startsWith("{") || !string.endsWith("}")) {
            throw new IllegalArgumentException("DiversityContinuousColourDecorator settings string not in correct format");
        }
        String[] stringArray = string.substring(1, string.length() - 1).split("}[, ]+");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("DiversityContinuousColourDecorator settings string not in correct format");
        }
        String[] stringArray2 = stringArray[1].split("[, ]+");
        if (stringArray2.length != 7) {
            throw new IllegalArgumentException("DiversityContinuousColourDecorator settings string not in correct format");
        }
        try {
            this.hueLower = Float.parseFloat(stringArray2[0]);
            this.hueUpper = Float.parseFloat(stringArray2[1]);
            this.saturationLower = Float.parseFloat(stringArray2[2]);
            this.saturationUpper = Float.parseFloat(stringArray2[3]);
            this.brightnessLower = Float.parseFloat(stringArray2[4]);
            this.brightnessUpper = Float.parseFloat(stringArray2[5]);
            this.reverseHue = Boolean.parseBoolean(stringArray2[6]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("HSBContinuousColourDecorator settings string not in correct format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("HSBContinuousColourDecorator settings string not in correct format");
        }
    }

    public void setup(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        this.hueUpper = f;
        this.hueLower = f2;
        this.saturationUpper = f3;
        this.saturationLower = f4;
        this.brightnessUpper = f5;
        this.brightnessLower = f6;
        this.reverseHue = bl;
    }

    public void setTree(RootedTree rootedTree) {
        this.tree = rootedTree;
        double[] dArray = new double[]{0.0};
        this.traverseTree(rootedTree, rootedTree.getRootNode(), 0.0, 1.0, dArray);
        for (Node node : rootedTree.getNodes()) {
            double d = (Double)node.getAttribute("@hue");
            node.setAttribute("@hue", d / dArray[0]);
        }
    }

    private double traverseTree(RootedTree rootedTree, Node node, double d, double d2, double[] dArray) {
        double d3;
        if (rootedTree.isExternal(node)) {
            d3 = (d2 + d) / 2.0;
        } else {
            d3 = 0.0;
            double d4 = d2 - d;
            int n = rootedTree.getChildren(node).size();
            double[] dArray2 = new double[n];
            int n2 = 0;
            double d5 = 0.0;
            for (Node node2 : rootedTree.getChildren(node)) {
                double d6 = this.countTips(rootedTree, node2);
                d5 += d6;
                dArray2[n2] = d6;
                ++n2;
            }
            double d7 = d;
            n2 = 0;
            for (Node node3 : rootedTree.getChildren(node)) {
                double d8 = d4 * (dArray2[n2] / d5);
                double d9 = d7 + d8;
                d3 += this.traverseTree(rootedTree, node3, d7, d9, dArray);
                d7 = d9;
                ++n2;
            }
            d3 /= (double)n;
        }
        node.setAttribute("@hue", d3);
        if (d3 > dArray[0]) {
            dArray[0] = d3;
        }
        return d3;
    }

    private double countTips(RootedTree rootedTree, Node node) {
        double d;
        if (rootedTree.isExternal(node)) {
            d = 1.0;
        } else {
            d = 0.0;
            for (Node node2 : rootedTree.getChildren(node)) {
                d += this.countTips(rootedTree, node2);
            }
        }
        return d;
    }

    @Override
    public void setItem(Object object) {
        if (object instanceof Attributable) {
            this.hue = (Double)((Attributable)object).getAttribute("@hue");
            this.paint = this.getColourForValue(object);
        }
    }

    @Override
    protected Color getColourForValue(Object object) {
        return Color.getHSBColor(this.getHue((float)this.hue), this.getSaturation(0.5f), this.getBrightness(0.5f));
    }

    private float getHue(float f) {
        if (this.reverseHue) {
            return this.hueUpper - (this.hueUpper - this.hueLower) * f;
        }
        return (this.hueUpper - this.hueLower) * f + this.hueLower;
    }

    private float getSaturation(float f) {
        return (this.saturationUpper - this.saturationLower) * f + this.saturationLower;
    }

    private float getBrightness(float f) {
        return (this.brightnessUpper - this.brightnessLower) * f + this.brightnessLower;
    }

    public float getHueUpper() {
        return this.hueUpper;
    }

    public void setHueUpper(float f) {
        this.hueUpper = f;
    }

    public float getHueLower() {
        return this.hueLower;
    }

    public void setHueLower(float f) {
        this.hueLower = f;
    }

    public float getSaturationUpper() {
        return this.saturationUpper;
    }

    public void setSaturationUpper(float f) {
        this.saturationUpper = f;
    }

    public float getSaturationLower() {
        return this.saturationLower;
    }

    public void setSaturationLower(float f) {
        this.saturationLower = f;
    }

    public float getBrightnessUpper() {
        return this.brightnessUpper;
    }

    public void setBrightnessUpper(float f) {
        this.brightnessUpper = f;
    }

    public float getBrightnessLower() {
        return this.brightnessLower;
    }

    public void setBrightnessLower(float f) {
        this.brightnessLower = f;
    }

    public boolean isReverseHue() {
        return this.reverseHue;
    }

    public void setReverseHue(boolean bl) {
        this.reverseHue = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(this.hueLower);
        stringBuilder.append(",");
        stringBuilder.append(this.hueUpper);
        stringBuilder.append(",");
        stringBuilder.append(this.saturationLower);
        stringBuilder.append(",");
        stringBuilder.append(this.saturationUpper);
        stringBuilder.append(",");
        stringBuilder.append(this.brightnessLower);
        stringBuilder.append(",");
        stringBuilder.append(this.brightnessUpper);
        stringBuilder.append(",");
        stringBuilder.append(this.reverseHue);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

