/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.AttributeColourController;
import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.decorators.AttributableDecorator;
import figtree.treeviewer.decorators.CompoundDecorator;
import figtree.treeviewer.decorators.ContinuousScale;
import figtree.treeviewer.decorators.ContinuousStrokeDecorator;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.AttributeComboHelper;
import figtree.treeviewer.painters.AttributeComboHelperListener;
import jam.controlpalettes.AbstractController;
import jam.controlpalettes.ControllerListener;
import jam.panels.OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TreeAppearanceController
extends AbstractController {
    private static final String CONTROLLER_TITLE = "Appearance";
    public static Preferences PREFS = Preferences.userNodeForPackage(TreeViewer.class);
    public static final String CONTROLLER_KEY = "appearance";
    public static final String FOREGROUND_COLOUR_KEY = "foregroundColour";
    public static final String BACKGROUND_COLOUR_KEY = "backgroundColour";
    public static final String SELECTION_COLOUR_KEY = "selectionColour";
    public static final String BRANCH_COLOR_ATTRIBUTE_KEY = "branchColorAttribute";
    public static final String BRANCH_COLOR_GRADIENT_KEY = "branchColorGradient";
    public static final String HILIGHTING_GRADIENT_KEY = "hilightingGradient";
    public static final String BACKGROUND_COLOR_ATTRIBUTE_KEY = "backgroundColorAttribute";
    public static final String BRANCH_LINE_WIDTH_KEY = "branchLineWidth";
    public static final String BRANCH_MIN_LINE_WIDTH_KEY = "branchMinLineWidth";
    public static final String BRANCH_WIDTH_ATTRIBUTE_KEY = "branchWidthAttribute";
    public static Color DEFAULT_FOREGROUND_COLOUR = Color.BLACK;
    public static Color DEFAULT_BACKGROUND_COLOUR = Color.WHITE;
    public static Color DEFAULT_SELECTION_COLOUR = new Color(45, 54, 128);
    public static float DEFAULT_BRANCH_LINE_WIDTH = 1.0f;
    public static final String FIXED = "Fixed";
    private final AttributeColourController colourController;
    private final AttributableDecorator userBranchColourDecorator;
    private final JLabel titleLabel;
    private final OptionsPanel optionsPanel;
    private final JComboBox branchColourAttributeCombo;
    private final JCheckBox branchColourGradientCheck;
    private final JCheckBox hilightingGradientCheck;
    private final JComboBox backgroundColourAttributeCombo;
    private final JSpinner branchLineWidthSpinner;
    private final JSpinner branchMinLineWidthSpinner;
    private final JComboBox branchWidthAttributeCombo;
    private final TreeViewer treeViewer;
    private boolean branchColourIsGradient = false;

    public TreeAppearanceController(final TreeViewer treeViewer, JFrame jFrame, AttributeColourController attributeColourController) {
        this.treeViewer = treeViewer;
        this.colourController = attributeColourController;
        this.userBranchColourDecorator = new AttributableDecorator();
        this.userBranchColourDecorator.setPaintAttributeName("!color");
        this.userBranchColourDecorator.setStrokeAttributeName("!stroke");
        treeViewer.setBranchDecorator(this.userBranchColourDecorator, false);
        int n = PREFS.getInt("appearance.foregroundColour", DEFAULT_FOREGROUND_COLOUR.getRGB());
        int n2 = PREFS.getInt("appearance.backgroundColour", DEFAULT_BACKGROUND_COLOUR.getRGB());
        int n3 = PREFS.getInt("appearance.selectionColour", DEFAULT_SELECTION_COLOUR.getRGB());
        float f = PREFS.getFloat("appearance.branchLineWidth", DEFAULT_BRANCH_LINE_WIDTH);
        treeViewer.setForeground(new Color(n));
        treeViewer.setBackground(new Color(n2));
        treeViewer.setSelectionColor(new Color(n3));
        treeViewer.setBranchStroke(new BasicStroke(f, 1, 1));
        this.titleLabel = new JLabel(CONTROLLER_TITLE);
        this.optionsPanel = new ControllerOptionsPanel(2, 0);
        this.branchWidthAttributeCombo = new JComboBox<String>(new String[]{"No attributes"});
        this.branchColourAttributeCombo = new JComboBox<String>(new String[]{"No attributes"});
        this.backgroundColourAttributeCombo = new JComboBox<String>(new String[]{"No attributes"});
        this.branchColourIsGradient = PREFS.getBoolean("appearance.branchColorGradient", false);
        final JButton jButton = new JButton("Colours");
        attributeColourController.setupControls(this.branchColourAttributeCombo, jButton);
        attributeColourController.addControllerListener(new ControllerListener(){

            @Override
            public void controlsChanged() {
                TreeAppearanceController.this.setupBranchDecorators();
            }
        });
        this.branchColourGradientCheck = new JCheckBox("Gradient");
        this.branchColourGradientCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TreeAppearanceController.this.branchColourIsGradient = TreeAppearanceController.this.branchColourGradientCheck.isSelected();
                TreeAppearanceController.this.setupBranchDecorators();
            }
        });
        this.optionsPanel.addComponentWithLabel("Colour by:", this.branchColourAttributeCombo);
        final JLabel jLabel = this.optionsPanel.addComponentWithLabel("Setup:", jButton);
        this.optionsPanel.addComponent(this.branchColourGradientCheck);
        this.optionsPanel.addSeparator();
        boolean bl = PREFS.getBoolean("appearance.hilightingGradient", false);
        this.hilightingGradientCheck = new JCheckBox("Hilight with gradient");
        this.hilightingGradientCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                treeViewer.setHilightingGradient(TreeAppearanceController.this.hilightingGradientCheck.isSelected());
            }
        });
        this.optionsPanel.addComponent(this.hilightingGradientCheck);
        this.hilightingGradientCheck.setSelected(bl);
        this.optionsPanel.addSeparator();
        this.branchLineWidthSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.01, 48.0, 1.0));
        this.optionsPanel.addComponentWithLabel("Line Weight:", this.branchLineWidthSpinner);
        this.optionsPanel.addComponentWithLabel("Width by:", this.branchWidthAttributeCombo);
        this.branchMinLineWidthSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 48.0, 1.0));
        final JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Min Weight:", this.branchMinLineWidthSpinner);
        this.optionsPanel.addSeparator();
        final JButton jButton2 = new JButton("Colours");
        attributeColourController.setupControls(this.backgroundColourAttributeCombo, jButton2);
        attributeColourController.addControllerListener(new ControllerListener(){

            @Override
            public void controlsChanged() {
                TreeAppearanceController.this.setupBranchDecorators();
            }
        });
        this.optionsPanel.addComponentWithLabel("Background:", this.backgroundColourAttributeCombo);
        final JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Setup:", jButton2);
        new AttributeComboHelper(this.branchColourAttributeCombo, treeViewer, "User selection", false, true).addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                boolean bl = TreeAppearanceController.this.branchColourAttributeCombo.getSelectedIndex() != 0;
                jLabel.setEnabled(bl);
                jButton.setEnabled(bl);
                TreeAppearanceController.this.setupBranchDecorators();
            }
        });
        new AttributeComboHelper(this.backgroundColourAttributeCombo, treeViewer, "Default").addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                boolean bl = TreeAppearanceController.this.backgroundColourAttributeCombo.getSelectedIndex() != 0;
                jLabel3.setEnabled(bl);
                jButton2.setEnabled(bl);
                TreeAppearanceController.this.setupBranchDecorators();
            }
        });
        new AttributeComboHelper(this.branchWidthAttributeCombo, treeViewer, FIXED, true, false).addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                boolean bl = TreeAppearanceController.this.branchColourAttributeCombo.getSelectedIndex() != 0;
                jLabel2.setEnabled(bl);
                TreeAppearanceController.this.branchMinLineWidthSpinner.setEnabled(bl);
                TreeAppearanceController.this.setupBranchDecorators();
            }
        });
        this.branchLineWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)TreeAppearanceController.this.branchLineWidthSpinner.getValue()).floatValue();
                treeViewer.setBranchStroke(new BasicStroke(f, 0, 0));
                TreeAppearanceController.this.setupBranchDecorators();
            }
        });
        this.branchMinLineWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TreeAppearanceController.this.setupBranchDecorators();
            }
        });
    }

    private void setupBranchDecorators() {
        Object object;
        Decorator decorator = this.colourController.getColourDecorator(this.branchColourAttributeCombo, this.userBranchColourDecorator);
        CompoundDecorator compoundDecorator = new CompoundDecorator();
        if (decorator != null) {
            this.treeViewer.setBranchColouringDecorator(null, null);
            compoundDecorator.addDecorator(decorator);
        }
        if (this.branchWidthAttributeCombo.getSelectedIndex() > 0) {
            object = (String)this.branchWidthAttributeCombo.getSelectedItem();
            ContinuousScale continuousScale = new ContinuousScale((String)object, this.treeViewer.getTrees().get(0).getNodes());
            double d = (Double)this.branchMinLineWidthSpinner.getValue();
            double d2 = (Double)this.branchLineWidthSpinner.getValue() + d;
            compoundDecorator.addDecorator(new ContinuousStrokeDecorator(continuousScale, (float)d, (float)d2));
        }
        this.treeViewer.setBranchDecorator(compoundDecorator, this.branchColourIsGradient);
        object = null;
        if (this.backgroundColourAttributeCombo.getSelectedIndex() > 1) {
            object = this.colourController.getColourDecorator(this.backgroundColourAttributeCombo, null);
        }
        this.treeViewer.setNodeBackgroundDecorator((Decorator)object);
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.treeViewer.setForeground((Color)map.get("appearance.foregroundColour"));
        this.treeViewer.setBackground((Color)map.get("appearance.backgroundColour"));
        this.treeViewer.setSelectionColor((Color)map.get("appearance.selectionColour"));
        this.branchColourAttributeCombo.setSelectedItem(map.get("appearance.branchColorAttribute"));
        this.branchColourGradientCheck.setSelected((Boolean)map.get("appearance.branchColorGradient"));
        this.hilightingGradientCheck.setSelected((Boolean)map.get("appearance.hilightingGradient"));
        this.backgroundColourAttributeCombo.setSelectedItem(map.get("appearance.backgroundColorAttribute"));
        this.branchLineWidthSpinner.setValue((Double)map.get("appearance.branchLineWidth"));
        this.branchWidthAttributeCombo.setSelectedItem(map.get("appearance.branchWidthAttribute"));
        this.branchMinLineWidthSpinner.setValue((Double)map.get("appearance.branchMinLineWidth"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("appearance.foregroundColour", this.treeViewer.getForeground());
        map.put("appearance.backgroundColour", this.treeViewer.getBackground());
        map.put("appearance.selectionColour", this.treeViewer.getSelectionPaint());
        map.put("appearance.branchColorAttribute", this.branchColourAttributeCombo.getSelectedItem().toString());
        map.put("appearance.branchColorGradient", this.branchColourGradientCheck.isSelected());
        map.put("appearance.hilightingGradient", this.hilightingGradientCheck.isSelected());
        map.put("appearance.backgroundColorAttribute", this.backgroundColourAttributeCombo.getSelectedItem().toString());
        map.put("appearance.branchLineWidth", this.branchLineWidthSpinner.getValue());
        map.put("appearance.branchWidthAttribute", this.branchWidthAttributeCombo.getSelectedItem().toString());
        map.put("appearance.branchMinLineWidth", this.branchMinLineWidthSpinner.getValue());
    }
}

