/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.ContinuousColourScaleDialog;
import figtree.treeviewer.DiscreteColourScaleDialog;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.decorators.ColourDecorator;
import figtree.treeviewer.decorators.ContinuousColourDecorator;
import figtree.treeviewer.decorators.ContinuousScale;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.decorators.DiscreteColourDecorator;
import figtree.treeviewer.decorators.FixedDiscreteColourDecorator;
import figtree.treeviewer.decorators.HSBContinuousColourDecorator;
import figtree.treeviewer.decorators.HSBDiscreteColourDecorator;
import figtree.treeviewer.decorators.InterpolatingColourDecorator;
import jam.controlpalettes.AbstractController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

public class AttributeColourController
extends AbstractController {
    public static final String CONTROLLER_KEY = "colour";
    public static final String SCHEME_KEY = "scheme";
    public static final String ORDER_KEY = "order";
    private final TreeViewer treeViewer;
    private final JFrame frame;
    private Map<String, ColourDecorator> attributeDecoratorMap = new HashMap<String, ColourDecorator>();
    private Map<String, ContinuousScale> attributeScaleMap = new HashMap<String, ContinuousScale>();
    private ContinuousColourScaleDialog continuousColourScaleDialog = null;
    private DiscreteColourScaleDialog discreteColourScaleDialog = null;

    public AttributeColourController(TreeViewer treeViewer, JFrame jFrame) {
        this.treeViewer = treeViewer;
        this.frame = jFrame;
    }

    public void setupControls(final JComboBox jComboBox, final JButton jButton) {
        if (jButton != null) {
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    ColourDecorator colourDecorator = null;
                    if (jComboBox.getSelectedIndex() > 0) {
                        String string = (String)jComboBox.getSelectedItem();
                        colourDecorator = AttributeColourController.this.getDecoratorForAttribute(string);
                    }
                    if (colourDecorator == null) {
                        return;
                    }
                    boolean bl = false;
                    if (colourDecorator instanceof DiscreteColourDecorator) {
                        if (AttributeColourController.this.discreteColourScaleDialog == null) {
                            AttributeColourController.this.discreteColourScaleDialog = new DiscreteColourScaleDialog(AttributeColourController.this.frame);
                        }
                        AttributeColourController.this.discreteColourScaleDialog.setDecorator((DiscreteColourDecorator)colourDecorator);
                        n = AttributeColourController.this.discreteColourScaleDialog.showDialog();
                        if (n != 2 && n != -1) {
                            colourDecorator = AttributeColourController.this.discreteColourScaleDialog.getDecorator();
                            String string = (String)jComboBox.getSelectedItem();
                            AttributeColourController.this.setDecoratorForAttribute(string, colourDecorator);
                            bl = true;
                        }
                    } else if (colourDecorator instanceof ContinuousColourDecorator) {
                        if (AttributeColourController.this.continuousColourScaleDialog == null) {
                            AttributeColourController.this.continuousColourScaleDialog = new ContinuousColourScaleDialog(AttributeColourController.this.frame);
                        }
                        AttributeColourController.this.continuousColourScaleDialog.setDecorator((ContinuousColourDecorator)colourDecorator);
                        n = AttributeColourController.this.continuousColourScaleDialog.showDialog();
                        if (n != 2 && n != -1) {
                            colourDecorator = AttributeColourController.this.continuousColourScaleDialog.getDecorator();
                            String string = (String)jComboBox.getSelectedItem();
                            AttributeColourController.this.setDecoratorForAttribute(string, colourDecorator);
                            bl = true;
                        }
                    } else {
                        throw new IllegalArgumentException("Unsupported decorator type");
                    }
                    if (bl) {
                        if (jComboBox.getSelectedIndex() > 0) {
                            String string = (String)jComboBox.getSelectedItem();
                            AttributeColourController.this.setDecoratorForAttribute(string, colourDecorator);
                        }
                        AttributeColourController.this.fireControllerChanged();
                    }
                }
            });
            jComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    jButton.setEnabled(jComboBox.getSelectedIndex() > 0);
                }
            });
            jButton.setEnabled(jComboBox.getSelectedIndex() > 0);
        }
    }

    public Decorator getColourDecorator(JComboBox jComboBox, Decorator decorator) {
        String string;
        Decorator decorator2 = decorator;
        if ((decorator == null || jComboBox.getSelectedIndex() > 0) && (string = (String)jComboBox.getSelectedItem()) != null && string.length() > 0) {
            decorator2 = this.getDecoratorForAttribute(string);
        }
        return decorator2;
    }

    public ColourDecorator getDecoratorForAttribute(String string) {
        ColourDecorator colourDecorator = this.attributeDecoratorMap.get(string);
        HashSet<Attributable> hashSet = new HashSet<Attributable>();
        for (Tree tree : this.treeViewer.getTrees()) {
            for (Node node : tree.getNodes()) {
                if (node.getAttribute(string) != null) {
                    hashSet.add(node);
                }
                if (tree.getTaxon(node) == null) continue;
                hashSet.add(tree.getTaxon(node));
            }
        }
        if (colourDecorator == null) {
            if (string.endsWith("*")) {
                return null;
            }
            if (DiscreteColourDecorator.isDiscrete(string, hashSet)) {
                colourDecorator = new HSBDiscreteColourDecorator(string, hashSet);
            } else {
                Object object = this.attributeScaleMap.get(string);
                if (object == null) {
                    object = new ContinuousScale();
                    this.attributeScaleMap.put(string, (ContinuousScale)object);
                }
                ((ContinuousScale)object).setAttributes(string, hashSet);
                colourDecorator = new HSBContinuousColourDecorator((ContinuousScale)object);
            }
        } else if (colourDecorator instanceof DiscreteColourDecorator) {
            ((DiscreteColourDecorator)colourDecorator).setAttributes(string, hashSet);
        } else if (colourDecorator instanceof ContinuousColourDecorator) {
            ((ContinuousColourDecorator)colourDecorator).setAttributes(string, hashSet);
        }
        return colourDecorator;
    }

    private void setDecoratorForAttribute(String string, ColourDecorator colourDecorator) {
        this.attributeDecoratorMap.put(string, colourDecorator);
    }

    @Override
    public JComponent getTitleComponent() {
        return null;
    }

    @Override
    public JPanel getPanel() {
        return null;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        for (String string : map.keySet()) {
            Object object;
            Object object2;
            String string2;
            String[] stringArray;
            String string3;
            if (string.trim().startsWith("colour.scheme")) {
                String string4;
                string3 = (String)map.get(string);
                if (string3 == null || (stringArray = string3.split(":")).length != 2) continue;
                string2 = stringArray[0];
                object2 = this.getDecoratorForAttribute(string2);
                object = stringArray[1];
                if (((String)object).startsWith("HSBDiscrete")) {
                    string4 = ((String)object).substring("HSBDiscrete".length());
                    if (object2 == null || !(object2 instanceof HSBDiscreteColourDecorator)) {
                        object2 = new HSBDiscreteColourDecorator(string2, string4);
                    } else {
                        ((ColourDecorator)object2).setup(string4);
                    }
                } else if (((String)object).startsWith("FixedDiscrete")) {
                    string4 = ((String)object).substring("FixedDiscrete".length());
                    if (object2 == null || !(object2 instanceof FixedDiscreteColourDecorator)) {
                        object2 = new FixedDiscreteColourDecorator(string2, string4);
                    } else {
                        ((ColourDecorator)object2).setup(string4);
                    }
                } else if (((String)object).startsWith("HSBContinuous")) {
                    string4 = ((String)object).substring("HSBContinuous".length());
                    if (object2 == null || !(object2 instanceof HSBDiscreteColourDecorator)) {
                        object2 = new HSBContinuousColourDecorator(string2, string4);
                    } else {
                        ((ColourDecorator)object2).setup(string4);
                    }
                } else if (((String)object).startsWith("InterpolatingContinuous")) {
                    string4 = ((String)object).substring("InterpolatingContinuous".length());
                    if (object2 == null || !(object2 instanceof InterpolatingColourDecorator)) {
                        object2 = new InterpolatingColourDecorator(string2, string4);
                    } else {
                        ((ColourDecorator)object2).setup(string4);
                    }
                }
                this.setDecoratorForAttribute(string2, (ColourDecorator)object2);
                continue;
            }
            if (!string.trim().startsWith("colour.order") || (string3 = (String)map.get(string)) == null || (stringArray = string3.split(":")).length != 2) continue;
            string2 = stringArray[0];
            object2 = stringArray[1].split(",");
            object = this.getDecoratorForAttribute(string2);
            if (object == null || !(object instanceof DiscreteColourDecorator)) continue;
            ((DiscreteColourDecorator)object).setValuesOrder(Arrays.asList(object2));
            this.setDecoratorForAttribute(string2, (ColourDecorator)object);
        }
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        for (String string : this.attributeDecoratorMap.keySet()) {
            ColourDecorator colourDecorator = this.attributeDecoratorMap.get(string);
            String string2 = colourDecorator.toString();
            String string3 = "";
            if (colourDecorator instanceof HSBDiscreteColourDecorator) {
                string3 = "HSBDiscrete";
            } else if (colourDecorator instanceof FixedDiscreteColourDecorator) {
                string3 = "FixedDiscrete";
            } else if (colourDecorator instanceof HSBContinuousColourDecorator) {
                string3 = "HSBContinuous";
            } else if (colourDecorator instanceof InterpolatingColourDecorator) {
                string3 = "InterpolatingContinuous";
            } else {
                throw new IllegalArgumentException("Unrecognized colour decorator type");
            }
            map.put("colour.scheme." + this.flattenName(string), string + ":" + string3 + string2);
            if (!(colourDecorator instanceof DiscreteColourDecorator) || !((DiscreteColourDecorator)colourDecorator).hasReorderedValues()) continue;
            String string4 = ((DiscreteColourDecorator)colourDecorator).getOrderString();
            map.put("colour.order." + this.flattenName(string), string + ":" + string4);
        }
    }

    private String flattenName(String string) {
        String string2 = string.trim().toLowerCase();
        string2.replaceAll(" ", "_");
        string2.replaceAll("\t", "_");
        string2.replaceAll("\r", "_");
        return string2;
    }
}

