/*
 * Decompiled with CFR 0.152.
 */
package figtree.application;

import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.NexusImporter;

public class FigTreeNexusImporter
extends NexusImporter {
    public FigTreeNexusImporter(Reader reader) {
        super(reader);
    }

    public void parseFigTreeBlock(Map<String, Object> map) throws ImportException, IOException {
        this.readFigTreeBlock(map);
    }

    private void readFigTreeBlock(Map<String, Object> map) throws ImportException, IOException {
        String string = this.helper.readToken(";");
        while (!string.equalsIgnoreCase("END")) {
            if (string.equalsIgnoreCase("SET")) {
                while (this.helper.getLastDelimiter() != 59) {
                    String string2 = this.helper.readToken("=;");
                    if (this.helper.getLastDelimiter() != 61) {
                        throw new ImportException("Subcommand, " + string2 + ", is missing a value in command, " + string + ", in FIGTREE block");
                    }
                    String string3 = this.helper.readToken(";");
                    map.put(string2, this.parseValue(string3));
                }
            } else {
                throw new ImportException("Unknown command, " + string + ", in FIGTREE block");
            }
            string = this.helper.readToken(";");
        }
        this.findEndBlock();
    }

    private Object parseValue(String string) {
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
            return new Boolean(string);
        }
        if (string.startsWith("#")) {
            String string2 = string.substring(1);
            if (string2.startsWith("-")) {
                try {
                    return Color.decode(string2);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else {
                return Color.decode("0x" + string2);
            }
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException2) {
                return string;
            }
        }
    }
}

