/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.SimpleTextExtractingPdfContentRenderListener;
import com.itextpdf.text.pdf.parser.TextProvidingRenderListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ListIterator;

public class PdfTextExtractor {
    private final PdfReader reader;
    private final TextProvidingRenderListener renderListener;

    public PdfTextExtractor(PdfReader pdfReader) {
        this(pdfReader, new SimpleTextExtractingPdfContentRenderListener());
    }

    public PdfTextExtractor(PdfReader pdfReader, TextProvidingRenderListener textProvidingRenderListener) {
        this.reader = pdfReader;
        this.renderListener = textProvidingRenderListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getContentBytesForPage(int n) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        try {
            byte[] byArray;
            PdfDictionary pdfDictionary = this.reader.getPageN(n);
            PdfObject pdfObject = pdfDictionary.get(PdfName.CONTENTS);
            byte[] byArray2 = byArray = this.getContentBytesFromContentObject(pdfObject);
            return byArray2;
        }
        finally {
            randomAccessFileOrArray.close();
        }
    }

    private byte[] getContentBytesFromContentObject(PdfObject pdfObject) throws IOException {
        byte[] byArray;
        switch (pdfObject.type()) {
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                PdfObject pdfObject2 = PdfReader.getPdfObject(pRIndirectReference);
                byArray = this.getContentBytesFromContentObject(pdfObject2);
                break;
            }
            case 7: {
                PRStream pRStream = (PRStream)PdfReader.getPdfObject(pdfObject);
                byArray = PdfReader.getStreamBytes(pRStream);
                break;
            }
            case 5: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PdfArray pdfArray = (PdfArray)pdfObject;
                ListIterator listIterator = pdfArray.listIterator();
                while (listIterator.hasNext()) {
                    PdfObject pdfObject3 = (PdfObject)listIterator.next();
                    byteArrayOutputStream.write(this.getContentBytesFromContentObject(pdfObject3));
                }
                byArray = byteArrayOutputStream.toByteArray();
                break;
            }
            default: {
                String string = "Unable to handle Content of type " + pdfObject.getClass();
                throw new IllegalStateException(string);
            }
        }
        return byArray;
    }

    public String getTextFromPage(int n) throws IOException {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.RESOURCES);
        this.renderListener.reset();
        PdfContentStreamProcessor pdfContentStreamProcessor = new PdfContentStreamProcessor(this.renderListener);
        pdfContentStreamProcessor.processContent(this.getContentBytesForPage(n), pdfDictionary2);
        return this.renderListener.getResultantText();
    }
}

