/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStructureTreeRoot;

public class PdfStructureElement
extends PdfDictionary {
    private PdfStructureElement parent;
    private PdfStructureTreeRoot top;
    private PdfIndirectReference reference;

    public PdfStructureElement(PdfStructureElement pdfStructureElement, PdfName pdfName) {
        this.top = pdfStructureElement.top;
        this.init(pdfStructureElement, pdfName);
        this.parent = pdfStructureElement;
        this.put(PdfName.P, pdfStructureElement.reference);
    }

    public PdfStructureElement(PdfStructureTreeRoot pdfStructureTreeRoot, PdfName pdfName) {
        this.top = pdfStructureTreeRoot;
        this.init(pdfStructureTreeRoot, pdfName);
        this.put(PdfName.P, pdfStructureTreeRoot.getReference());
    }

    private void init(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfObject pdfObject = pdfDictionary.get(PdfName.K);
        PdfArray pdfArray = null;
        if (pdfObject != null && !pdfObject.isArray()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.parent.has.already.another.function"));
        }
        if (pdfObject == null) {
            pdfArray = new PdfArray();
            pdfDictionary.put(PdfName.K, pdfArray);
        } else {
            pdfArray = (PdfArray)pdfObject;
        }
        pdfArray.add(this);
        this.put(PdfName.S, pdfName);
        this.reference = this.top.getWriter().getPdfIndirectReference();
    }

    public PdfDictionary getParent() {
        return this.parent;
    }

    void setPageMark(int n, int n2) {
        if (n2 >= 0) {
            this.put(PdfName.K, new PdfNumber(n2));
        }
        this.top.setPageMark(n, this.reference);
    }

    public PdfIndirectReference getReference() {
        return this.reference;
    }
}

