/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.error_messages.MessageLocalization;
import java.awt.Color;

public class BaseColor {
    public static final BaseColor WHITE = new BaseColor(255, 255, 255);
    public static final BaseColor LIGHT_GRAY = new BaseColor(192, 192, 192);
    public static final BaseColor GRAY = new BaseColor(128, 128, 128);
    public static final BaseColor DARK_GRAY = new BaseColor(64, 64, 64);
    public static final BaseColor BLACK = new BaseColor(0, 0, 0);
    public static final BaseColor RED = new BaseColor(255, 0, 0);
    public static final BaseColor PINK = new BaseColor(255, 175, 175);
    public static final BaseColor ORANGE = new BaseColor(255, 200, 0);
    public static final BaseColor YELLOW = new BaseColor(255, 255, 0);
    public static final BaseColor GREEN = new BaseColor(0, 255, 0);
    public static final BaseColor MAGENTA = new BaseColor(255, 0, 255);
    public static final BaseColor CYAN = new BaseColor(0, 255, 255);
    public static final BaseColor BLUE = new BaseColor(0, 0, 255);
    private static final double FACTOR = 0.7;
    private int value;

    public BaseColor(int n, int n2, int n3, int n4) {
        BaseColor.validate(n);
        BaseColor.validate(n2);
        BaseColor.validate(n3);
        BaseColor.validate(n4);
        this.value = (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0;
    }

    public BaseColor(int n, int n2, int n3) {
        this(n, n2, n3, 255);
    }

    public BaseColor(float f, float f2, float f3, float f4) {
        this((int)((double)(f * 255.0f) + 0.5), (int)((double)(f2 * 255.0f) + 0.5), (int)((double)(f3 * 255.0f) + 0.5), (int)((double)(f4 * 255.0f) + 0.5));
    }

    public BaseColor(float f, float f2, float f3) {
        this(f, f2, f3, 1.0f);
    }

    public BaseColor(int n) {
        this.value = n;
    }

    public BaseColor(Color color) {
        this.value = color.getRGB();
    }

    public int getRGB() {
        return this.value;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public BaseColor brighter() {
        int n = this.getRed();
        int n2 = this.getGreen();
        int n3 = this.getBlue();
        int n4 = 3;
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new BaseColor(n4, n4, n4);
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new BaseColor(Math.min((int)((double)n / 0.7), 255), Math.min((int)((double)n2 / 0.7), 255), Math.min((int)((double)n3 / 0.7), 255));
    }

    public BaseColor darker() {
        return new BaseColor(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0));
    }

    public boolean equals(Object object) {
        return object instanceof BaseColor && ((BaseColor)object).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    private static void validate(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("color.value.outside.range.0.255"));
        }
    }
}

