/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class SplitterHandlePanel
extends JPanel {
    private final JButton handleButton;
    private final JSplitPane splitPane;
    private static BufferedImage backgroundImage = null;
    private static Icon addIcon = IconUtils.getIcon(SplitterHandlePanel.class, "images/splitter/add.png");
    private static Icon handleIcon = IconUtils.getIcon(SplitterHandlePanel.class, "images/splitter/handle.png");

    public SplitterHandlePanel(JSplitPane jSplitPane) {
        this(jSplitPane, true);
    }

    public SplitterHandlePanel(JSplitPane jSplitPane, boolean bl) {
        this.splitPane = jSplitPane;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JButton jButton = new JButton("+");
        jButton.putClientProperty("JButton.buttonType", "toolbar");
        if (addIcon != null) {
            jButton.setIcon(addIcon);
            jButton.setText(null);
            jButton.setPreferredSize(new Dimension(addIcon.getIconWidth(), addIcon.getIconHeight()));
        }
        jButton.setBorderPainted(false);
        jButton.setOpaque(false);
        jButton.setContentAreaFilled(false);
        JPanel jPanel = new JPanel(new BorderLayout()){

            public void paint(Graphics graphics) {
                graphics.drawImage(backgroundImage, 0, 0, this.getWidth(), this.getHeight(), null);
                super.paint(graphics);
            }
        };
        jPanel.setOpaque(false);
        this.handleButton = new JButton("|||");
        this.handleButton.putClientProperty("JButton.buttonType", "toolbar");
        if (handleIcon != null) {
            this.handleButton.setIcon(handleIcon);
            this.handleButton.setText(null);
            this.handleButton.setPreferredSize(new Dimension(handleIcon.getIconWidth(), handleIcon.getIconHeight()));
        }
        this.handleButton.setBorderPainted(false);
        this.handleButton.setOpaque(false);
        this.handleButton.setContentAreaFilled(false);
        new DragHandler(this.handleButton);
        this.add((Component)jButton, "West");
        this.add((Component)jPanel, "Center");
        this.add((Component)this.handleButton, "East");
    }

    static {
        try {
            backgroundImage = IconUtils.getBufferedImage(SplitterHandlePanel.class, "images/splitter/background.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class DragHandler
    extends MouseAdapter {
        private JComponent component;
        private int dividerLocation;
        private int pressedLocation;

        public DragHandler(JComponent jComponent) {
            this.component = jComponent;
            jComponent.addMouseListener(this);
            jComponent.addMouseMotionListener(this);
        }

        public void dispose() {
            this.component.removeMouseListener(this);
            this.component.removeMouseMotionListener(this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.dividerLocation = SplitterHandlePanel.this.splitPane.getDividerLocation();
            this.pressedLocation = mouseEvent.getX();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.dividerLocation + (mouseEvent.getX() - this.pressedLocation);
            int n2 = SplitterHandlePanel.this.splitPane.getMinimumDividerLocation();
            int n3 = SplitterHandlePanel.this.splitPane.getMaximumDividerLocation();
            final int n4 = n < n2 ? n2 : (n > n3 ? n3 : n);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SplitterHandlePanel.this.splitPane.setDividerLocation(n4);
                }
            });
        }
    }
}

