/*
 * Decompiled with CFR 0.152.
 */
package figtree.ui.components;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JLabel;

public class JVerticalLabel
extends JLabel {
    private boolean clockwise;

    public JVerticalLabel(boolean bl) {
        this.clockwise = bl;
    }

    public JVerticalLabel(Icon icon, boolean bl) {
        super(icon);
        this.clockwise = bl;
    }

    public JVerticalLabel(Icon icon, int n, boolean bl) {
        super(icon, n);
        this.clockwise = bl;
    }

    public JVerticalLabel(String string, boolean bl) {
        super(string);
        this.clockwise = bl;
    }

    public JVerticalLabel(String string, Icon icon, int n, boolean bl) {
        super(string, icon, n);
        this.clockwise = bl;
    }

    public JVerticalLabel(String string, int n, boolean bl) {
        super(string, n);
        this.clockwise = bl;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String string = this.getText();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getDescent();
        int n3 = fontMetrics.getAscent();
        return new Dimension(insets.top + n3 + n2 + insets.bottom, insets.right + n + insets.left);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        String string = this.getText();
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(string);
        int n2 = insets.right;
        switch (this.getHorizontalAlignment()) {
            case 0: {
                n2 = (dimension.height - n + insets.right - insets.left) / 2;
                break;
            }
            case 1: {
                n2 = dimension.height - n - insets.left;
            }
        }
        int n3 = fontMetrics.getDescent();
        int n4 = fontMetrics.getAscent();
        int n5 = insets.top + n4;
        switch (this.getVerticalAlignment()) {
            case 0: {
                n5 = (dimension.width + n4 - n3 + insets.top - insets.bottom) / 2;
                break;
            }
            case 4: {
                n5 = dimension.width - n3 - insets.bottom;
            }
        }
        AffineTransform affineTransform = this.clockwise ? new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, -dimension.height, 0.0f) : new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, dimension.height);
        graphics2D.transform(affineTransform);
        graphics2D.setPaintMode();
        if (this.isOpaque() && this.getBackground() != null) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, dimension.height, dimension.width);
        }
        graphics2D.setFont(this.getFont());
        graphics2D.setColor(this.getForeground());
        graphics2D.drawString(string, n2, n5);
        affineTransform = null;
        graphics2D = null;
    }
}

