/*
 * Decompiled with CFR 0.152.
 */
package figtree.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class FontChooserPanel
extends JPanel {
    public static final String[] SIZES = new String[]{"6", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "28", "36", "48", "72"};
    private JComboBox fontlist;
    private JComboBox sizelist;
    private JCheckBox boldCheck;
    private JCheckBox italicCheck;

    public FontChooserPanel(Font font) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.fontlist = new JComboBox<String>(stringArray);
        this.adjustComponent(this.fontlist);
        this.sizelist = new JComboBox<String>(SIZES);
        this.adjustComponent(this.sizelist);
        jPanel.add(this.fontlist);
        JPanel jPanel2 = new JPanel(new BorderLayout(3, 0));
        JLabel jLabel = new JLabel("Size:");
        this.adjustComponent(jLabel);
        jLabel.setHorizontalAlignment(4);
        jPanel2.add((Component)jLabel, "Center");
        jPanel2.add((Component)this.sizelist, "East");
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        this.boldCheck = new JCheckBox("Bold");
        this.adjustComponent(this.boldCheck);
        this.italicCheck = new JCheckBox("Italic");
        this.adjustComponent(this.italicCheck);
        jPanel3.add(this.boldCheck);
        jPanel3.add(this.italicCheck);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel3, "East");
        this.setSelectedFont(font);
    }

    public Font getSelectedFont() {
        return new Font(this.getSelectedName(), this.getSelectedStyle(), this.getSelectedSize());
    }

    public String getSelectedName() {
        return (String)this.fontlist.getSelectedItem();
    }

    public int getSelectedStyle() {
        if (this.boldCheck.isSelected() && this.italicCheck.isSelected()) {
            return 3;
        }
        if (this.boldCheck.isSelected()) {
            return 1;
        }
        if (this.italicCheck.isSelected()) {
            return 2;
        }
        return 0;
    }

    public int getSelectedSize() {
        String string = (String)this.sizelist.getSelectedItem();
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 10;
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            throw new NullPointerException();
        }
        this.boldCheck.setSelected(font.isBold());
        this.italicCheck.setSelected(font.isItalic());
        String string = font.getName();
        ComboBoxModel comboBoxModel = this.fontlist.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!string.equals(comboBoxModel.getElementAt(i))) continue;
            this.fontlist.setSelectedIndex(i);
            break;
        }
        String string2 = String.valueOf(font.getSize());
        comboBoxModel = this.sizelist.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!string2.equals(comboBoxModel.getElementAt(i))) continue;
            this.sizelist.setSelectedIndex(i);
            break;
        }
    }

    protected void adjustComponent(JComponent jComponent) {
        Font font = UIManager.getFont("SmallSystemFont");
        if (font != null) {
            jComponent.setFont(font);
        }
        jComponent.putClientProperty("JComponent.sizeVariant", "small");
        if (jComponent instanceof JButton) {
            jComponent.putClientProperty("JButton.buttonType", "roundRect");
        }
        if (jComponent instanceof JComboBox) {
            // empty if block
        }
    }
}

