/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.treelayouts;

import figtree.treeviewer.treelayouts.AbstractTreeLayout;
import figtree.treeviewer.treelayouts.TreeLayout;
import figtree.treeviewer.treelayouts.TreeLayoutCache;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.RootedTree;

public class RectilinearTreeLayout
extends AbstractTreeLayout {
    private double curvature = 0.0;
    private boolean alignTipLabels = false;
    private double fishEye = 0.0;
    private double pointOfInterest = 0.5;
    private int tipCount = 0;
    private double rootLengthProportion = 0.01;
    private double yPosition;
    private double yIncrement;
    private double maxXPosition;

    @Override
    public TreeLayout.AxisType getXAxisType() {
        return TreeLayout.AxisType.CONTINUOUS;
    }

    @Override
    public TreeLayout.AxisType getYAxisType() {
        return TreeLayout.AxisType.DISCRETE;
    }

    @Override
    public boolean isShowingRootBranch() {
        return true;
    }

    @Override
    public boolean maintainAspectRatio() {
        return false;
    }

    public double getRootLengthProportion() {
        return this.rootLengthProportion;
    }

    public void setRootLengthProportion(double d) {
        this.rootLengthProportion = d;
        this.fireTreeLayoutChanged();
    }

    @Override
    public double getHeightOfPoint(Point2D point2D) {
        return point2D.getX();
    }

    @Override
    public Shape getAxisLine(double d) {
        double d2 = d;
        if (this.isAxisReversed()) {
            d2 = this.maxXPosition - d2;
        }
        double d3 = 0.0;
        double d4 = 1.0;
        return new Line2D.Double(d2, d3, d2, d4);
    }

    @Override
    public Shape getHeightArea(double d, double d2) {
        double d3 = d;
        if (this.isAxisReversed()) {
            d3 = this.maxXPosition - d3;
        }
        double d4 = 0.0;
        double d5 = Math.abs(d2 - d);
        double d6 = 1.0;
        return new Rectangle2D.Double(d3, d4, d5, d6);
    }

    public boolean isAlignTipLabels() {
        return this.alignTipLabels;
    }

    public double getCurvature() {
        return this.curvature;
    }

    public double getFishEye() {
        return this.fishEye;
    }

    public double getPointOfInterest() {
        return this.pointOfInterest;
    }

    public void setAlignTipLabels(boolean bl) {
        this.alignTipLabels = bl;
        this.fireTreeLayoutChanged();
    }

    public void setCurvature(double d) {
        this.curvature = d;
        this.fireTreeLayoutChanged();
    }

    @Override
    public void setFishEye(double d) {
        this.fishEye = d;
        this.fireTreeLayoutChanged();
    }

    @Override
    public void setPointOfInterest(double d, double d2) {
        this.pointOfInterest = d2;
        this.fireTreeLayoutChanged();
    }

    @Override
    public boolean isShowingColouring() {
        return this.branchColouringAttribute != null && this.curvature == 0.0;
    }

    @Override
    public void layout(RootedTree rootedTree, TreeLayoutCache treeLayoutCache) {
        treeLayoutCache.clear();
        this.maxXPosition = 0.0;
        this.yPosition = 0.0;
        this.tipCount = rootedTree.getExternalNodes().size();
        this.yIncrement = 1.0 / (double)(this.tipCount - 1);
        Node node = rootedTree.getRootNode();
        this.setRootLength(this.rootLengthProportion * rootedTree.getHeight(node));
        this.maxXPosition = 0.0;
        this.getMaxXPosition(rootedTree, node, this.getRootLength());
        Point2D point2D = this.constructNode(rootedTree, node, 0.0, this.getRootLength(), treeLayoutCache);
        this.constructNodeAreas(rootedTree, node, new Area(), treeLayoutCache);
        double d = this.transformY(point2D.getY());
        Line2D.Double double_ = new Line2D.Double(0.0, d, point2D.getX(), d);
        treeLayoutCache.branchPaths.put(node, double_);
    }

    private Point2D constructNode(RootedTree rootedTree, Node node, double d, double d2, TreeLayoutCache treeLayoutCache) {
        Point2D point2D;
        if (this.hilightAttributeName != null && node.getAttribute(this.hilightAttributeName) != null) {
            this.constructHilight(rootedTree, node, d, d2, treeLayoutCache);
        }
        if (!rootedTree.isExternal(node)) {
            if (this.collapsedAttributeName != null && node.getAttribute(this.collapsedAttributeName) != null) {
                point2D = this.constructCollapsedNode(rootedTree, node, d2, treeLayoutCache);
            } else if (this.cartoonAttributeName != null && node.getAttribute(this.cartoonAttributeName) != null) {
                point2D = this.constructCartoonNode(rootedTree, node, d2, treeLayoutCache);
            } else {
                double d3 = 0.0;
                List<Node> list = rootedTree.getChildren(node);
                boolean bl = false;
                if (node.getAttribute("!rotate") != null && ((Boolean)node.getAttribute("!rotate")).booleanValue()) {
                    bl = true;
                }
                for (int i = 0; i < list.size(); ++i) {
                    int n = i;
                    if (bl) {
                        n = list.size() - i - 1;
                    }
                    Node node2 = list.get(n);
                    double d4 = rootedTree.getLength(node2);
                    Point2D object2 = this.constructNode(rootedTree, node2, d2, d2 + d4, treeLayoutCache);
                    d3 += object2.getY();
                }
                point2D = new Point2D.Double(d2, d3 /= (double)list.size());
                double d5 = this.transformY(d3);
                float f = (float)point2D.getX();
                float f2 = (float)d5;
                for (Node node2 : list) {
                    float f3;
                    Point2D point2D2 = treeLayoutCache.nodePoints.get(node2);
                    GeneralPath generalPath = new GeneralPath();
                    float f4 = (float)point2D2.getX();
                    float f5 = (float)this.transformY(point2D2.getY());
                    if (this.curvature == 0.0) {
                        Object[] objectArray = null;
                        if (this.branchColouringAttribute != null) {
                            objectArray = (Object[])node2.getAttribute(this.branchColouringAttribute);
                        }
                        if (objectArray != null) {
                            f3 = (float)rootedTree.getHeight(node);
                            float f6 = (float)rootedTree.getHeight(node2);
                            generalPath.moveTo(f4, f5);
                            float f7 = f4;
                            for (int i = 0; i < objectArray.length - 1; i += 2) {
                                float f8 = ((Number)objectArray[i + 1]).floatValue();
                                float f9 = f8 / (f3 - f6);
                                generalPath.lineTo(f7 -= (f4 - f) * f9, f5);
                            }
                            generalPath.lineTo(f, f5);
                            generalPath.lineTo(f, f2);
                        } else {
                            generalPath.moveTo(f4, f5);
                            generalPath.lineTo(f, f5);
                            generalPath.lineTo(f, f2);
                        }
                    } else if (this.curvature == 1.0) {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f4, f5);
                    } else {
                        float f10 = f4 - (f4 - f) * (float)(1.0 - this.curvature);
                        f3 = f2 + (f5 - f2) * (float)(1.0 - this.curvature);
                        generalPath.moveTo(f4, f5);
                        generalPath.lineTo(f10, f5);
                        generalPath.quadTo(f, f5, f, f3);
                        generalPath.lineTo(f, f2);
                    }
                    treeLayoutCache.branchPaths.put(node2, generalPath);
                    double d4 = (point2D.getX() + point2D2.getX()) / 2.0;
                    Line2D.Double double_ = new Line2D.Double(d4 - 1.0, f5, d4 + 1.0, f5);
                    treeLayoutCache.branchLabelPaths.put(node2, double_);
                }
                Line2D.Double double_ = new Line2D.Double(point2D.getX(), d5, point2D.getX() + 1.0, d5);
                treeLayoutCache.nodeLabelPaths.put(node, double_);
                Line2D.Double double_2 = new Line2D.Double(point2D.getX(), d5, point2D.getX() - 1.0, d5);
                treeLayoutCache.nodeShapePaths.put(node, double_2);
            }
        } else {
            Line2D.Double double_;
            Line2D.Double double_2;
            point2D = new Point2D.Double(d2, this.yPosition);
            double d7 = this.transformY(this.yPosition);
            if (this.alignTipLabels) {
                double_2 = new Line2D.Double(this.maxXPosition, d7, this.maxXPosition + 1.0, d7);
                double_ = new Line2D.Double(point2D.getX(), d7, this.maxXPosition, d7);
                treeLayoutCache.calloutPaths.put(node, double_);
            } else {
                double_2 = new Line2D.Double(point2D.getX(), d7, point2D.getX() + 1.0, d7);
            }
            treeLayoutCache.tipLabelPaths.put(node, double_2);
            double_ = new Line2D.Double(point2D.getX(), d7, point2D.getX() - 1.0, d7);
            treeLayoutCache.nodeShapePaths.put(node, double_);
            this.yPosition += this.yIncrement;
        }
        treeLayoutCache.nodePoints.put(node, point2D);
        return point2D;
    }

    private void constructNodeAreas(RootedTree rootedTree, Node node, Area area, TreeLayoutCache treeLayoutCache) {
        if (!(rootedTree.isExternal(node) || this.collapsedAttributeName != null && node.getAttribute(this.collapsedAttributeName) != null || this.cartoonAttributeName != null && node.getAttribute(this.cartoonAttributeName) != null)) {
            float f;
            List<Node> list = rootedTree.getChildren(node);
            boolean bl = false;
            if (node.getAttribute("!rotate") != null && ((Boolean)node.getAttribute("!rotate")).booleanValue()) {
                bl = true;
            }
            int n = bl ? list.size() - 1 : 0;
            Node node2 = list.get(n);
            Area area2 = new Area();
            this.constructNodeAreas(rootedTree, node2, area2, treeLayoutCache);
            Rectangle2D rectangle2D = treeLayoutCache.getBranchPath(node2).getBounds2D();
            n = bl ? 0 : list.size() - 1;
            Node node3 = list.get(n);
            Area area3 = new Area();
            this.constructNodeAreas(rootedTree, node3, area3, treeLayoutCache);
            Rectangle2D rectangle2D2 = treeLayoutCache.getBranchPath(node3).getBounds2D();
            GeneralPath generalPath = new GeneralPath();
            float f2 = (float)rectangle2D.getX();
            float f3 = (float)(rectangle2D.getY() + rectangle2D.getHeight());
            generalPath.moveTo(f2, f3);
            if (this.curvature == 0.0) {
                f = (float)rectangle2D.getY();
                generalPath.lineTo(f2, f);
                generalPath.lineTo((float)this.maxXPosition, f);
                float f4 = (float)(rectangle2D2.getY() + rectangle2D2.getHeight());
                generalPath.lineTo((float)this.maxXPosition, f4);
                generalPath.lineTo(f2, f4);
            } else if (this.curvature == 1.0) {
                f = (float)(rectangle2D.getX() + rectangle2D.getWidth());
                float f5 = (float)rectangle2D.getY();
                generalPath.lineTo(f, f5);
                generalPath.lineTo((float)this.maxXPosition, f5);
                float f6 = (float)(rectangle2D2.getY() + rectangle2D2.getHeight());
                generalPath.lineTo((float)this.maxXPosition, f6);
                float f7 = (float)(rectangle2D2.getX() + rectangle2D2.getWidth());
                generalPath.lineTo(f7, f6);
            } else {
                f = (float)(rectangle2D.getX() + rectangle2D.getWidth());
                float f8 = (float)rectangle2D.getY();
                float f9 = f - (f - f2) * (float)(1.0 - this.curvature);
                float f10 = f3 - (f3 - f8) * (float)(1.0 - this.curvature);
                generalPath.lineTo(f2, f10);
                generalPath.quadTo(f2, f8, f9, f8);
                generalPath.lineTo((float)this.maxXPosition, f8);
                float f11 = (float)(rectangle2D2.getY() + rectangle2D2.getHeight());
                generalPath.lineTo((float)this.maxXPosition, f11);
                float f12 = (float)(rectangle2D2.getX() + rectangle2D2.getWidth());
                float f13 = f12 - (f12 - f2) * (float)(1.0 - this.curvature);
                float f14 = f3 + (f11 - f3) * (float)(1.0 - this.curvature);
                generalPath.lineTo(f13, f11);
                generalPath.quadTo(f2, f11, f2, f14);
            }
            generalPath.lineTo(f2, f3);
            generalPath.closePath();
            Area area4 = new Area(generalPath);
            area.add(area4);
            area.add(area2);
            area.add(area3);
            area4.subtract(area2);
            area4.subtract(area3);
            treeLayoutCache.nodeAreas.put(node, area4);
        }
    }

    private Point2D constructCartoonNode(RootedTree rootedTree, Node node, double d, TreeLayoutCache treeLayoutCache) {
        Object[] objectArray = (Object[])node.getAttribute(this.cartoonAttributeName);
        int n = (Integer)objectArray[0];
        double d2 = (Double)objectArray[1];
        double d3 = rootedTree.getHeight(node);
        double d4 = d + d3 - d2;
        double d5 = this.yPosition;
        this.yPosition += this.yIncrement * (double)(n - 1);
        double d6 = this.yPosition;
        this.yPosition += this.yIncrement;
        double d7 = (d6 + d5) / 2.0;
        Point2D.Double double_ = new Point2D.Double(d, d7);
        GeneralPath generalPath = new GeneralPath();
        float f = (float)((Point2D)double_).getX();
        float f2 = (float)this.transformY(((Point2D)double_).getY());
        float f3 = (float)d4;
        float f4 = (float)this.transformY(d5);
        float f5 = (float)this.transformY(d6);
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f3, f5);
        generalPath.closePath();
        treeLayoutCache.collapsedShapes.put(node, generalPath);
        Line2D.Double double_2 = new Line2D.Double(((Point2D)double_).getX(), f2, ((Point2D)double_).getX() + 1.0, f2);
        treeLayoutCache.nodeLabelPaths.put(node, double_2);
        Line2D.Double double_3 = new Line2D.Double(((Point2D)double_).getX(), f2, ((Point2D)double_).getX() - 1.0, f2);
        treeLayoutCache.nodeShapePaths.put(node, double_3);
        if (this.showingCartoonTipLabels) {
            this.constructCartoonTipLabelPaths(rootedTree, node, d4, new double[]{d5}, treeLayoutCache);
        }
        return double_;
    }

    private void constructCartoonTipLabelPaths(RootedTree rootedTree, Node node, double d, double[] dArray, TreeLayoutCache treeLayoutCache) {
        if (!rootedTree.isExternal(node)) {
            for (Node node2 : rootedTree.getChildren(node)) {
                this.constructCartoonTipLabelPaths(rootedTree, node2, d, dArray, treeLayoutCache);
            }
        } else {
            Line2D.Double double_;
            Point2D.Double double_2 = new Point2D.Double(d, dArray[0]);
            double d2 = ((Point2D)double_2).getX();
            double d3 = this.transformY(((Point2D)double_2).getY());
            if (this.alignTipLabels) {
                double_ = new Line2D.Double(this.maxXPosition, d3, this.maxXPosition + 1.0, d3);
                Line2D.Double double_3 = new Line2D.Double(d2, d3, this.maxXPosition, d3);
                treeLayoutCache.calloutPaths.put(node, double_3);
            } else {
                double_ = new Line2D.Double(d2, d3, d2 + 1.0, d3);
            }
            treeLayoutCache.tipLabelPaths.put(node, double_);
            dArray[0] = dArray[0] + this.yIncrement;
        }
    }

    private Point2D constructCollapsedNode(RootedTree rootedTree, Node node, double d, TreeLayoutCache treeLayoutCache) {
        Line2D.Double double_;
        Object[] objectArray = (Object[])node.getAttribute(this.collapsedAttributeName);
        double d2 = (Double)objectArray[1];
        double d3 = rootedTree.getHeight(node);
        double d4 = d + d3 - d2;
        double d5 = this.yPosition - this.yIncrement * 0.5;
        double d6 = d5 + this.yIncrement;
        this.yPosition += this.yIncrement;
        double d7 = (d6 + d5) / 2.0;
        Point2D.Double double_2 = new Point2D.Double(d, d7);
        double d8 = this.transformY(d7);
        GeneralPath generalPath = new GeneralPath();
        float f = (float)((Point2D)double_2).getX();
        float f2 = (float)d8;
        float f3 = (float)d4;
        float f4 = (float)this.transformY(d5);
        float f5 = (float)this.transformY(d6);
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f3, f5);
        generalPath.closePath();
        treeLayoutCache.collapsedShapes.put(node, generalPath);
        Line2D.Double double_3 = new Line2D.Double(d, d8, d + 1.0, d8);
        treeLayoutCache.nodeLabelPaths.put(node, double_3);
        Line2D.Double double_4 = new Line2D.Double(d, d8, d - 1.0, d8);
        treeLayoutCache.nodeShapePaths.put(node, double_4);
        if (this.alignTipLabels) {
            double_ = new Line2D.Double(this.maxXPosition, d8, this.maxXPosition + 1.0, d8);
            Line2D.Double double_5 = new Line2D.Double(d4, d8, this.maxXPosition, d8);
            treeLayoutCache.calloutPaths.put(node, double_5);
        } else {
            double_ = new Line2D.Double(d4, d8, d4 + 1.0, d8);
        }
        treeLayoutCache.tipLabelPaths.put(node, double_);
        return double_2;
    }

    private void constructHilight(RootedTree rootedTree, Node node, double d, double d2, TreeLayoutCache treeLayoutCache) {
        Object[] objectArray = (Object[])node.getAttribute(this.hilightAttributeName);
        int n = (Integer)objectArray[0];
        double d3 = (Double)objectArray[1];
        double d4 = rootedTree.getHeight(node);
        GeneralPath generalPath = new GeneralPath();
        float f = (float)((d2 + d) / 2.0);
        float f2 = (float)(d2 + d4);
        double d5 = this.yPosition - this.yIncrement / 2.0;
        float f3 = (float)this.transformY(d5);
        float f4 = (float)this.transformY(d5 + this.yIncrement * (double)n);
        generalPath.moveTo(f, f3);
        generalPath.lineTo(f2, f3);
        generalPath.lineTo(f2, f4);
        generalPath.lineTo(f, f4);
        generalPath.closePath();
        treeLayoutCache.hilightNodes.add(node);
        treeLayoutCache.hilightShapes.put(node, generalPath);
    }

    private void getMaxXPosition(RootedTree rootedTree, Node node, double d) {
        if (!rootedTree.isExternal(node)) {
            List<Node> list = rootedTree.getChildren(node);
            for (Node node2 : list) {
                double d2 = rootedTree.getLength(node2);
                this.getMaxXPosition(rootedTree, node2, d + d2);
            }
        } else if (d > this.maxXPosition) {
            this.maxXPosition = d;
        }
    }

    private double transformY(double d) {
        if (this.fishEye == 0.0) {
            return d;
        }
        double d2 = 1.0 / (this.fishEye * (double)this.tipCount);
        double d3 = this.pointOfInterest - d;
        double d4 = 1.0 - this.pointOfInterest / (d2 + this.pointOfInterest);
        double d5 = 1.0 - (this.pointOfInterest - 1.0) / (d2 - (this.pointOfInterest - 1.0));
        double d6 = 1.0 - (d3 < 0.0 ? d3 / (d2 - d3) : d3 / (d2 + d3));
        return (d6 - d4) / (d5 - d4);
    }
}

