/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.AttributeColourController;
import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.AttributeComboHelper;
import figtree.treeviewer.painters.AttributeComboHelperListener;
import figtree.treeviewer.painters.NodeBarController;
import figtree.treeviewer.painters.NodeShapePainter;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NodeShapeController
extends AbstractController {
    private static Preferences PREFS = Preferences.userNodeForPackage(NodeBarController.class);
    private static final String NODE_SHAPE_KEY = "nodeShape";
    public static final String SHAPE_TYPE_KEY = "shapeType";
    public static final String SCALE_TYPE_KEY = "scaleType";
    public static final String SIZE_ATTRIBUTE_KEY = "sizeAttribute";
    public static final String COLOUR_ATTRIBUTE_KEY = "colourAttribute";
    private static final String SHAPE_SIZE_KEY = "size";
    private static final String SHAPE_MIN_SIZE_KEY = "minSize";
    private final JCheckBox titleCheckBox;
    private final OptionsPanel optionsPanel;
    private final JComboBox shapeTypeCombo;
    private final JComboBox scaleTypeCombo;
    private final JComboBox sizeAttributeCombo;
    private final JComboBox colourAttributeCombo;
    private final JSpinner shapeSizeSpinner;
    private final JSpinner shapeMinSizeSpinner;
    private final String title;
    private final NodeShapePainter nodeShapePainter;

    public NodeShapeController(String string, final NodeShapePainter nodeShapePainter, final AttributeColourController attributeColourController, TreeViewer treeViewer) {
        this.title = string;
        this.nodeShapePainter = nodeShapePainter;
        float f = PREFS.getFloat(SHAPE_SIZE_KEY, 4.0f);
        this.optionsPanel = new ControllerOptionsPanel(2, 2);
        this.titleCheckBox = new JCheckBox(this.getTitle());
        this.titleCheckBox.setSelected(this.nodeShapePainter.isVisible());
        this.titleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = NodeShapeController.this.titleCheckBox.isSelected();
                nodeShapePainter.setVisible(bl);
            }
        });
        this.shapeTypeCombo = new JComboBox<NodeShapePainter.ShapeType>(NodeShapePainter.ShapeType.values());
        this.shapeTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nodeShapePainter.setShapeType((NodeShapePainter.ShapeType)((Object)NodeShapeController.this.shapeTypeCombo.getSelectedItem()));
            }
        });
        this.scaleTypeCombo = new JComboBox<NodeShapePainter.ScaleType>(NodeShapePainter.ScaleType.values());
        this.scaleTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nodeShapePainter.setScaleType((NodeShapePainter.ScaleType)((Object)NodeShapeController.this.scaleTypeCombo.getSelectedItem()));
            }
        });
        this.sizeAttributeCombo = new JComboBox();
        this.colourAttributeCombo = new JComboBox();
        JButton jButton = new JButton("Colour");
        attributeColourController.setupControls(this.colourAttributeCombo, jButton);
        this.shapeSizeSpinner = new JSpinner(new SpinnerNumberModel(f, 0.0, 100.0, 1.0));
        this.shapeSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NodeShapeController.this.shapeSizeSpinner.getValue();
                nodeShapePainter.setMaxSize(d);
            }
        });
        this.shapeMinSizeSpinner = new JSpinner(new SpinnerNumberModel(10.0, 0.0, 100.0, 1.0));
        this.shapeMinSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NodeShapeController.this.shapeMinSizeSpinner.getValue();
                nodeShapePainter.setMinSize(d);
            }
        });
        JLabel jLabel = this.optionsPanel.addComponentWithLabel("Shape:", this.shapeTypeCombo);
        JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Max size:", this.shapeSizeSpinner);
        JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Size by:", this.sizeAttributeCombo);
        final JLabel jLabel4 = this.optionsPanel.addComponentWithLabel("Min size:", this.shapeMinSizeSpinner);
        final JLabel jLabel5 = this.optionsPanel.addComponentWithLabel("Using:", this.scaleTypeCombo);
        this.optionsPanel.addSeparator();
        JLabel jLabel6 = this.optionsPanel.addComponentWithLabel("Colour by:", this.colourAttributeCombo);
        JLabel jLabel7 = this.optionsPanel.addComponentWithLabel("Setup:", jButton);
        new AttributeComboHelper(this.colourAttributeCombo, treeViewer, "User selection").addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                Decorator decorator = attributeColourController.getColourDecorator(NodeShapeController.this.colourAttributeCombo, null);
                nodeShapePainter.setColourDecorator(decorator);
            }
        });
        new AttributeComboHelper(this.sizeAttributeCombo, treeViewer, "Fixed", true, false).addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                String string = (String)NodeShapeController.this.sizeAttributeCombo.getSelectedItem();
                nodeShapePainter.setSizeAttribute(string);
                if (string != null) {
                    boolean bl = !string.equals("Fixed");
                    jLabel4.setEnabled(bl);
                    NodeShapeController.this.shapeMinSizeSpinner.setEnabled(bl);
                    jLabel5.setEnabled(bl);
                    NodeShapeController.this.scaleTypeCombo.setEnabled(bl);
                }
            }
        });
        this.addComponent(jLabel);
        this.addComponent(this.shapeTypeCombo);
        this.addComponent(jLabel2);
        this.addComponent(this.shapeSizeSpinner);
        this.addComponent(jLabel3);
        this.addComponent(this.sizeAttributeCombo);
        this.addComponent(jLabel4);
        this.addComponent(this.shapeMinSizeSpinner);
        this.addComponent(jLabel5);
        this.addComponent(this.scaleTypeCombo);
        this.addComponent(jLabel6);
        this.addComponent(this.colourAttributeCombo);
        this.addComponent(jLabel7);
        this.addComponent(jButton);
        this.enableComponents(this.titleCheckBox.isSelected());
        this.titleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NodeShapeController.this.enableComponents(NodeShapeController.this.titleCheckBox.isSelected());
            }
        });
    }

    private void setupOptions() {
        this.fireControllerChanged();
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleCheckBox;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.titleCheckBox.setSelected((Boolean)map.get("nodeShape.isShown"));
        this.shapeTypeCombo.setSelectedItem((Object)NodeShapePainter.ShapeType.valueOf(map.get("nodeShape.shapeType").toString().toUpperCase()));
        this.scaleTypeCombo.setSelectedItem((Object)NodeShapePainter.ScaleType.valueOf(map.get("nodeShape.scaleType").toString().toUpperCase()));
        this.colourAttributeCombo.setSelectedItem((String)map.get("nodeShape.colourAttribute"));
        this.sizeAttributeCombo.setSelectedItem((String)map.get("nodeShape.sizeAttribute"));
        this.shapeSizeSpinner.setValue((Double)map.get("nodeShape.size"));
        this.shapeMinSizeSpinner.setValue((Double)map.get("nodeShape.minSize"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("nodeShape.isShown", this.titleCheckBox.isSelected());
        map.put("nodeShape.shapeType", this.shapeTypeCombo.getSelectedItem());
        map.put("nodeShape.scaleType", this.scaleTypeCombo.getSelectedItem());
        map.put("nodeShape.colourAttribute", this.colourAttributeCombo.getSelectedItem());
        map.put("nodeShape.sizeAttribute", this.sizeAttributeCombo.getSelectedItem());
        map.put("nodeShape.size", this.shapeSizeSpinner.getValue());
        map.put("nodeShape.minSize", this.shapeMinSizeSpinner.getValue());
    }

    public String getTitle() {
        return this.title;
    }
}

