/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import figtree.treeviewer.decorators.ColourDecorator;
import figtree.treeviewer.painters.AttributeComboHelperListener;
import figtree.treeviewer.painters.LabelPainter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComboBox;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

public class AttributeComboHelper {
    private final List<AttributeComboHelperListener> listeners = new ArrayList<AttributeComboHelperListener>();
    private boolean addingItems = false;

    public AttributeComboHelper(JComboBox jComboBox, TreeViewer treeViewer) {
        this(jComboBox, treeViewer, null, null, false, false);
    }

    public AttributeComboHelper(JComboBox jComboBox, TreeViewer treeViewer, String string) {
        this(jComboBox, treeViewer, string, null, false, false);
    }

    public AttributeComboHelper(JComboBox jComboBox, TreeViewer treeViewer, String string, LabelPainter.PainterIntent painterIntent) {
        this(jComboBox, treeViewer, string, painterIntent, false, false);
    }

    public AttributeComboHelper(JComboBox jComboBox, TreeViewer treeViewer, String string, boolean bl, boolean bl2) {
        this(jComboBox, treeViewer, string, null, bl, bl2);
    }

    public AttributeComboHelper(JComboBox jComboBox, TreeViewer treeViewer, LabelPainter.PainterIntent painterIntent) {
        this(jComboBox, treeViewer, null, painterIntent, false, false);
    }

    public AttributeComboHelper(JComboBox jComboBox, TreeViewer treeViewer, LabelPainter.PainterIntent painterIntent, boolean bl) {
        this(jComboBox, treeViewer, null, painterIntent, bl, false);
    }

    public AttributeComboHelper(final JComboBox jComboBox, final TreeViewer treeViewer, final String string, final LabelPainter.PainterIntent painterIntent, final boolean bl, final boolean bl2) {
        treeViewer.addTreeViewerListener(new TreeViewerListener(){

            @Override
            public void treeChanged() {
                List<Tree> list = treeViewer.getTrees();
                Object object = jComboBox.getSelectedItem();
                AttributeComboHelper.this.addingItems = true;
                jComboBox.removeAllItems();
                if (string != null) {
                    jComboBox.addItem(string);
                }
                if (list == null) {
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                if (painterIntent != null || bl) {
                    AttributeComboHelper.getAttributeNames(arrayList, list, painterIntent, bl);
                } else {
                    AttributeComboHelper.getAttributeNames(arrayList, list, bl2);
                }
                for (String string2 : arrayList) {
                    jComboBox.addItem(string2);
                }
                AttributeComboHelper.this.addingItems = false;
                if (object != null) {
                    jComboBox.setSelectedItem(object);
                }
            }

            @Override
            public void treeSettingsChanged() {
            }
        });
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AttributeComboHelper.this.addingItems) {
                    AttributeComboHelper.this.fireAttributeSelectionChanged();
                }
            }
        });
    }

    public static void getAttributeNames(List<String> list, Collection<? extends Tree> collection, LabelPainter.PainterIntent painterIntent, boolean bl) {
        Iterator<Iterator<Attributable>> iterator;
        Object object2 = new TreeSet();
        if (collection != null) {
            for (Tree object3 : collection) {
                if (painterIntent == LabelPainter.PainterIntent.TIP) {
                    for (Node node : object3.getExternalNodes()) {
                        object2.addAll(node.getAttributeNames());
                    }
                    for (Taxon taxon : object3.getTaxa()) {
                        object2.addAll(taxon.getAttributeNames());
                    }
                    continue;
                }
                if (painterIntent == LabelPainter.PainterIntent.NODE) {
                    for (Node node : object3.getInternalNodes()) {
                        object2.addAll(node.getAttributeNames());
                    }
                    continue;
                }
                if (painterIntent == LabelPainter.PainterIntent.RANGE) {
                    for (Node node : object3.getInternalNodes()) {
                        for (String string : node.getAttributeNames()) {
                            Object[] objectArray;
                            Object object = node.getAttribute(string);
                            if (!(object instanceof Object[]) || (objectArray = (Object[])object).length != 2 || !(objectArray[0] instanceof Number) || !(objectArray[1] instanceof Number)) continue;
                            object2.add(string);
                        }
                    }
                    continue;
                }
                for (Node node : object3.getNodes()) {
                    for (String string : node.getAttributeMap().keySet()) {
                        object2.add(string);
                    }
                }
            }
        }
        if (bl) {
            iterator = new TreeSet();
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Iterator<Attributable> iterator3 = (String)iterator2.next();
                boolean bl2 = true;
                for (Tree tree : collection) {
                    if (ColourDecorator.isNumerical(iterator3, tree.getNodes())) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                iterator.add(iterator3);
            }
            object2 = iterator;
        }
        if (painterIntent != null) {
            switch (painterIntent) {
                case TIP: {
                    list.add("Names");
                    list.add("Node ages");
                    list.add("Node heights (raw)");
                    list.add("Branch times");
                    list.add("Branch lengths (raw)");
                    break;
                }
                case NODE: {
                    if (object2.contains("!name")) {
                        list.add("Names");
                    }
                    list.add("Node ages");
                    list.add("Node heights (raw)");
                    list.add("Branch times");
                    list.add("Branch lengths (raw)");
                    break;
                }
                case BRANCH: {
                    if (object2.contains("!name")) {
                        list.add("Names");
                    }
                    list.add("Branch times");
                    list.add("Branch lengths (raw)");
                    list.add("Node ages");
                    list.add("Node heights (raw)");
                }
            }
        }
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.startsWith("!")) continue;
            list.add(string);
        }
    }

    private static void getAttributeNames(List<String> list, Collection<? extends Tree> collection, boolean bl) {
        for (Tree tree : collection) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Attributable attributable : tree.getNodes()) {
                for (String string : attributable.getAttributeNames()) {
                    if (string.startsWith("!")) continue;
                    Object object = attributable.getAttribute(string);
                    if (!(object instanceof Object[])) {
                        treeSet.add(string);
                        continue;
                    }
                    boolean bl2 = true;
                    Object[] objectArray = (Object[])object;
                    boolean bl3 = true;
                    for (Object object2 : objectArray) {
                        if (bl3 && !(object2 instanceof Integer) || !bl3 && !(object2 instanceof Double)) {
                            bl2 = false;
                            break;
                        }
                        bl3 = !bl3;
                    }
                    if (bl3) {
                        bl2 = false;
                    }
                    if (!bl2 || !bl) continue;
                    treeSet.add(string + " *");
                }
            }
            list.addAll(treeSet);
        }
    }

    public void addListener(AttributeComboHelperListener attributeComboHelperListener) {
        this.listeners.add(attributeComboHelperListener);
    }

    private void fireAttributeSelectionChanged() {
        for (AttributeComboHelperListener attributeComboHelperListener : this.listeners) {
            attributeComboHelperListener.attributeComboChanged();
        }
    }
}

