/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import figtree.treeviewer.decorators.ContinuousScale;
import figtree.treeviewer.decorators.Decorator;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import jebl.util.Attributable;

public class ContinuousStrokeDecorator
implements Decorator {
    private final ContinuousScale continuousScale;
    private final float minWidth;
    private final float maxWidth;
    private Stroke stroke = null;

    public ContinuousStrokeDecorator(ContinuousScale continuousScale, float f, float f2) throws NumberFormatException {
        this.continuousScale = continuousScale;
        this.minWidth = f;
        this.maxWidth = f2;
    }

    @Override
    public boolean allowsGradient() {
        return false;
    }

    @Override
    public Paint getPaint(Paint paint) {
        return paint;
    }

    @Override
    public Paint getPaint(Paint paint, Point2D point2D, Point2D point2D2) {
        throw new UnsupportedOperationException("This decorator doesn't support gradients");
    }

    @Override
    public Paint getFillPaint(Paint paint) {
        return paint;
    }

    @Override
    public Paint getFillPaint(Paint paint, Point2D point2D, Point2D point2D2) {
        throw new UnsupportedOperationException("This decorator doesn't support gradients");
    }

    @Override
    public Stroke getStroke(Stroke stroke) {
        if (this.stroke == null) {
            return stroke;
        }
        return this.stroke;
    }

    @Override
    public Font getFont(Font font) {
        return font;
    }

    public boolean isGradient() {
        return false;
    }

    @Override
    public void setItem(Attributable attributable, Attributable attributable2) {
        this.setAttributableItem(attributable);
    }

    @Override
    public void setItem(Object object) {
        if (object instanceof Attributable) {
            this.setAttributableItem((Attributable)object);
        }
    }

    @Override
    public void setItems(Object object, Object object2) {
        throw new UnsupportedOperationException("This decorator doesn't support gradients");
    }

    private void setAttributableItem(Attributable attributable) {
        double d = this.continuousScale.getValue(attributable);
        this.stroke = !Double.isNaN(d) ? new BasicStroke((float)(d * (double)(this.maxWidth - this.minWidth) + (double)this.minWidth)) : null;
    }

    public ContinuousScale getContinuousScale() {
        return this.continuousScale;
    }
}

