/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.treelayouts.PolarTreeLayout;
import figtree.treeviewer.treelayouts.PolarTreeLayoutController;
import figtree.treeviewer.treelayouts.RadialTreeLayout;
import figtree.treeviewer.treelayouts.RadialTreeLayoutController;
import figtree.treeviewer.treelayouts.RectilinearTreeLayout;
import figtree.treeviewer.treelayouts.RectilinearTreeLayoutController;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TreeViewerController
extends AbstractController {
    private static final String CONTROLLER_TITLE = "Layout";
    private static Preferences PREFS = Preferences.userNodeForPackage(TreeViewerController.class);
    private static final String CONTROLLER_KEY = "layout";
    private static final String LAYOUT_KEY = "layoutType";
    private static final String ZOOM_KEY = "zoom";
    private static final String EXPANSION_KEY = "expansion";
    private static String DEFAULT_LAYOUT = TreeLayoutType.RECTILINEAR.name();
    private static final int MAX_ZOOM_SLIDER = 1000;
    private static final int DELTA_ZOOM_SLIDER = 1;
    private Action resetZoomAction = new AbstractAction("Reset Zoom"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeViewerController.this.zoomSlider.setValue(0);
            TreeViewerController.this.verticalExpansionSlider.setValue(0);
        }
    };
    private Action increaseZoomAction = new AbstractAction("Zoom In"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeViewerController.this.zoomSlider.setValue(TreeViewerController.this.zoomSlider.getValue() + 1);
        }
    };
    private Action decreaseZoomAction = new AbstractAction("Zoom In"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeViewerController.this.zoomSlider.setValue(TreeViewerController.this.zoomSlider.getValue() - 1);
        }
    };
    private Action increaseVerticalExpansionAction = new AbstractAction("Expand Vertically"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeViewerController.this.verticalExpansionSlider.setValue(TreeViewerController.this.verticalExpansionSlider.getValue() + 1);
        }
    };
    private Action decreaseVerticalExpansionAction = new AbstractAction("Unexpand Vertically"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TreeViewerController.this.verticalExpansionSlider.getValue();
            if (n > 0) {
                TreeViewerController.this.verticalExpansionSlider.setValue(n - 1);
            } else {
                TreeViewerController.this.zoomSlider.setValue(TreeViewerController.this.zoomSlider.getValue() - 1);
            }
        }
    };
    private JToggleButton rectangularTreeToggle;
    private JToggleButton polarTreeToggle;
    private JToggleButton radialTreeToggle;
    private JSlider zoomSlider;
    private JSlider verticalExpansionSlider;
    private JLabel verticalExpansionLabel;
    private JSlider fishEyeSlider;
    private JLabel fishEyeLabel;
    private final JPanel layoutPanel;
    private final JLabel titleLabel;
    private final OptionsPanel optionsPanel;
    private final RectilinearTreeLayout rectilinearTreeLayout;
    private final PolarTreeLayout polarTreeLayout;
    private final RadialTreeLayout radialTreeLayout;
    private final RectilinearTreeLayoutController rectilinearTreeLayoutController;
    private final PolarTreeLayoutController polarTreeLayoutController;
    private final RadialTreeLayoutController radialTreeLayoutController;
    private final TreeViewer treeViewer;

    public TreeViewerController(final TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        TreeLayoutType treeLayoutType = TreeLayoutType.valueOf(PREFS.get("layout.layoutType", DEFAULT_LAYOUT));
        this.titleLabel = new JLabel(CONTROLLER_TITLE);
        this.optionsPanel = new ControllerOptionsPanel(2, 2);
        this.rectilinearTreeLayout = new RectilinearTreeLayout();
        this.rectilinearTreeLayoutController = new RectilinearTreeLayoutController(this.rectilinearTreeLayout);
        this.polarTreeLayout = new PolarTreeLayout();
        this.polarTreeLayoutController = new PolarTreeLayoutController(this.polarTreeLayout);
        this.radialTreeLayout = new RadialTreeLayout();
        this.radialTreeLayoutController = new RadialTreeLayoutController(this.radialTreeLayout);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        Icon icon = IconUtils.getIcon(this.getClass(), "images/rectangularTree.png");
        Icon icon2 = IconUtils.getIcon(this.getClass(), "images/polarTree.png");
        Icon icon3 = IconUtils.getIcon(this.getClass(), "images/radialTree.png");
        this.rectangularTreeToggle = new JToggleButton(icon);
        this.polarTreeToggle = new JToggleButton(icon2);
        this.radialTreeToggle = new JToggleButton(icon3);
        this.rectangularTreeToggle.setToolTipText("Rectangular tree layout");
        this.polarTreeToggle.setToolTipText("Polar tree layout");
        this.radialTreeToggle.setToolTipText("Radial tree layout");
        this.rectangularTreeToggle.setFocusable(false);
        this.polarTreeToggle.setFocusable(false);
        this.radialTreeToggle.setFocusable(false);
        this.rectangularTreeToggle.putClientProperty("Quaqua.Button.style", "toggleWest");
        this.rectangularTreeToggle.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.rectangularTreeToggle.putClientProperty("JButton.segmentPosition", "first");
        this.polarTreeToggle.putClientProperty("Quaqua.Button.style", "toggleCenter");
        this.polarTreeToggle.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.polarTreeToggle.putClientProperty("JButton.segmentPosition", "middle");
        this.radialTreeToggle.putClientProperty("Quaqua.Button.style", "toggleEast");
        this.radialTreeToggle.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.radialTreeToggle.putClientProperty("JButton.segmentPosition", "last");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rectangularTreeToggle);
        buttonGroup.add(this.polarTreeToggle);
        buttonGroup.add(this.radialTreeToggle);
        this.rectangularTreeToggle.setSelected(true);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.rectangularTreeToggle);
        jPanel.add(this.polarTreeToggle);
        jPanel.add(this.radialTreeToggle);
        jPanel.add(Box.createHorizontalGlue());
        this.optionsPanel.addSpanningComponent(jPanel);
        this.zoomSlider = new JSlider(0, 0, 1000, 0);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.setAlignmentX(0.0f);
        this.zoomSlider.setValue(0);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = TreeViewerController.this.zoomSlider.getValue();
                treeViewer.setZoom((double)n / 1000.0);
            }
        });
        this.optionsPanel.addComponentWithLabel("Zoom:", this.zoomSlider, true);
        this.verticalExpansionSlider = new JSlider(0, 0, 1000, 0);
        this.verticalExpansionSlider.setOpaque(false);
        this.verticalExpansionSlider.setValue(0);
        this.verticalExpansionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = TreeViewerController.this.verticalExpansionSlider.getValue();
                treeViewer.setVerticalExpansion((double)n / 1000.0);
            }
        });
        this.verticalExpansionLabel = new JLabel("Expansion:");
        this.optionsPanel.addComponents(this.verticalExpansionLabel, false, this.verticalExpansionSlider, true);
        this.fishEyeSlider = new JSlider(0, 0, 1000, 0);
        this.fishEyeSlider.setOpaque(false);
        this.fishEyeSlider.setValue(0);
        this.fishEyeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (double)TreeViewerController.this.fishEyeSlider.getValue() / 1000.0;
                TreeViewerController.this.rectilinearTreeLayout.setFishEye(d);
                TreeViewerController.this.polarTreeLayout.setFishEye(d);
                TreeViewerController.this.radialTreeLayout.setFishEye(d);
            }
        });
        this.fishEyeLabel = new JLabel("Fish Eye:");
        this.optionsPanel.addComponents(this.fishEyeLabel, false, this.fishEyeSlider, true);
        this.optionsPanel.addSeparator();
        this.layoutPanel = new JPanel(new BorderLayout());
        this.layoutPanel.setOpaque(false);
        this.setTreeLayout(treeLayoutType);
        this.setExpansion();
        this.optionsPanel.addSpanningComponent(this.layoutPanel);
        this.rectangularTreeToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TreeViewerController.this.rectangularTreeToggle.isSelected()) {
                    TreeViewerController.this.setTreeLayout(TreeLayoutType.RECTILINEAR);
                }
            }
        });
        this.polarTreeToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TreeViewerController.this.polarTreeToggle.isSelected()) {
                    TreeViewerController.this.setTreeLayout(TreeLayoutType.POLAR);
                }
            }
        });
        this.radialTreeToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TreeViewerController.this.radialTreeToggle.isSelected()) {
                    TreeViewerController.this.setTreeLayout(TreeLayoutType.RADIAL);
                }
            }
        });
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta 0"), "resetZoom");
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta EQUALS"), "increasePrimaryZoom");
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta MINUS"), "decreasePrimaryZoom");
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta alt EQUALS"), "increaseSecondaryZoom");
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta alt MINUS"), "decreaseSecondaryZoom");
        this.optionsPanel.getActionMap().put("resetZoom", this.resetZoomAction);
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return true;
    }

    public void setColouringAttributeName(String string) {
        this.rectilinearTreeLayout.setBranchColouringAttributeName(string);
        this.polarTreeLayout.setBranchColouringAttributeName(string);
        this.radialTreeLayout.setBranchColouringAttributeName(string);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        String string = (String)map.get("layout.layoutType");
        TreeLayoutType treeLayoutType = TreeLayoutType.valueOf(string);
        switch (treeLayoutType) {
            case RECTILINEAR: {
                this.rectangularTreeToggle.setSelected(true);
                break;
            }
            case POLAR: {
                this.polarTreeToggle.setSelected(true);
                break;
            }
            case RADIAL: {
                this.radialTreeToggle.setSelected(true);
            }
        }
        this.setTreeLayout(treeLayoutType);
        this.zoomSlider.setValue((Integer)map.get("layout.zoom"));
        this.verticalExpansionSlider.setValue((Integer)map.get("layout.expansion"));
        this.rectilinearTreeLayoutController.setSettings(map);
        this.polarTreeLayoutController.setSettings(map);
        this.radialTreeLayoutController.setSettings(map);
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        if (this.rectangularTreeToggle.isSelected()) {
            map.put("layout.layoutType", TreeLayoutType.RECTILINEAR.name());
        } else if (this.polarTreeToggle.isSelected()) {
            map.put("layout.layoutType", TreeLayoutType.POLAR.name());
        } else if (this.radialTreeToggle.isSelected()) {
            map.put("layout.layoutType", TreeLayoutType.RADIAL.name());
        }
        map.put("layout.zoom", this.zoomSlider.getValue());
        map.put("layout.expansion", this.verticalExpansionSlider.getValue());
        this.rectilinearTreeLayoutController.getSettings(map);
        this.polarTreeLayoutController.getSettings(map);
        this.radialTreeLayoutController.getSettings(map);
    }

    private void setTreeLayout(TreeLayoutType treeLayoutType) {
        switch (treeLayoutType) {
            case RECTILINEAR: {
                this.treeViewer.setTreeLayout(this.rectilinearTreeLayout);
                this.setExpansion();
                this.fishEyeLabel.setEnabled(true);
                this.fishEyeSlider.setEnabled(true);
                this.layoutPanel.removeAll();
                this.layoutPanel.add((Component)this.rectilinearTreeLayoutController.getPanel(), "Center");
                this.fireControllerChanged();
                break;
            }
            case POLAR: {
                this.treeViewer.setTreeLayout(this.polarTreeLayout);
                this.setExpansion();
                this.fishEyeLabel.setEnabled(true);
                this.fishEyeSlider.setEnabled(true);
                this.layoutPanel.removeAll();
                this.layoutPanel.add((Component)this.polarTreeLayoutController.getPanel(), "Center");
                this.fireControllerChanged();
                break;
            }
            case RADIAL: {
                this.treeViewer.setTreeLayout(this.radialTreeLayout);
                this.setExpansion();
                this.fishEyeLabel.setEnabled(false);
                this.fishEyeSlider.setEnabled(false);
                this.layoutPanel.removeAll();
                this.layoutPanel.add((Component)this.radialTreeLayoutController.getPanel(), "Center");
                this.fireControllerChanged();
                break;
            }
            default: {
                new RuntimeException("Unknown TreeLayoutType: " + (Object)((Object)treeLayoutType));
            }
        }
    }

    private void setExpansion() {
        if (this.treeViewer.verticalExpansionAllowed()) {
            this.verticalExpansionLabel.setEnabled(true);
            this.verticalExpansionSlider.setEnabled(true);
            this.optionsPanel.getActionMap().put("increasePrimaryZoom", this.increaseVerticalExpansionAction);
            this.optionsPanel.getActionMap().put("decreasePrimaryZoom", this.decreaseVerticalExpansionAction);
            this.optionsPanel.getActionMap().put("increaseSecondaryZoom", this.increaseZoomAction);
            this.optionsPanel.getActionMap().put("decreaseSecondaryZoom", this.decreaseZoomAction);
        } else {
            this.verticalExpansionLabel.setEnabled(false);
            this.verticalExpansionSlider.setEnabled(false);
            this.optionsPanel.getActionMap().put("increasePrimaryZoom", this.increaseZoomAction);
            this.optionsPanel.getActionMap().put("decreasePrimaryZoom", this.decreaseZoomAction);
            this.optionsPanel.getActionMap().put("increaseSecondaryZoom", this.increaseZoomAction);
            this.optionsPanel.getActionMap().put("decreaseSecondaryZoom", this.decreaseZoomAction);
        }
    }

    public static enum TreeLayoutType {
        RECTILINEAR("Rectangle"),
        POLAR("Polar"),
        RADIAL("Radial");

        private final String name;

        private TreeLayoutType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

