/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import jebl.evolution.trees.RootedTree;

public class TimeScale {
    private final double rootAge;
    private final double offsetAge;
    private final double scaleFactor;

    public TimeScale(double d) {
        this.rootAge = d;
        this.scaleFactor = Double.NaN;
        this.offsetAge = 0.0;
    }

    public TimeScale(double d, double d2) {
        this.rootAge = Double.NaN;
        this.offsetAge = d2;
        this.scaleFactor = d;
    }

    public double getScaleFactor(RootedTree rootedTree) {
        if (Double.isNaN(this.scaleFactor)) {
            return this.rootAge / rootedTree.getHeight(rootedTree.getRootNode());
        }
        return this.scaleFactor;
    }

    public double getAge(double d, RootedTree rootedTree) {
        return d * this.getScaleFactor(rootedTree) + this.offsetAge;
    }

    public double getTime(double d, RootedTree rootedTree) {
        return d * this.getScaleFactor(rootedTree);
    }

    public double getHeight(double d, RootedTree rootedTree) {
        return (d - this.offsetAge) / this.getScaleFactor(rootedTree);
    }

    public double getLength(double d, RootedTree rootedTree) {
        return d / this.getScaleFactor(rootedTree);
    }
}

