/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import java.text.DecimalFormat;

public class ScaleAxis {
    public static final int AT_MAJOR_TICK = 0;
    public static final int AT_MAJOR_TICK_PLUS = 1;
    public static final int AT_MINOR_TICK = 2;
    public static final int AT_MINOR_TICK_PLUS = 3;
    public static final int AT_DATA = 4;
    public static final int AT_ZERO = 5;
    public static final int AT_VALUE = 6;
    protected double minData = Double.POSITIVE_INFINITY;
    protected double maxData = Double.NEGATIVE_INFINITY;
    protected int majorTickCount;
    protected int minorTickCount;
    protected int prefMajorTickCount = 5;
    protected int prefMinorTickCount = 2;
    protected int minAxisFlag;
    protected int maxAxisFlag;
    protected double majorTick;
    protected double minorTick;
    protected double minTick;
    protected double maxTick;
    protected double minAxis;
    protected double maxAxis;
    protected double minValue;
    protected double maxValue;
    protected boolean isAutomatic = true;
    protected boolean isAutomaticTickSpacing = true;
    protected boolean isDiscrete = false;
    protected boolean labelFirst = false;
    protected boolean labelLast = false;
    protected boolean isCalibrated = false;
    protected DecimalFormat formatter = new DecimalFormat("0.0#######");
    private double epsilon;
    private int fraction;
    private static final int UNIT = 0;
    private static final int HALFS = 1;
    private static final int QUARTERS = 2;
    private static final int FIFTHS = 3;

    public ScaleAxis() {
    }

    public ScaleAxis(int n, int n2) {
        this.setAxisFlags(n, n2);
    }

    public double transform(double d) {
        return d;
    }

    public double untransform(double d) {
        return d;
    }

    public void setAxisFlags(int n, int n2) {
        this.minAxisFlag = n;
        this.maxAxisFlag = n2;
        this.isCalibrated = false;
    }

    public void setPrefNumTicks(int n, int n2) {
        this.prefMajorTickCount = n;
        this.prefMinorTickCount = n2;
        this.isCalibrated = false;
    }

    public void setIsDiscrete(boolean bl) {
        this.isDiscrete = bl;
        this.isCalibrated = false;
    }

    public void setLabelFirst(boolean bl) {
        this.labelFirst = bl;
    }

    public void setLabelLast(boolean bl) {
        this.labelLast = bl;
    }

    public void setFormatter(DecimalFormat decimalFormat) {
        this.formatter = decimalFormat;
    }

    public boolean getLabelFirst() {
        if (this.getMinorTickCount(-1) == 0) {
            return false;
        }
        return this.labelFirst;
    }

    public boolean getLabelLast() {
        if (this.getMinorTickCount(this.majorTickCount - 1) == 0) {
            return false;
        }
        return this.labelLast;
    }

    public void setManualRange(double d, double d2) {
        this.minValue = d;
        this.maxValue = d2;
        this.isCalibrated = false;
    }

    public void setManualAxis(double d, double d2) {
        this.majorTick = d;
        this.minorTick = d2;
        this.isAutomatic = true;
        this.isAutomaticTickSpacing = false;
        this.isCalibrated = false;
    }

    public void setManualAxis(double d, double d2, double d3, double d4) {
        this.minTick = d;
        this.maxTick = d2;
        this.majorTick = d3;
        this.minorTick = d4;
        this.majorTickCount = (int)((d2 - d) / d3) + 1;
        this.minorTickCount = (int)(d3 / d4) - 1;
        this.isAutomatic = false;
        this.isAutomaticTickSpacing = false;
        this.isCalibrated = false;
    }

    public void setAutomatic() {
        this.setAutomatic(0, 0);
    }

    public void setAutomatic(int n, int n2) {
        this.setAxisFlags(n, n2);
        this.isAutomatic = true;
        this.isAutomaticTickSpacing = true;
        this.isCalibrated = false;
    }

    public void setRange(double d, double d2) {
        if (!Double.isNaN(d)) {
            this.minData = d;
        }
        if (!Double.isNaN(d2)) {
            this.maxData = d2;
        }
        this.isCalibrated = false;
    }

    public void addRange(double d, double d2) {
        if (!Double.isNaN(d2) && d2 > this.maxData) {
            this.maxData = d2;
        }
        if (!Double.isNaN(d) && d < this.minData) {
            this.minData = d;
        }
        this.isCalibrated = false;
    }

    public static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public void calibrate() {
        double d = this.minData;
        double d2 = this.maxData;
        if (this.minAxisFlag == 5) {
            d = 0.0;
        } else if (this.minAxisFlag == 6) {
            d = this.minValue;
        }
        if (this.maxAxisFlag == 5) {
            d2 = 0.0;
        } else if (this.maxAxisFlag == 6) {
            d2 = this.maxValue;
        }
        double d3 = d2 - d;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        this.epsilon = d3 * 1.0E-10;
        if (this.isAutomatic) {
            if (d3 < 1.0E-30) {
                if (this.minData < 0.0) {
                    if (this.isAutomaticTickSpacing) {
                        this.majorTick = Math.pow(10.0, Math.floor(ScaleAxis.log10(Math.abs(this.minData))));
                    }
                    this.minTick = Math.floor(this.minData / this.majorTick) * this.majorTick;
                    this.maxTick = 0.0;
                } else if (this.minData > 0.0) {
                    if (this.isAutomaticTickSpacing) {
                        this.majorTick = Math.pow(10.0, Math.floor(ScaleAxis.log10(Math.abs(this.minData))));
                    }
                    this.minTick = 0.0;
                    this.maxTick = Math.ceil(this.maxData / this.majorTick) * this.majorTick;
                } else {
                    if (this.isAutomaticTickSpacing) {
                        this.majorTick = 1.0;
                    }
                    this.minTick = -1.0;
                    this.maxTick = 1.0;
                }
                if (this.isAutomaticTickSpacing) {
                    this.minorTick = this.majorTick;
                }
                this.majorTickCount = 1;
                this.minorTickCount = 0;
            } else {
                if (this.isAutomaticTickSpacing) {
                    this.majorTick = Math.pow(10.0, Math.floor(ScaleAxis.log10(d3)));
                }
                this.calcMinTick();
                this.calcMaxTick();
                this.majorTickCount = (int)(this.maxTick - this.minTick / this.majorTick);
                this.minorTickCount = (int)(this.majorTick / this.minorTick);
                if (this.isAutomaticTickSpacing) {
                    this.calcMajorTick();
                    this.calcMinorTick();
                }
            }
        }
        this.minAxis = this.minTick;
        this.maxAxis = this.maxTick;
        this.handleAxisFlags();
        this.isCalibrated = true;
    }

    public void calcMinTick() {
        this.minTick = this.minData == 0.0 ? 0.0 : Math.floor(this.minData / this.majorTick) * this.majorTick;
    }

    public void calcMaxTick() {
        this.maxTick = this.maxData == 0.0 ? 0.0 : (this.maxData < 0.0 ? -Math.floor(-this.maxData / this.majorTick) * this.majorTick : Math.ceil(this.maxData / this.majorTick) * this.majorTick);
    }

    public void calcMajorTick() {
        this.fraction = 0;
        double d = this.majorTick;
        double d2 = this.maxTick - this.minTick;
        this.majorTickCount = (int)(d2 / d);
        while (this.majorTickCount < this.prefMajorTickCount) {
            d = this.majorTick / 2.0;
            if (!this.isDiscrete || d == Math.floor(d)) {
                this.majorTickCount = (int)(d2 / d);
                this.fraction = 1;
                if (this.majorTickCount >= this.prefMajorTickCount) break;
            }
            d = this.majorTick / 4.0;
            if (!this.isDiscrete || d == Math.floor(d)) {
                this.majorTickCount = (int)(d2 / d);
                this.fraction = 2;
                if (this.majorTickCount >= this.prefMajorTickCount) break;
            }
            d = this.majorTick / 5.0;
            if (!this.isDiscrete || d == Math.floor(d)) {
                this.majorTickCount = (int)(d2 / d);
                this.fraction = 3;
                if (this.majorTickCount >= this.prefMajorTickCount) break;
            }
            if (this.isDiscrete && this.majorTick / 10.0 != Math.floor(this.majorTick / 10.0)) {
                d = this.majorTick;
                this.majorTickCount = (int)(d2 / d);
                break;
            }
            this.majorTick /= 10.0;
            d = this.majorTick;
            this.majorTickCount = (int)(d2 / d);
            this.fraction = 0;
        }
        this.majorTick = d;
        if (this.isDiscrete && this.majorTick < 1.0) {
            this.majorTick = 1.0;
            this.majorTickCount = (int)(d2 / this.majorTick);
            this.fraction = 0;
        }
        ++this.majorTickCount;
        while (this.minTick + this.majorTick - this.epsilon < this.minData) {
            this.minTick += this.majorTick;
            --this.majorTickCount;
        }
        while (this.maxTick - this.majorTick + this.epsilon > this.maxData) {
            this.maxTick -= this.majorTick;
            --this.majorTickCount;
        }
    }

    public void calcMinorTick() {
        double d = this.minorTick = this.majorTick;
        double d2 = this.majorTick;
        this.minorTickCount = (int)(d2 / d);
        while (this.minorTickCount < this.prefMinorTickCount) {
            if (this.fraction != 2) {
                d = this.minorTick / 2.0;
                if (!this.isDiscrete || d == Math.floor(d)) {
                    this.minorTickCount = (int)(d2 / d);
                    if (this.minorTickCount >= this.prefMinorTickCount) break;
                }
                d = this.minorTick / 4.0;
                if (!this.isDiscrete || d == Math.floor(d)) {
                    this.minorTickCount = (int)(d2 / d);
                    if (this.minorTickCount >= this.prefMinorTickCount) break;
                }
            }
            d = this.minorTick / 5.0;
            if (!this.isDiscrete || d == Math.floor(d)) {
                this.minorTickCount = (int)(d2 / d);
                if (this.minorTickCount >= this.prefMinorTickCount) break;
            }
            if (this.isDiscrete && this.minorTick / 10.0 != Math.floor(this.minorTick / 10.0)) {
                d = this.minorTick;
                this.minorTickCount = (int)(d2 / d);
                break;
            }
            this.minorTick /= 10.0;
            d = this.minorTick;
            this.minorTickCount = (int)(d2 / d);
        }
        this.minorTick = d;
        --this.minorTickCount;
    }

    public void handleAxisFlags() {
        if ((this.minAxisFlag == 1 || this.minAxisFlag == 3) && this.minAxis == this.minData) {
            ++this.majorTickCount;
            this.minTick -= this.majorTick;
            this.minAxis = this.minTick;
        }
        if (this.minAxisFlag == 3) {
            if (this.minAxis + this.minorTick < this.minData) {
                --this.majorTickCount;
                this.minTick += this.majorTick;
                while (this.minAxis + this.minorTick < this.minData) {
                    this.minAxis += this.minorTick;
                }
            }
        } else if (this.minAxisFlag == 2) {
            if (this.minAxis + this.minorTick <= this.minData) {
                --this.majorTickCount;
                this.minTick += this.majorTick;
                while (this.minAxis + this.minorTick <= this.minData) {
                    this.minAxis += this.minorTick;
                }
            }
        } else if (this.minAxisFlag == 4) {
            if (this.minTick < this.minData) {
                --this.majorTickCount;
                this.minTick += this.majorTick;
            }
            this.minAxis = this.minData;
        } else if (this.minAxisFlag == 6) {
            if (this.minTick < this.minValue) {
                --this.majorTickCount;
                this.minTick += this.majorTick;
            }
            this.minAxis = this.minValue;
        } else if (this.minAxisFlag == 5) {
            this.majorTickCount += (int)(this.minTick / this.majorTick);
            this.minTick = 0.0;
            this.minAxis = 0.0;
        }
        if ((this.maxAxisFlag == 1 || this.maxAxisFlag == 3) && this.maxAxis == this.maxData) {
            ++this.majorTickCount;
            this.maxTick += this.majorTick;
            this.maxAxis = this.maxTick;
        }
        if (this.maxAxisFlag == 3) {
            if (this.maxAxis - this.minorTick > this.maxData) {
                --this.majorTickCount;
                this.maxTick -= this.majorTick;
                while (this.maxAxis - this.minorTick > this.maxData) {
                    this.maxAxis -= this.minorTick;
                }
            }
        } else if (this.maxAxisFlag == 2) {
            if (this.maxAxis - this.minorTick >= this.maxData) {
                --this.majorTickCount;
                this.maxTick -= this.majorTick;
                while (this.maxAxis - this.minorTick >= this.maxData) {
                    this.maxAxis -= this.minorTick;
                }
            }
        } else if (this.maxAxisFlag == 4) {
            if (this.maxTick > this.maxData) {
                --this.majorTickCount;
                this.maxTick -= this.majorTick;
            }
            this.maxAxis = this.maxData;
        } else if (this.maxAxisFlag == 6) {
            if (this.maxTick > this.maxValue) {
                --this.majorTickCount;
                this.maxTick -= this.majorTick;
            }
            this.maxAxis = this.maxValue;
        } else if (this.maxAxisFlag == 5) {
            this.majorTickCount += (int)(-this.maxTick / this.majorTick);
            this.maxTick = 0.0;
            this.maxTick = 0.0;
        }
    }

    public double scaleValue(double d) {
        if (!this.isCalibrated) {
            this.calibrate();
        }
        double d2 = (this.transform(d) - this.transform(this.minAxis)) / (this.transform(this.maxAxis) - this.transform(this.minAxis));
        return d2;
    }

    public DecimalFormat getFormatter() {
        return this.formatter;
    }

    public double getMinAxis() {
        if (!this.isCalibrated) {
            this.calibrate();
        }
        return this.minAxis;
    }

    public double getMaxAxis() {
        if (!this.isCalibrated) {
            this.calibrate();
        }
        return this.maxAxis;
    }

    public double getMinData() {
        return this.minData;
    }

    public double getMaxData() {
        return this.maxData;
    }

    public int getMajorTickCount() {
        if (!this.isCalibrated) {
            this.calibrate();
        }
        return this.majorTickCount;
    }

    public int getMinorTickCount(int n) {
        if (!this.isCalibrated) {
            this.calibrate();
        }
        if (n == this.majorTickCount - 1) {
            return (int)((this.maxAxis - this.maxTick) / this.minorTick);
        }
        if (n == -1) {
            return (int)((this.minTick - this.minAxis) / this.minorTick);
        }
        return this.minorTickCount;
    }

    public double getMajorTickValue(int n) {
        if (!this.isCalibrated) {
            this.calibrate();
        }
        return (double)n * this.majorTick + this.minTick;
    }

    public double getMinorTickValue(int n, int n2) {
        if (!this.isCalibrated) {
            this.calibrate();
        }
        if (n2 == -1) {
            return this.minTick - (double)(n + 1) * this.minorTick;
        }
        return (double)(n + 1) * this.minorTick + this.getMajorTickValue(n2);
    }

    public double getMajorTickSpacing() {
        if (!this.isCalibrated) {
            this.calibrate();
        }
        return this.majorTick;
    }

    public double getMinorTickSpacing() {
        if (!this.isCalibrated) {
            this.calibrate();
        }
        return this.minorTick;
    }
}

