/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.MultiPaneTreeViewer;
import figtree.treeviewer.TreeViewerListener;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jebl.evolution.trees.Tree;

public class MultiPaneTreeViewerController
extends AbstractController {
    private final JLabel titleLabel = new JLabel("Current Tree");
    private final OptionsPanel optionsPanel = new ControllerOptionsPanel(2, 2);

    public MultiPaneTreeViewerController(final MultiPaneTreeViewer multiPaneTreeViewer) {
        final JLabel jLabel = new JLabel("Tree 1");
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 1, 1);
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                multiPaneTreeViewer.showTree((Integer)spinnerNumberModel.getValue() - 1);
            }
        });
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8"});
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                multiPaneTreeViewer.setTreesPerPage(jComboBox.getSelectedIndex() + 1);
            }
        });
        multiPaneTreeViewer.addTreeViewerListener(new TreeViewerListener(){

            @Override
            public void treeChanged() {
                int n = multiPaneTreeViewer.getCurrentTreeIndex() + 1;
                int n2 = multiPaneTreeViewer.getTrees().size();
                Tree tree = multiPaneTreeViewer.getCurrentTree();
                spinnerNumberModel.setValue(n);
                spinnerNumberModel.setMaximum(Integer.valueOf(n2));
                String string = (String)tree.getAttribute("name");
                if (string != null) {
                    jLabel.setText(string);
                } else {
                    jLabel.setText("Tree " + n);
                }
                MultiPaneTreeViewerController.this.titleLabel.setText("Current Tree: " + n + " / " + n2);
            }

            @Override
            public void treeSettingsChanged() {
            }
        });
        this.optionsPanel.addComponentWithLabel("Name:", jLabel);
        this.optionsPanel.addComponentWithLabel("Tree:", jSpinner);
        this.optionsPanel.addComponentWithLabel("Trees per page:", jComboBox);
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return true;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
    }

    @Override
    public void getSettings(Map<String, Object> map) {
    }
}

